/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.ArrayList;
import java.util.Enumeration;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class DenseInstance
extends AbstractInstance {
    static final long serialVersionUID = 1482635194499365122L;

    public DenseInstance(Instance instance) {
        this.m_AttValues = instance instanceof DenseInstance ? ((DenseInstance)instance).m_AttValues : instance.toDoubleArray();
        this.m_Weight = instance.weight();
        this.m_Dataset = null;
    }

    public DenseInstance(double weight, double[] attValues) {
        this.m_AttValues = attValues;
        this.m_Weight = weight;
        this.m_Dataset = null;
    }

    public DenseInstance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Utils.missingValue();
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    @Override
    public Object copy() {
        DenseInstance result = new DenseInstance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    @Override
    public int index(int position) {
        return position;
    }

    @Override
    public Instance mergeInstance(Instance inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.value(j);
            ++j;
            ++m;
        }
        return new DenseInstance(1.0, newVals);
    }

    @Override
    public int numAttributes() {
        return this.m_AttValues.length;
    }

    @Override
    public int numValues() {
        return this.m_AttValues.length;
    }

    @Override
    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.m_AttValues[i] = array[i];
        }
    }

    @Override
    public void setValue(int attIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[attIndex] = value;
    }

    @Override
    public void setValueSparse(int indexOfIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[indexOfIndex] = value;
    }

    @Override
    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, this.m_AttValues.length);
        return newValues;
    }

    @Override
    public String toStringNoWeight() {
        return this.toStringNoWeight(AbstractInstance.s_numericAfterDecimalPoint);
    }

    @Override
    public String toStringNoWeight(int afterDecimalPoint) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i, afterDecimalPoint));
        }
        return text.toString();
    }

    @Override
    public double value(int attIndex) {
        return this.m_AttValues[attIndex];
    }

    @Override
    protected void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        if (position < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, position + 1, newValues, position, this.m_AttValues.length - (position + 1));
        }
        this.m_AttValues = newValues;
    }

    @Override
    protected void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        newValues[position] = Utils.missingValue();
        System.arraycopy(this.m_AttValues, position, newValues, position + 1, this.m_AttValues.length - position);
        this.m_AttValues = newValues;
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }

    public static void main(String[] options) {
        try {
            Attribute length = new Attribute("length");
            Attribute weight = new Attribute("weight");
            ArrayList<String> my_nominal_values = new ArrayList<String>(3);
            my_nominal_values.add("first");
            my_nominal_values.add("second");
            my_nominal_values.add("third");
            Attribute position = new Attribute("position", my_nominal_values);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
            attributes.add(length);
            attributes.add(weight);
            attributes.add(position);
            Instances race = new Instances("race", attributes, 0);
            race.setClassIndex(position.index());
            DenseInstance inst = new DenseInstance(3);
            inst.setValue(length, 5.3);
            inst.setValue(weight, 300.0);
            inst.setValue(position, "first");
            inst.setDataset(race);
            System.out.println("The instance: " + inst);
            System.out.println("First attribute: " + inst.attribute(0));
            System.out.println("Class attribute: " + inst.classAttribute());
            System.out.println("Class index: " + inst.classIndex());
            System.out.println("Class is missing: " + inst.classIsMissing());
            System.out.println("Class value (internal format): " + inst.classValue());
            Instance copy = (Instance)inst.copy();
            System.out.println("Shallow copy: " + copy);
            copy.setDataset(inst.dataset());
            System.out.println("Shallow copy with dataset set: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(0);
            copy.insertAttributeAt(0);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + copy);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration enu = inst.enumerateAttributes();
            while (enu.hasMoreElements()) {
                Attribute att = (Attribute)enu.nextElement();
                System.out.println(att);
            }
            System.out.println("Header of original and copy equivalent: " + inst.equalHeaders(copy));
            System.out.println("Length of copy missing: " + copy.isMissing(length));
            System.out.println("Weight of copy missing: " + copy.isMissing(weight.index()));
            System.out.println("Length of copy missing: " + Utils.isMissingValue(copy.value(length)));
            System.out.println("Number of attributes: " + copy.numAttributes());
            System.out.println("Number of classes: " + copy.numClasses());
            double[] meansAndModes = new double[]{2.0, 3.0, 0.0};
            copy.replaceMissingValues(meansAndModes);
            System.out.println("Copy with missing value replaced: " + copy);
            copy.setClassMissing();
            System.out.println("Copy with missing class: " + copy);
            copy.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + copy);
            copy.setClassValue("third");
            System.out.println("Copy with class value set to \"third\": " + copy);
            copy.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + copy);
            copy.setMissing(length);
            System.out.println("Copy with length set to be missing: " + copy);
            copy.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + copy);
            copy.setValue(weight, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + copy);
            copy.setValue(position, "second");
            System.out.println("Copy with position set to \"second\": " + copy);
            copy.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + copy);
            System.out.println("Current weight of instance copy: " + copy.weight());
            copy.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + copy.weight());
            System.out.println("Last value of copy: " + copy.toString(2));
            System.out.println("Value of position for copy: " + copy.toString(position));
            System.out.println("Last value of copy (internal format): " + copy.value(2));
            System.out.println("Value of position for copy (internal format): " + copy.value(position));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9028 $");
    }
}

