/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class DBScan
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1666498248451219728L;
    private double epsilon = 0.9;
    private int minPoints = 6;
    private ReplaceMissingValues replaceMissingValues_Filter;
    private int numberOfGeneratedClusters;
    private String database_distanceType = "weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject";
    private String database_Type = "weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase";
    private Database database;
    private int clusterID;
    private int processed_InstanceID;
    private double elapsedTime;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    @Override
    public void buildClusterer(Instances instances) throws Exception {
        DataObject dataObject;
        this.getCapabilities().testWithFail(instances);
        long time_1 = System.currentTimeMillis();
        this.processed_InstanceID = 0;
        this.numberOfGeneratedClusters = 0;
        this.clusterID = 0;
        this.replaceMissingValues_Filter = new ReplaceMissingValues();
        this.replaceMissingValues_Filter.setInputFormat(instances);
        Instances filteredInstances = Filter.useFilter(instances, this.replaceMissingValues_Filter);
        this.database = this.databaseForName(this.getDatabase_Type(), filteredInstances);
        for (int i = 0; i < this.database.getInstances().numInstances(); ++i) {
            dataObject = this.dataObjectForName(this.getDatabase_distanceType(), this.database.getInstances().instance(i), Integer.toString(i), this.database);
            this.database.insert(dataObject);
        }
        this.database.setMinMaxValues();
        Iterator iterator = this.database.dataObjectIterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            if (dataObject.getClusterLabel() != -1 || !this.expandCluster(dataObject)) continue;
            ++this.clusterID;
            ++this.numberOfGeneratedClusters;
        }
        long time_2 = System.currentTimeMillis();
        this.elapsedTime = (double)(time_2 - time_1) / 1000.0;
    }

    private boolean expandCluster(DataObject dataObject) {
        DataObject seedListDataObject;
        List seedList = this.database.epsilonRangeQuery(this.getEpsilon(), dataObject);
        if (seedList.size() < this.getMinPoints()) {
            dataObject.setClusterLabel(Integer.MIN_VALUE);
            return false;
        }
        for (int i = 0; i < seedList.size(); ++i) {
            seedListDataObject = (DataObject)seedList.get(i);
            seedListDataObject.setClusterLabel(this.clusterID);
            if (!seedListDataObject.equals(dataObject)) continue;
            seedList.remove(i);
            --i;
        }
        for (int j = 0; j < seedList.size(); ++j) {
            seedListDataObject = (DataObject)seedList.get(j);
            List seedListDataObject_Neighbourhood = this.database.epsilonRangeQuery(this.getEpsilon(), seedListDataObject);
            if (seedListDataObject_Neighbourhood.size() >= this.getMinPoints()) {
                for (int i = 0; i < seedListDataObject_Neighbourhood.size(); ++i) {
                    DataObject p = (DataObject)seedListDataObject_Neighbourhood.get(i);
                    if (p.getClusterLabel() != -1 && p.getClusterLabel() != Integer.MIN_VALUE) continue;
                    if (p.getClusterLabel() == -1) {
                        seedList.add(p);
                    }
                    p.setClusterLabel(this.clusterID);
                }
            }
            seedList.remove(j);
            --j;
        }
        return true;
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        int cnum;
        if (this.processed_InstanceID >= this.database.size()) {
            this.processed_InstanceID = 0;
        }
        if ((cnum = this.database.getDataObject(Integer.toString(this.processed_InstanceID++)).getClusterLabel()) == Integer.MIN_VALUE) {
            throw new Exception();
        }
        return cnum;
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.numberOfGeneratedClusters;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tepsilon (default = 0.9)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tminPoints (default = 6)", "M", 1, "-M <int>"));
        vector.addElement(new Option("\tindex (database) used for DBScan (default = weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase)", "I", 1, "-I <String>"));
        vector.addElement(new Option("\tdistance-type (default = weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject)", "D", 1, "-D <String>"));
        return vector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            this.setEpsilon(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('M', options)).length() != 0) {
            this.setMinPoints(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('I', options)).length() != 0) {
            this.setDatabase_Type(optionString);
        }
        if ((optionString = Utils.getOption('D', options)).length() != 0) {
            this.setDatabase_distanceType(optionString);
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[8];
        int current = 0;
        options[current++] = "-E";
        options[current++] = "" + this.getEpsilon();
        options[current++] = "-M";
        options[current++] = "" + this.getMinPoints();
        options[current++] = "-I";
        options[current++] = "" + this.getDatabase_Type();
        options[current++] = "-D";
        options[current++] = "" + this.getDatabase_distanceType();
        return options;
    }

    public Database databaseForName(String database_Type, Instances instances) {
        Object o = null;
        Constructor<?> co = null;
        try {
            co = Class.forName(database_Type).getConstructor(Instances.class);
            o = co.newInstance(instances);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return o;
    }

    public DataObject dataObjectForName(String database_distanceType, Instance instance, String key, Database database) {
        Object o = null;
        Constructor<?> co = null;
        try {
            co = Class.forName(database_distanceType).getConstructor(Instance.class, String.class, Database.class);
            o = co.newInstance(instance, key, database);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return o;
    }

    public void setMinPoints(int minPoints) {
        this.minPoints = minPoints;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getMinPoints() {
        return this.minPoints;
    }

    public String getDatabase_distanceType() {
        return this.database_distanceType;
    }

    public String getDatabase_Type() {
        return this.database_Type;
    }

    public void setDatabase_distanceType(String database_distanceType) {
        this.database_distanceType = database_distanceType;
    }

    public void setDatabase_Type(String database_Type) {
        this.database_Type = database_Type;
    }

    public String epsilonTipText() {
        return "radius of the epsilon-range-queries";
    }

    public String minPointsTipText() {
        return "minimun number of DataObjects required in an epsilon-range-query";
    }

    public String database_TypeTipText() {
        return "used database";
    }

    public String database_distanceTypeTipText() {
        return "used distance-type";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Martin Ester and Hans-Peter Kriegel and Joerg Sander and Xiaowei Xu");
        result.setValue(TechnicalInformation.Field.TITLE, "A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Second International Conference on Knowledge Discovery and Data Mining");
        result.setValue(TechnicalInformation.Field.EDITOR, "Evangelos Simoudis and Jiawei Han and Usama M. Fayyad");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.PAGES, "226-231");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return result;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DBScan clustering results\n========================================================================================\n\n");
        stringBuffer.append("Clustered DataObjects: " + this.database.size() + "\n");
        stringBuffer.append("Number of attributes: " + this.database.getInstances().numAttributes() + "\n");
        stringBuffer.append("Epsilon: " + this.getEpsilon() + "; minPoints: " + this.getMinPoints() + "\n");
        stringBuffer.append("Index: " + this.getDatabase_Type() + "\n");
        stringBuffer.append("Distance-type: " + this.getDatabase_distanceType() + "\n");
        stringBuffer.append("Number of generated clusters: " + this.numberOfGeneratedClusters + "\n");
        DecimalFormat decimalFormat = new DecimalFormat(".##");
        stringBuffer.append("Elapsed time: " + decimalFormat.format(this.elapsedTime) + "\n\n");
        for (int i = 0; i < this.database.size(); ++i) {
            DataObject dataObject = this.database.getDataObject(Integer.toString(i));
            stringBuffer.append("(" + Utils.doubleToString(Double.parseDouble(dataObject.getKey()), Integer.toString(this.database.size()).length(), 0) + ".) " + Utils.padRight(dataObject.toString(), 69) + "  -->  " + (dataObject.getClusterLabel() == Integer.MIN_VALUE ? "NOISE\n" : dataObject.getClusterLabel() + "\n"));
        }
        return stringBuffer.toString() + "\n";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] args) {
        DBScan.runClusterer(new DBScan(), args);
    }
}

