/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.shapelet_trees;

import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class KruskalWallisTree
extends AbstractClassifier {
    private ShapeletNode root = new ShapeletNode();
    private String logFileName;
    private int minLength;
    private int maxLength;

    public KruskalWallisTree(String logFileName) throws Exception {
        this.logFileName = logFileName;
        FileWriter fw = new FileWriter(logFileName);
        fw.close();
    }

    public void setShapeletMinMaxLength(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.minLength < 1 || this.maxLength < 1) {
            throw new Exception("Shapelet minimum or maximum length is incorrectly specified!");
        }
        this.root.initialiseNode(data, this.minLength, this.maxLength, 0);
    }

    @Override
    public double classifyInstance(Instance instance) {
        return this.root.classifyInstance(instance);
    }

    private Shapelet getRootShapelet() {
        return this.root.shapelet;
    }

    public double timingForSingleShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        long startTime = System.nanoTime();
        this.findBestShapelet(data, minShapeletLength, maxShapeletLength);
        long finishTime = System.nanoTime();
        return (double)(finishTime - startTime) / 1.0E9;
    }

    private Shapelet findBestShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        Shapelet bestShapelet = null;
        TreeMap<Double, Integer> classDistributions = KruskalWallisTree.getClassDistributions(data);
        System.out.println("Processing data: ");
        for (int i = 0; i < data.numInstances(); ++i) {
            double[] wholeCandidate = data.instance(i).toDoubleArray();
            for (int length = minShapeletLength; length <= maxShapeletLength; ++length) {
                for (int start = 0; start <= wholeCandidate.length - length - 1; ++start) {
                    double[] candidate = new double[length];
                    for (int m = start; m < start + length; ++m) {
                        candidate[m - start] = wholeCandidate[m];
                    }
                    candidate = KruskalWallisTree.zNorm(candidate, false);
                    Shapelet candidateShapelet = KruskalWallisTree.checkCandidate(candidate, data, i, start, classDistributions);
                    if (bestShapelet != null && candidateShapelet.compareTo(bestShapelet) >= 0) continue;
                    bestShapelet = candidateShapelet;
                }
            }
        }
        bestShapelet.calculateBestSplitPoint(classDistributions);
        return bestShapelet;
    }

    private static ArrayList<Shapelet> removeSelfSimilar(ArrayList<Shapelet> shapelets) {
        int i;
        ArrayList<Shapelet> outputShapelets = new ArrayList<Shapelet>();
        boolean[] selfSimilar = new boolean[shapelets.size()];
        for (i = 0; i < shapelets.size(); ++i) {
            selfSimilar[i] = false;
        }
        for (i = 0; i < shapelets.size(); ++i) {
            if (selfSimilar[i]) continue;
            outputShapelets.add(shapelets.get(i));
            for (int j = i + 1; j < shapelets.size(); ++j) {
                if (selfSimilar[j] || !KruskalWallisTree.selfSimilarity(shapelets.get(i), shapelets.get(j))) continue;
                selfSimilar[j] = true;
            }
        }
        return outputShapelets;
    }

    private ArrayList<Shapelet> combine(int k, ArrayList<Shapelet> kBestSoFar, ArrayList<Shapelet> timeSeriesShapelets) {
        int i;
        ArrayList<Shapelet> newBestSoFar = new ArrayList<Shapelet>();
        for (i = 0; i < timeSeriesShapelets.size(); ++i) {
            kBestSoFar.add(timeSeriesShapelets.get(i));
        }
        Collections.sort(kBestSoFar);
        if (kBestSoFar.size() < k) {
            return kBestSoFar;
        }
        for (i = 0; i < k; ++i) {
            newBestSoFar.add(kBestSoFar.get(i));
        }
        return newBestSoFar;
    }

    private static TreeMap<Double, Integer> getClassDistributions(Instances data) {
        TreeMap<Double, Integer> classDistribution = new TreeMap<Double, Integer>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double classValue = data.instance(i).classValue();
            boolean classExists = false;
            for (Double d : classDistribution.keySet()) {
                if (d != classValue) continue;
                int temp = classDistribution.get(d);
                classDistribution.put(classValue, ++temp);
                classExists = true;
            }
            if (classExists) continue;
            classDistribution.put(classValue, 1);
        }
        return classDistribution;
    }

    private static Shapelet checkCandidate(double[] candidate, Instances data, int seriesId, int startPos, TreeMap classDistribution) {
        ArrayList<OrderLineObj> orderline = new ArrayList<OrderLineObj>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double distance = KruskalWallisTree.subsequenceDistance(candidate, data.instance(i));
            double classVal = data.instance(i).classValue();
            boolean added = false;
            if (orderline.isEmpty()) {
                orderline.add(new OrderLineObj(distance, classVal));
                added = true;
            } else {
                for (int j = 0; j < orderline.size(); ++j) {
                    if (added || !(((OrderLineObj)orderline.get(j)).distance > distance)) continue;
                    orderline.add(j, new OrderLineObj(distance, classVal));
                    added = true;
                }
            }
            if (added) continue;
            orderline.add(new OrderLineObj(distance, classVal));
        }
        Shapelet shapelet = new Shapelet(candidate, seriesId, startPos);
        shapelet.calculateKruskalWallis(orderline);
        return shapelet;
    }

    public static double subsequenceDistance(double[] candidate, Instance timeSeriesIns) {
        double[] timeSeries = timeSeriesIns.toDoubleArray();
        return KruskalWallisTree.subsequenceDistance(candidate, timeSeries);
    }

    public static double subsequenceDistance(double[] candidate, double[] timeSeries) {
        double bestSum = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i <= timeSeries.length - candidate.length - 1; ++i) {
            int j;
            sum = 0.0;
            double[] subseq = new double[candidate.length];
            for (j = i; j < i + candidate.length; ++j) {
                subseq[j - i] = timeSeries[j];
            }
            subseq = KruskalWallisTree.zNorm(subseq, false);
            for (j = 0; j < candidate.length; ++j) {
                sum += (candidate[j] - subseq[j]) * (candidate[j] - subseq[j]);
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        return 1.0 / (double)candidate.length * bestSum;
    }

    public static double[] zNorm(double[] input, boolean classValOn) {
        double classValPenalty = 0.0;
        if (classValOn) {
            classValPenalty = 1.0;
        }
        double[] output = new double[input.length];
        double seriesTotal = 0.0;
        int i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            seriesTotal += input[i];
            ++i;
        }
        double mean = seriesTotal / ((double)input.length - classValPenalty);
        double stdv = 0.0;
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            stdv += (input[i] - mean) * (input[i] - mean);
            ++i;
        }
        stdv = stdv / (double)input.length - classValPenalty;
        stdv = Math.sqrt(stdv);
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            output[i] = (input[i] - mean) / stdv;
            ++i;
        }
        if (classValOn) {
            output[output.length - 1] = input[input.length - 1];
        }
        return output;
    }

    public static Instances loadData(String fileName) {
        Instances data = null;
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method loadData");
        }
        return data;
    }

    private static boolean selfSimilarity(Shapelet shapelet, Shapelet candidate) {
        if (candidate.seriesId == shapelet.seriesId) {
            if (candidate.startPos >= shapelet.startPos && candidate.startPos < shapelet.startPos + shapelet.content.length) {
                return true;
            }
            if (shapelet.startPos >= candidate.startPos && shapelet.startPos < candidate.startPos + candidate.content.length) {
                return true;
            }
        }
        return false;
    }

    private static void assignRanks(ArrayList<OrderLineObj> input) {
        double lastDistance = input.get(0).distance;
        double thisDistance = input.get(0).distance;
        input.get(0).rank = 1.0;
        int duplicateCount = 0;
        for (int i = 1; i < input.size(); ++i) {
            int j;
            double avgRank;
            double maxRank;
            double minRank;
            thisDistance = input.get(i).distance;
            if (duplicateCount == 0 && thisDistance != lastDistance) {
                input.get(i).rank = i + 1;
            } else if (duplicateCount > 0 && thisDistance != lastDistance) {
                minRank = i - duplicateCount;
                maxRank = i;
                avgRank = (minRank + maxRank) / 2.0;
                for (j = i - duplicateCount - 1; j < i; ++j) {
                    input.get(j).rank = avgRank;
                }
                duplicateCount = 0;
                input.get(i).rank = i + 1;
            } else if (thisDistance == lastDistance) {
                if (i == input.size() - 1) {
                    minRank = i - duplicateCount;
                    maxRank = i + 1;
                    avgRank = (minRank + maxRank) / 2.0;
                    for (j = i - duplicateCount - 1; j <= i; ++j) {
                        input.get(j).rank = avgRank;
                    }
                }
                ++duplicateCount;
            } else {
                System.out.println("ERRORZ");
            }
            lastDistance = thisDistance;
        }
    }

    private static class OrderLineObj
    implements Comparable<OrderLineObj> {
        private double distance;
        private double classVal;
        private double rank;

        private OrderLineObj(double distance, double classVal) {
            this.distance = distance;
            this.classVal = classVal;
            this.rank = -1.0;
        }

        @Override
        public int compareTo(OrderLineObj o) {
            if (this.distance < o.distance) {
                return -1;
            }
            if (this.distance == o.distance) {
                return 0;
            }
            return 1;
        }

        public double getDistance() {
            return this.distance;
        }
    }

    private static class Shapelet
    implements Comparable<Shapelet> {
        private double[] content;
        private int seriesId;
        private int startPos;
        private ArrayList<OrderLineObj> orderline;
        private double kruskalWallaceStat;
        private double splitThreshold;
        private double separationGap;

        private Shapelet(double[] content, int seriesId, int startPos) {
            this.content = content;
            this.seriesId = seriesId;
            this.startPos = startPos;
            this.orderline = null;
        }

        private Shapelet(double[] content) {
            this.content = content;
        }

        private void calculateKruskalWallis(ArrayList<OrderLineObj> orderline) {
            Collections.sort(orderline);
            KruskalWallisTree.assignRanks(orderline);
            TreeMap<Double, Double> classRankSums = new TreeMap<Double, Double>();
            TreeMap<Double, Integer> classCounts = new TreeMap<Double, Integer>();
            TreeMap<Double, Double> classRankMeans = new TreeMap<Double, Double>();
            for (int i = 0; i < orderline.size(); ++i) {
                double classVal = orderline.get(i).classVal;
                double thisRank = orderline.get(i).rank;
                if (classRankSums.containsKey(classVal)) {
                    double oldRank = (Double)classRankSums.get(classVal);
                    int oldCount = (Integer)classCounts.get(classVal);
                    classRankSums.put(classVal, oldRank + thisRank);
                    classCounts.put(classVal, oldCount + 1);
                    continue;
                }
                classRankSums.put(classVal, thisRank);
                classCounts.put(classVal, 1);
            }
            for (Double d : classRankSums.keySet()) {
                double thisMean = (Double)classRankSums.get(d) / (double)((Integer)classCounts.get(d)).intValue();
                classRankMeans.put(d, thisMean);
            }
            double overallMeanRank = (1.0 + (double)orderline.size()) / 2.0;
            double s = 0.0;
            for (Double d : classRankMeans.keySet()) {
                s += (double)((Integer)classCounts.get(d)).intValue() * ((Double)classRankMeans.get(d) - overallMeanRank) * ((Double)classRankMeans.get(d) - overallMeanRank);
            }
            double h = 12.0 / (double)(orderline.size() * (orderline.size() + 1)) * s;
            this.orderline = orderline;
            this.kruskalWallaceStat = h;
        }

        public double getKruskalWallisStat() {
            return this.kruskalWallaceStat;
        }

        public int getLength() {
            return this.content.length;
        }

        private void calculateBestSplitPoint(TreeMap<Double, Integer> classDistribution) {
            double lastDist = this.orderline.get(0).distance;
            double thisDist = -1.0;
            double bsfGain = -1.0;
            double threshold = -1.0;
            for (int i = 1; i < this.orderline.size(); ++i) {
                thisDist = this.orderline.get(i).distance;
                if (i == 1 || thisDist != lastDist) {
                    double entropyGreater;
                    double greaterFrac;
                    double entropyLess;
                    double lessFrac;
                    int storedTotal;
                    double thisClassVal;
                    int j;
                    TreeMap<Double, Integer> lessClasses = new TreeMap<Double, Integer>();
                    TreeMap<Double, Integer> greaterClasses = new TreeMap<Double, Integer>();
                    for (double j2 : classDistribution.keySet()) {
                        lessClasses.put(j2, 0);
                        greaterClasses.put(j2, 0);
                    }
                    int sumOfLessClasses = 0;
                    int sumOfGreaterClasses = 0;
                    for (j = 0; j < i; ++j) {
                        thisClassVal = this.orderline.get(j).classVal;
                        storedTotal = (Integer)lessClasses.get(thisClassVal);
                        lessClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfLessClasses;
                    }
                    for (j = i; j < this.orderline.size(); ++j) {
                        thisClassVal = this.orderline.get(j).classVal;
                        storedTotal = (Integer)greaterClasses.get(thisClassVal);
                        greaterClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfGreaterClasses;
                    }
                    int sumOfAllClasses = sumOfLessClasses + sumOfGreaterClasses;
                    double parentEntropy = Shapelet.entropy(classDistribution);
                    double gain = parentEntropy - (lessFrac = (double)sumOfLessClasses / (double)sumOfAllClasses) * (entropyLess = Shapelet.entropy(lessClasses)) - (greaterFrac = (double)sumOfGreaterClasses / (double)sumOfAllClasses) * (entropyGreater = Shapelet.entropy(greaterClasses));
                    if (gain > bsfGain) {
                        bsfGain = gain;
                        threshold = (thisDist - lastDist) / 2.0 + lastDist;
                    }
                }
                lastDist = thisDist;
            }
            this.splitThreshold = threshold;
            this.separationGap = this.calculateSeparationGap(this.orderline, threshold);
        }

        private double calculateSeparationGap(ArrayList<OrderLineObj> orderline, double distanceThreshold) {
            double sumLeft = 0.0;
            double leftSize = 0.0;
            double sumRight = 0.0;
            double rightSize = 0.0;
            for (int i = 0; i < orderline.size(); ++i) {
                if (orderline.get(i).distance < distanceThreshold) {
                    sumLeft += orderline.get(i).distance;
                    leftSize += 1.0;
                    continue;
                }
                sumRight += orderline.get(i).distance;
                rightSize += 1.0;
            }
            double thisSeparationGap = 1.0 / rightSize * sumRight - 1.0 / leftSize * sumLeft;
            if (rightSize == 0.0 || leftSize == 0.0) {
                return -1.0;
            }
            return thisSeparationGap;
        }

        private static double entropy(TreeMap<Double, Integer> classDistributions) {
            if (classDistributions.size() == 1) {
                return 0.0;
            }
            int total = 0;
            for (Double d : classDistributions.keySet()) {
                total += classDistributions.get(d).intValue();
            }
            ArrayList<Double> entropyParts = new ArrayList<Double>();
            for (Double d : classDistributions.keySet()) {
                double thisPart = (double)classDistributions.get(d).intValue() / (double)total;
                double toAdd = -thisPart * Math.log10(thisPart) / Math.log10(2.0);
                if (Double.isNaN(toAdd)) {
                    toAdd = 0.0;
                }
                entropyParts.add(toAdd);
            }
            double d = 0.0;
            for (int i = 0; i < entropyParts.size(); ++i) {
                d += ((Double)entropyParts.get(i)).doubleValue();
            }
            return d;
        }

        @Override
        public int compareTo(Shapelet shapelet) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this.kruskalWallaceStat != shapelet.getKruskalWallisStat()) {
                if (this.kruskalWallaceStat > shapelet.getKruskalWallisStat()) {
                    return -1;
                }
                return 1;
            }
            if (this.content.length != shapelet.getLength()) {
                if (this.content.length < shapelet.getLength()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private class ShapeletNode {
        private ShapeletNode leftNode = null;
        private ShapeletNode rightNode = null;
        private double classDecision = -1.0;
        private Shapelet shapelet;

        public void initialiseNode(Instances data, int minShapeletLength, int maxShapeletLength, int level) throws Exception {
            FileWriter fw = new FileWriter(KruskalWallisTree.this.logFileName, true);
            fw.append("level:" + level + ", numInstances:" + data.numInstances() + "\n");
            fw.close();
            double firstClassValue = data.instance(0).classValue();
            boolean oneClass = true;
            for (int i = 1; i < data.numInstances(); ++i) {
                if (data.instance(i).classValue() == firstClassValue) continue;
                oneClass = false;
                break;
            }
            if (oneClass) {
                this.classDecision = firstClassValue;
                fw = new FileWriter(KruskalWallisTree.this.logFileName, true);
                fw.append("class decision here: " + firstClassValue + "\n");
                fw.close();
            } else {
                try {
                    this.shapelet = KruskalWallisTree.this.findBestShapelet(data, minShapeletLength, maxShapeletLength);
                    ArrayList<Instance> splitLeft = new ArrayList<Instance>();
                    ArrayList<Instance> splitRight = new ArrayList<Instance>();
                    for (int i = 0; i < data.numInstances(); ++i) {
                        double dist = KruskalWallisTree.subsequenceDistance(this.shapelet.content, data.instance(i).toDoubleArray());
                        if (dist < this.shapelet.splitThreshold) {
                            splitLeft.add(data.instance(i));
                            continue;
                        }
                        splitRight.add(data.instance(i));
                    }
                    fw = new FileWriter(KruskalWallisTree.this.logFileName, true);
                    fw.append("seriesId, startPos, length, kwstat, splitThresh\n");
                    fw.append(this.shapelet.seriesId + "," + this.shapelet.startPos + "," + this.shapelet.content.length + "," + this.shapelet.getKruskalWallisStat() + "," + this.shapelet.splitThreshold + "\n");
                    for (int j = 0; j < this.shapelet.content.length; ++j) {
                        fw.append(this.shapelet.content[j] + ",");
                    }
                    fw.append("\n");
                    fw.close();
                    System.out.println("shapelet completed at:" + System.nanoTime());
                    this.leftNode = new ShapeletNode();
                    this.rightNode = new ShapeletNode();
                    Instances leftInstances = new Instances(data, splitLeft.size());
                    for (int i = 0; i < splitLeft.size(); ++i) {
                        leftInstances.add((Instance)splitLeft.get(i));
                    }
                    Instances rightInstances = new Instances(data, splitRight.size());
                    for (int i = 0; i < splitRight.size(); ++i) {
                        rightInstances.add((Instance)splitRight.get(i));
                    }
                    fw = new FileWriter(KruskalWallisTree.this.logFileName, true);
                    fw.append("left size under level " + level + ": " + leftInstances.numInstances() + "\n");
                    fw.close();
                    System.out.println("left: " + leftInstances.numInstances());
                    System.out.println("right: " + rightInstances.numInstances());
                    System.out.println("split: " + this.shapelet.startPos);
                    this.leftNode.initialiseNode(leftInstances, minShapeletLength, maxShapeletLength, level + 1);
                    fw = new FileWriter(KruskalWallisTree.this.logFileName, true);
                    fw.append("right size under level " + level + ": " + rightInstances.numInstances() + "\n");
                    fw.close();
                    this.rightNode.initialiseNode(rightInstances, minShapeletLength, maxShapeletLength, level + 1);
                }
                catch (Exception e) {
                    System.out.println("Problem initialising tree node: " + e);
                    e.printStackTrace();
                }
            }
        }

        public double classifyInstance(Instance instance) {
            if (this.leftNode == null) {
                return this.classDecision;
            }
            double distance = KruskalWallisTree.subsequenceDistance(this.shapelet.content, instance);
            if (distance < this.shapelet.splitThreshold) {
                return this.leftNode.classifyInstance(instance);
            }
            return this.rightNode.classifyInstance(instance);
        }
    }
}

