/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.shapelet_trees;

import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class FStatShapeletTreeWithInfoGain
extends AbstractClassifier {
    private ShapeletNode root = new ShapeletNode();
    private String logFileName;
    private int minLength;
    private int maxLength;

    public FStatShapeletTreeWithInfoGain(String logFileName) throws Exception {
        this.logFileName = logFileName;
        FileWriter fw = new FileWriter(logFileName);
        fw.close();
    }

    public void setShapeletMinMaxLength(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.minLength < 1 || this.maxLength < 1) {
            throw new Exception("Shapelet minimum or maximum length is incorrectly specified!");
        }
        this.root.initialiseNode(data, this.minLength, this.maxLength, 0);
    }

    @Override
    public double classifyInstance(Instance instance) {
        return this.root.classifyInstance(instance);
    }

    private Shapelet getRootShapelet() {
        return this.root.shapelet;
    }

    public double timingForSingleShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        long startTime = System.nanoTime();
        this.findBestShapelet(data, minShapeletLength, maxShapeletLength);
        long finishTime = System.nanoTime();
        return (double)(finishTime - startTime) / 1.0E9;
    }

    private Shapelet findBestShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        Shapelet bestShapelet = null;
        TreeMap<Double, Integer> classDistributions = FStatShapeletTreeWithInfoGain.getClassDistributions(data);
        System.out.println("Processing data: ");
        for (int i = 0; i < data.numInstances(); ++i) {
            double[] wholeCandidate = data.instance(i).toDoubleArray();
            for (int length = minShapeletLength; length <= maxShapeletLength; ++length) {
                for (int start = 0; start <= wholeCandidate.length - length - 1; ++start) {
                    double[] candidate = new double[length];
                    for (int m = start; m < start + length; ++m) {
                        candidate[m - start] = wholeCandidate[m];
                    }
                    candidate = FStatShapeletTreeWithInfoGain.zNorm(candidate, false);
                    Shapelet candidateShapelet = FStatShapeletTreeWithInfoGain.checkCandidate(candidate, data, i, start, classDistributions);
                    if (bestShapelet != null && candidateShapelet.compareTo(bestShapelet) >= 0) continue;
                    bestShapelet = candidateShapelet;
                }
            }
        }
        bestShapelet.calculateBestSplitPoint(classDistributions);
        return bestShapelet;
    }

    private ArrayList<Shapelet> combine(int k, ArrayList<Shapelet> kBestSoFar, ArrayList<Shapelet> timeSeriesShapelets) {
        int i;
        ArrayList<Shapelet> newBestSoFar = new ArrayList<Shapelet>();
        for (i = 0; i < timeSeriesShapelets.size(); ++i) {
            kBestSoFar.add(timeSeriesShapelets.get(i));
        }
        Collections.sort(kBestSoFar);
        if (kBestSoFar.size() < k) {
            return kBestSoFar;
        }
        for (i = 0; i < k; ++i) {
            newBestSoFar.add(kBestSoFar.get(i));
        }
        return newBestSoFar;
    }

    private static TreeMap<Double, Integer> getClassDistributions(Instances data) {
        TreeMap<Double, Integer> classDistribution = new TreeMap<Double, Integer>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double classValue = data.instance(i).classValue();
            boolean classExists = false;
            for (Double d : classDistribution.keySet()) {
                if (d != classValue) continue;
                int temp = classDistribution.get(d);
                classDistribution.put(classValue, ++temp);
                classExists = true;
            }
            if (classExists) continue;
            classDistribution.put(classValue, 1);
        }
        return classDistribution;
    }

    private static Shapelet checkCandidate(double[] candidate, Instances data, int seriesId, int startPos, TreeMap classDistribution) {
        ArrayList<OrderLineObj> orderline = new ArrayList<OrderLineObj>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double distance = FStatShapeletTreeWithInfoGain.subsequenceDistance(candidate, data.instance(i));
            double classVal = data.instance(i).classValue();
            orderline.add(new OrderLineObj(distance, classVal));
        }
        Shapelet shapelet = new Shapelet(candidate, seriesId, startPos);
        shapelet.calculateMoodsMedianTree(orderline, classDistribution);
        return shapelet;
    }

    public static double subsequenceDistance(double[] candidate, Instance timeSeriesIns) {
        double[] timeSeries = timeSeriesIns.toDoubleArray();
        return FStatShapeletTreeWithInfoGain.subsequenceDistance(candidate, timeSeries);
    }

    public static double subsequenceDistance(double[] candidate, double[] timeSeries) {
        double bestSum = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i <= timeSeries.length - candidate.length - 1; ++i) {
            int j;
            sum = 0.0;
            double[] subseq = new double[candidate.length];
            for (j = i; j < i + candidate.length; ++j) {
                subseq[j - i] = timeSeries[j];
            }
            subseq = FStatShapeletTreeWithInfoGain.zNorm(subseq, false);
            for (j = 0; j < candidate.length; ++j) {
                sum += (candidate[j] - subseq[j]) * (candidate[j] - subseq[j]);
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        return 1.0 / (double)candidate.length * bestSum;
    }

    public static double[] zNorm(double[] input, boolean classValOn) {
        double classValPenalty = 0.0;
        if (classValOn) {
            classValPenalty = 1.0;
        }
        double[] output = new double[input.length];
        double seriesTotal = 0.0;
        int i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            seriesTotal += input[i];
            ++i;
        }
        double mean = seriesTotal / ((double)input.length - classValPenalty);
        double stdv = 0.0;
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            stdv += (input[i] - mean) * (input[i] - mean);
            ++i;
        }
        stdv = stdv / (double)input.length - classValPenalty;
        stdv = Math.sqrt(stdv);
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            output[i] = (input[i] - mean) / stdv;
            ++i;
        }
        if (classValOn) {
            output[output.length - 1] = input[input.length - 1];
        }
        return output;
    }

    public static Instances loadData(String fileName) {
        Instances data = null;
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method loadData");
        }
        return data;
    }

    private static class OrderLineObj
    implements Comparable<OrderLineObj> {
        private double distance;
        private double classVal;

        private OrderLineObj(double distance, double classVal) {
            this.distance = distance;
            this.classVal = classVal;
        }

        @Override
        public int compareTo(OrderLineObj o) {
            if (this.distance < o.distance) {
                return -1;
            }
            if (this.distance == o.distance) {
                return 0;
            }
            return 1;
        }
    }

    private static class Shapelet
    implements Comparable<Shapelet> {
        private double[] content;
        private int seriesId;
        private int startPos;
        private double fStat;
        private ArrayList<OrderLineObj> orderline;
        private double splitThresh;
        private double separationGap;

        private Shapelet(double[] content, int seriesId, int startPos) {
            this.content = content;
            this.seriesId = seriesId;
            this.startPos = startPos;
        }

        private Shapelet(double[] content) {
            this.content = content;
        }

        public void calculateMoodsMedian(ArrayList<OrderLineObj> orderline, TreeMap<Double, Integer> classDistribution) {
            double f;
            int i;
            this.orderline = orderline;
            Collections.sort(orderline);
            int numClasses = classDistribution.size();
            int numInstances = orderline.size();
            double[] sums = new double[numClasses];
            double[] sumsSquared = new double[numClasses];
            double[] sumOfSquares = new double[numClasses];
            for (i = 0; i < numClasses; ++i) {
                sums[i] = 0.0;
                sumsSquared[i] = 0.0;
                sumOfSquares[i] = 0.0;
            }
            for (i = 0; i < orderline.size(); ++i) {
                int c = (int)orderline.get(i).classVal;
                double thisDist = orderline.get(i).distance;
                System.out.println("c = " + c + ", numClasses = " + numClasses);
                int n = c;
                sums[n] = sums[n] + thisDist;
                int n2 = c;
                sumOfSquares[n2] = sumOfSquares[n2] + thisDist * thisDist;
            }
            for (i = 0; i < numClasses; ++i) {
                sumsSquared[i] = sums[i] * sums[i];
            }
            double ssTotal = 0.0;
            double part1 = 0.0;
            double part2 = 0.0;
            for (int i2 = 0; i2 < numClasses; ++i2) {
                part1 += sumOfSquares[i2];
                part2 += sums[i2];
            }
            part2 *= part2;
            ssTotal = part1 - (part2 /= (double)numInstances);
            double ssAmoung = 0.0;
            part1 = 0.0;
            part2 = 0.0;
            for (int i3 = 0; i3 < numClasses; ++i3) {
                part1 += sumsSquared[i3] / (double)classDistribution.get(i3).intValue();
                part2 += sums[i3];
            }
            ssAmoung = part1 - part2 * part2 / (double)numInstances;
            double ssWithin = ssTotal - ssAmoung;
            int dfAmoung = numClasses - 1;
            int dfWithin = numInstances - numClasses;
            double msAmoung = ssAmoung / (double)dfAmoung;
            double msWithin = ssWithin / (double)dfWithin;
            this.fStat = f = msAmoung / msWithin;
        }

        public void calculateMoodsMedianTree(ArrayList<OrderLineObj> orderline, TreeMap<Double, Integer> classDistribution) {
            double f;
            int i;
            this.orderline = orderline;
            Collections.sort(orderline);
            int numClasses = classDistribution.size();
            int numInstances = orderline.size();
            double[] sums = new double[numClasses];
            double[] sumsSquared = new double[numClasses];
            double[] sumOfSquares = new double[numClasses];
            double[] classValuesArray = new double[numClasses];
            double[] classValuesArrayCounts = new double[numClasses];
            int index = 0;
            for (Double d : classDistribution.keySet()) {
                classValuesArray[index] = d;
                classValuesArrayCounts[index] = classDistribution.get(d).intValue();
                ++index;
            }
            for (i = 0; i < numClasses; ++i) {
                sums[i] = 0.0;
                sumsSquared[i] = 0.0;
                sumOfSquares[i] = 0.0;
            }
            for (i = 0; i < orderline.size(); ++i) {
                int c = (int)orderline.get(i).classVal;
                double thisDist = orderline.get(i).distance;
                for (int j = 0; j < numClasses; ++j) {
                    if (classValuesArray[j] != (double)c) continue;
                    int n = j;
                    sums[n] = sums[n] + thisDist;
                    int n2 = j;
                    sumOfSquares[n2] = sumOfSquares[n2] + thisDist * thisDist;
                }
            }
            for (i = 0; i < numClasses; ++i) {
                sumsSquared[i] = sums[i] * sums[i];
            }
            double ssTotal = 0.0;
            double part1 = 0.0;
            double part2 = 0.0;
            for (int i2 = 0; i2 < numClasses; ++i2) {
                part1 += sumOfSquares[i2];
                part2 += sums[i2];
            }
            part2 *= part2;
            ssTotal = part1 - (part2 /= (double)numInstances);
            double ssAmoung = 0.0;
            part1 = 0.0;
            part2 = 0.0;
            for (int i3 = 0; i3 < numClasses; ++i3) {
                part1 += sumsSquared[i3] / classValuesArrayCounts[i3];
                part2 += sums[i3];
            }
            ssAmoung = part1 - part2 * part2 / (double)numInstances;
            double ssWithin = ssTotal - ssAmoung;
            int dfAmoung = numClasses - 1;
            int dfWithin = numInstances - numClasses;
            double msAmoung = ssAmoung / (double)dfAmoung;
            double msWithin = ssWithin / (double)dfWithin;
            this.fStat = f = msAmoung / msWithin;
        }

        private void calculateBestSplitPoint(TreeMap<Double, Integer> classDistribution) {
            Collections.sort(this.orderline);
            double lastDist = this.orderline.get(0).distance;
            double thisDist = -1.0;
            double bsfGain = -1.0;
            double threshold = -1.0;
            for (int i = 1; i < this.orderline.size(); ++i) {
                thisDist = this.orderline.get(i).distance;
                if (i == 1 || thisDist != lastDist) {
                    double entropyGreater;
                    double greaterFrac;
                    double entropyLess;
                    double lessFrac;
                    int storedTotal;
                    double thisClassVal;
                    int j;
                    TreeMap<Double, Integer> lessClasses = new TreeMap<Double, Integer>();
                    TreeMap<Double, Integer> greaterClasses = new TreeMap<Double, Integer>();
                    for (double j2 : classDistribution.keySet()) {
                        lessClasses.put(j2, 0);
                        greaterClasses.put(j2, 0);
                    }
                    int sumOfLessClasses = 0;
                    int sumOfGreaterClasses = 0;
                    for (j = 0; j < i; ++j) {
                        thisClassVal = this.orderline.get(j).classVal;
                        storedTotal = (Integer)lessClasses.get(thisClassVal);
                        lessClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfLessClasses;
                    }
                    for (j = i; j < this.orderline.size(); ++j) {
                        thisClassVal = this.orderline.get(j).classVal;
                        storedTotal = (Integer)greaterClasses.get(thisClassVal);
                        greaterClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfGreaterClasses;
                    }
                    int sumOfAllClasses = sumOfLessClasses + sumOfGreaterClasses;
                    double parentEntropy = Shapelet.entropy(classDistribution);
                    double gain = parentEntropy - (lessFrac = (double)sumOfLessClasses / (double)sumOfAllClasses) * (entropyLess = Shapelet.entropy(lessClasses)) - (greaterFrac = (double)sumOfGreaterClasses / (double)sumOfAllClasses) * (entropyGreater = Shapelet.entropy(greaterClasses));
                    if (gain > bsfGain) {
                        bsfGain = gain;
                        threshold = (thisDist - lastDist) / 2.0 + lastDist;
                    }
                }
                lastDist = thisDist;
            }
            this.splitThresh = threshold;
        }

        private static double entropy(TreeMap<Double, Integer> classDistributions) {
            if (classDistributions.size() == 1) {
                return 0.0;
            }
            int total = 0;
            for (Double d : classDistributions.keySet()) {
                total += classDistributions.get(d).intValue();
            }
            ArrayList<Double> entropyParts = new ArrayList<Double>();
            for (Double d : classDistributions.keySet()) {
                double thisPart = (double)classDistributions.get(d).intValue() / (double)total;
                double toAdd = -thisPart * Math.log10(thisPart) / Math.log10(2.0);
                if (Double.isNaN(toAdd)) {
                    toAdd = 0.0;
                }
                entropyParts.add(toAdd);
            }
            double d = 0.0;
            for (int i = 0; i < entropyParts.size(); ++i) {
                d += ((Double)entropyParts.get(i)).doubleValue();
            }
            return d;
        }

        public int getLength() {
            return this.content.length;
        }

        @Override
        public int compareTo(Shapelet shapelet) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this.fStat != shapelet.fStat) {
                if (this.fStat > shapelet.fStat) {
                    return -1;
                }
                return 1;
            }
            if (this.content.length != shapelet.getLength()) {
                if (this.content.length < shapelet.getLength()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private class ShapeletNode {
        private ShapeletNode leftNode = null;
        private ShapeletNode rightNode = null;
        private double classDecision = -1.0;
        private Shapelet shapelet;

        public void initialiseNode(Instances data, int minShapeletLength, int maxShapeletLength, int level) throws Exception {
            FileWriter fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
            fw.append("level:" + level + ", numInstances:" + data.numInstances() + "\n");
            fw.close();
            double firstClassValue = data.instance(0).classValue();
            boolean oneClass = true;
            for (int i = 1; i < data.numInstances(); ++i) {
                if (data.instance(i).classValue() == firstClassValue) continue;
                oneClass = false;
                break;
            }
            if (oneClass) {
                this.classDecision = firstClassValue;
                fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
                fw.append("class decision here: " + firstClassValue + "\n");
                fw.close();
            } else {
                try {
                    this.shapelet = FStatShapeletTreeWithInfoGain.this.findBestShapelet(data, minShapeletLength, maxShapeletLength);
                    ArrayList<Instance> splitLeft = new ArrayList<Instance>();
                    ArrayList<Instance> splitRight = new ArrayList<Instance>();
                    for (int i = 0; i < data.numInstances(); ++i) {
                        double dist = FStatShapeletTreeWithInfoGain.subsequenceDistance(this.shapelet.content, data.instance(i).toDoubleArray());
                        if (dist < this.shapelet.splitThresh) {
                            splitLeft.add(data.instance(i));
                            continue;
                        }
                        splitRight.add(data.instance(i));
                    }
                    fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
                    fw.append("seriesId, startPos, length, infoGain, splitThresh\n");
                    fw.append(this.shapelet.seriesId + "," + this.shapelet.startPos + "," + this.shapelet.content.length + "," + this.shapelet.fStat + "," + this.shapelet.splitThresh + "\n");
                    for (int j = 0; j < this.shapelet.content.length; ++j) {
                        fw.append(this.shapelet.content[j] + ",");
                    }
                    fw.append("\n");
                    fw.close();
                    System.out.println("shapelet completed at:" + System.nanoTime());
                    this.leftNode = new ShapeletNode();
                    this.rightNode = new ShapeletNode();
                    if (splitLeft.isEmpty() || splitRight.isEmpty()) {
                        TreeMap classesForEscape = FStatShapeletTreeWithInfoGain.getClassDistributions(data);
                        double bestKey = data.instance(0).classValue();
                        int bestTotal = 0;
                        for (Double d : classesForEscape.keySet()) {
                            if ((Integer)classesForEscape.get(d) <= bestTotal) continue;
                            bestTotal = (Integer)classesForEscape.get(d);
                            bestKey = d;
                        }
                        this.classDecision = bestKey;
                        fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
                        fw.append("PRUNED class decision here: " + bestKey + "\n");
                        fw.close();
                    } else {
                        Instances leftInstances = new Instances(data, splitLeft.size());
                        for (int i = 0; i < splitLeft.size(); ++i) {
                            leftInstances.add((Instance)splitLeft.get(i));
                        }
                        Instances rightInstances = new Instances(data, splitRight.size());
                        for (int i = 0; i < splitRight.size(); ++i) {
                            rightInstances.add((Instance)splitRight.get(i));
                        }
                        fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
                        fw.append("left size under level " + level + ": " + leftInstances.numInstances() + "\n");
                        fw.close();
                        this.leftNode.initialiseNode(leftInstances, minShapeletLength, maxShapeletLength, level + 1);
                        fw = new FileWriter(FStatShapeletTreeWithInfoGain.this.logFileName, true);
                        fw.append("right size under level " + level + ": " + rightInstances.numInstances() + "\n");
                        fw.close();
                        this.rightNode.initialiseNode(rightInstances, minShapeletLength, maxShapeletLength, level + 1);
                    }
                }
                catch (Exception e) {
                    System.out.println("Problem initialising tree node: " + e);
                    e.printStackTrace();
                }
            }
        }

        public double classifyInstance(Instance instance) {
            if (this.leftNode == null) {
                return this.classDecision;
            }
            double distance = FStatShapeletTreeWithInfoGain.subsequenceDistance(this.shapelet.content, instance);
            if (distance < this.shapelet.splitThresh) {
                return this.leftNode.classifyInstance(instance);
            }
            return this.rightNode.classifyInstance(instance);
        }
    }
}

