/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ft;

import java.util.Vector;
import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.BinC45Split;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.Stats;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;

public abstract class FTtree
extends LogisticBase {
    static final long serialVersionUID = 1862737145870398755L;
    protected double m_totalInstanceWeight;
    protected int m_id;
    protected int m_leafModelNum;
    protected int m_minNumInstances;
    protected ModelSelection m_modelSelection;
    protected NominalToBinary m_nominalToBinary;
    protected SimpleLinearRegression[][] m_higherRegressions;
    protected int m_numHigherRegressions = 0;
    protected int m_numInstances;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierSplitModel m_auxLocalModel;
    protected FTtree[] m_sons;
    protected int m_leafclass;
    protected boolean m_isLeaf;
    protected boolean m_hasConstr = true;
    protected double m_constError = 0.0;
    protected float m_CF = 0.1f;

    @Override
    public abstract void buildClassifier(Instances var1) throws Exception;

    public abstract void buildTree(Instances var1, SimpleLinearRegression[][] var2, double var3, double var5) throws Exception;

    public abstract double prune() throws Exception;

    protected Instances insertNewAttr(Instances data) throws Exception {
        for (int i = 0; i < data.classAttribute().numValues(); ++i) {
            data.insertAttributeAt(new Attribute("N" + i), i);
        }
        return data;
    }

    protected Instances removeExtAttributes(Instances data) throws Exception {
        for (int i = 0; i < data.classAttribute().numValues(); ++i) {
            data.deleteAttributeAt(0);
        }
        return data;
    }

    protected double getEstimatedErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.m_localModel.distribution());
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            errors += this.m_sons[i].getEstimatedErrors();
        }
        return errors;
    }

    protected double getEstimatedErrorsForBranch(Instances data) throws Exception {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(data));
        }
        Distribution savedDist = this.m_localModel.distribution();
        this.m_localModel.resetDistribution(data);
        Instances[] localInstances = this.m_localModel.split(data);
        for (int i = 0; i < this.m_sons.length; ++i) {
            errors += this.m_sons[i].getEstimatedErrorsForBranch(localInstances[i]);
        }
        return errors;
    }

    protected double getEstimatedErrorsForDistribution(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        double numInc = theDistribution.numIncorrect();
        double numTotal = theDistribution.total();
        return (Stats.addErrs(numTotal, numInc, this.m_CF) + numInc) / numTotal;
    }

    protected double getEtimateConstModel(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        double numTotal = theDistribution.total();
        return (Stats.addErrs(numTotal, this.m_constError, this.m_CF) + this.m_constError) / numTotal;
    }

    public int getNumInnerNodes() {
        if (this.m_isLeaf) {
            return 0;
        }
        int numNodes = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numNodes += this.m_sons[i].getNumInnerNodes();
        }
        return numNodes;
    }

    public int getNumLeaves() {
        int numLeaves;
        if (!this.m_isLeaf) {
            numLeaves = 0;
            int numEmptyLeaves = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                numLeaves += this.m_sons[i].getNumLeaves();
                if (!this.m_sons[i].m_isLeaf || this.m_sons[i].hasModels()) continue;
                ++numEmptyLeaves;
            }
            if (numEmptyLeaves > 1) {
                numLeaves -= numEmptyLeaves - 1;
            }
        } else {
            numLeaves = 1;
        }
        return numLeaves;
    }

    protected SimpleLinearRegression[][] mergeArrays(SimpleLinearRegression[][] a1, SimpleLinearRegression[][] a2) {
        int j;
        int i;
        int numModels1 = a1[0].length;
        int numModels2 = a2[0].length;
        SimpleLinearRegression[][] result = new SimpleLinearRegression[this.m_numClasses][numModels1 + numModels2];
        for (i = 0; i < this.m_numClasses; ++i) {
            for (j = 0; j < numModels1; ++j) {
                result[i][j] = a1[i][j];
            }
        }
        for (i = 0; i < this.m_numClasses; ++i) {
            for (j = 0; j < numModels2; ++j) {
                result[i][j + numModels1] = a2[i][j];
            }
        }
        return result;
    }

    public Vector getNodes() {
        Vector nodeList = new Vector();
        this.getNodes(nodeList);
        return nodeList;
    }

    public void getNodes(Vector nodeList) {
        if (!this.m_isLeaf) {
            nodeList.add(this);
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].getNodes(nodeList);
            }
        }
    }

    @Override
    protected Instances getNumericData(Instances train) throws Exception {
        Instances filteredData = new Instances(train);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(filteredData);
        filteredData = Filter.useFilter(filteredData, this.m_nominalToBinary);
        return super.getNumericData(filteredData);
    }

    @Override
    protected double[] getFs(Instance instance) throws Exception {
        double[] pred = new double[this.m_numClasses];
        double[] instanceFs = super.getFs(instance);
        for (int i = 0; i < this.m_numHigherRegressions; ++i) {
            int j;
            double predSum = 0.0;
            for (j = 0; j < this.m_numClasses; ++j) {
                pred[j] = this.m_higherRegressions[j][i].classifyInstance(instance);
                predSum += pred[j];
            }
            predSum /= (double)this.m_numClasses;
            for (j = 0; j < this.m_numClasses; ++j) {
                int n = j;
                instanceFs[n] = instanceFs[n] + (pred[j] - predSum) * (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
            }
        }
        return instanceFs;
    }

    public int getConstError(double[] probsConst) {
        return Utils.maxIndex(probsConst);
    }

    public boolean hasModels() {
        return this.m_numRegressions > 0;
    }

    public double[] modelDistributionForInstance(Instance instance) throws Exception {
        instance = (Instance)instance.copy();
        this.m_nominalToBinary.input(instance);
        instance = this.m_nominalToBinary.output();
        instance.setDataset(this.m_numericDataHeader);
        return this.probs(this.getFs(instance));
    }

    @Override
    public abstract double[] distributionForInstance(Instance var1) throws Exception;

    @Override
    public String toString() {
        this.assignLeafModelNumbers(0);
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf && !this.m_hasConstr) {
                text.append(": ");
                text.append("Class=" + this.m_leafclass);
            } else if (this.m_isLeaf && this.m_hasConstr) {
                text.append(": ");
                text.append("FT_" + this.m_leafModelNum + ":" + this.getModelParameters());
            } else {
                this.dumpTree(0, text);
            }
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the Tree : \t" + this.numNodes() + "\n");
            text.append(this.modelsToString());
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print logistic model tree";
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numLeaves = 0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numLeaves += this.m_sons[i].numLeaves();
        }
        return numLeaves;
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numNodes = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numNodes += this.m_sons[i].numNodes();
        }
        return numNodes;
    }

    public String getModelParameters() {
        StringBuffer text = new StringBuffer();
        int numModels = this.m_numRegressions + this.m_numHigherRegressions;
        text.append(this.m_numRegressions + "/" + numModels + " (" + this.m_numInstances + ")");
        return text.toString();
    }

    protected void dumpTree(int depth, StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("\n");
            for (int j = 0; j < depth; ++j) {
                text.append("|   ");
            }
            if (this.m_hasConstr) {
                text.append(this.m_localModel.leftSide(this.m_train) + "#" + this.m_id);
            } else {
                text.append(this.m_localModel.leftSide(this.m_train));
            }
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                text.append(": ");
                text.append("FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters());
                continue;
            }
            if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                text.append(": ");
                text.append("Class=" + this.m_sons[i].m_leafclass);
                continue;
            }
            this.m_sons[i].dumpTree(depth + 1, text);
        }
    }

    public int assignIDs(int lastID) {
        int currLastID;
        this.m_id = currLastID = lastID + 1;
        if (this.m_sons != null) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                currLastID = this.m_sons[i].assignIDs(currLastID);
            }
        }
        return currLastID;
    }

    public int assignLeafModelNumbers(int leafCounter) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                leafCounter = this.m_sons[i].assignLeafModelNumbers(leafCounter);
            }
        } else {
            this.m_leafModelNum = ++leafCounter;
        }
        return leafCounter;
    }

    @Override
    protected double[][] getCoefficients() {
        double[][] coefficients = super.getCoefficients();
        double constFactor = (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
        for (int j = 0; j < this.m_numClasses; ++j) {
            for (int i = 0; i < this.m_numHigherRegressions; ++i) {
                double slope = this.m_higherRegressions[j][i].getSlope();
                double intercept = this.m_higherRegressions[j][i].getIntercept();
                int attribute = this.m_higherRegressions[j][i].getAttributeIndex();
                double[] dArray = coefficients[j];
                dArray[0] = dArray[0] + constFactor * intercept;
                double[] dArray2 = coefficients[j];
                int n = attribute + 1;
                dArray2[n] = dArray2[n] + constFactor * slope;
            }
        }
        return coefficients;
    }

    public String modelsToString() {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf && this.m_hasConstr) {
            text.append("FT_" + this.m_leafModelNum + ":" + super.toString());
        } else if (!this.m_isLeaf && this.m_hasConstr) {
            if (this.m_modelSelection instanceof BinC45ModelSelection) {
                text.append("FT_N" + ((BinC45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            } else {
                text.append("FT_N" + ((C45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            }
            for (int i = 0; i < this.m_sons.length; ++i) {
                text.append("\n" + this.m_sons[i].modelsToString());
            }
        } else if (!this.m_isLeaf && !this.m_hasConstr) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                text.append("\n" + this.m_sons[i].modelsToString());
            }
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            text.append("");
        }
        return text.toString();
    }

    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        this.assignIDs(-1);
        this.assignLeafModelNumbers(0);
        text.append("digraph FTree {\n");
        if (this.m_isLeaf && this.m_hasConstr) {
            text.append("N" + this.m_id + " [label=\"FT_" + this.m_leafModelNum + ":" + this.getModelParameters() + "\" shape=box style=filled");
            text.append("]\n");
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            text.append("N" + this.m_id + " [label=\"Class=" + this.m_leafclass + "\" shape=box style=filled");
            text.append("]\n");
        } else {
            text.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            text.append("]\n");
            this.graphTree(text);
        }
        return text.toString() + "}\n";
    }

    protected void graphTree(StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("N" + this.m_id + "->N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters() + "\" shape=box style=filled");
                text.append("]\n");
                continue;
            }
            if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"Class=" + this.m_sons[i].m_leafclass + "\" shape=box style=filled");
                text.append("]\n");
                continue;
            }
            text.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            text.append("]\n");
            this.m_sons[i].graphTree(text);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].cleanup();
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

