/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomForest
extends AbstractClassifier
implements OptionHandler,
Randomizable,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler,
PartitionGenerator {
    static final long serialVersionUID = 1116839470751428698L;
    protected int m_numTrees = 10;
    protected int m_numFeatures = 0;
    protected int m_randomSeed = 1;
    protected int m_KValue = 0;
    protected Bagging m_bagger = null;
    protected int m_MaxDepth = 0;
    protected int m_numExecutionSlots = 1;
    protected boolean m_printTrees = false;

    public String globalInfo() {
        return "Class for constructing a forest of random trees.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Random Forests");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "45");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "5-32");
        return result;
    }

    public String numTreesTipText() {
        return "The number of trees to be generated.";
    }

    public int getNumTrees() {
        return this.m_numTrees;
    }

    public void setNumTrees(int newNumTrees) {
        this.m_numTrees = newNumTrees;
    }

    public String numFeaturesTipText() {
        return "The number of attributes to be used in random selection (see RandomTree).";
    }

    public int getNumFeatures() {
        return this.m_numFeatures;
    }

    public void setNumFeatures(int newNumFeatures) {
        this.m_numFeatures = newNumFeatures;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    @Override
    public void setSeed(int seed) {
        this.m_randomSeed = seed;
    }

    @Override
    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the trees, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int value) {
        this.m_MaxDepth = value;
    }

    public String printTreesTipText() {
        return "Print the individual trees in the output";
    }

    public void setPrintTrees(boolean print) {
        this.m_printTrees = print;
    }

    public boolean getPrintTrees() {
        return this.m_printTrees;
    }

    public double measureOutOfBagError() {
        if (this.m_bagger != null) {
            return this.m_bagger.measureOutOfBagError();
        }
        return Double.NaN;
    }

    public void setNumExecutionSlots(int numSlots) {
        this.m_numExecutionSlots = numSlots;
    }

    public int getNumExecutionSlots() {
        return this.m_numExecutionSlots;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureOutOfBagError");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (RandomForest)");
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tNumber of trees to build.", "I", 1, "-I <number of trees>"));
        newVector.addElement(new Option("\tNumber of features to consider (<1=int(logM+1)).", "K", 1, "-K <number of features>"));
        newVector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        newVector.addElement(new Option("\tThe maximum depth of the trees, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        newVector.addElement(new Option("\tPrint the individual trees in the output", "print", 0, "-print"));
        newVector.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-I");
        result.add("" + this.getNumTrees());
        result.add("-K");
        result.add("" + this.getNumFeatures());
        result.add("-S");
        result.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            result.add("-depth");
            result.add("" + this.getMaxDepth());
        }
        if (this.m_printTrees) {
            result.add("-print");
        }
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('I', options);
        this.m_numTrees = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
        tmpStr = Utils.getOption('K', options);
        this.m_numFeatures = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 0;
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption("depth", options);
        if (tmpStr.length() != 0) {
            this.setMaxDepth(Integer.parseInt(tmpStr));
        } else {
            this.setMaxDepth(0);
        }
        this.setPrintTrees(Utils.getFlag("print", options));
        tmpStr = Utils.getOption("num-slots", options);
        if (tmpStr.length() > 0) {
            this.setNumExecutionSlots(Integer.parseInt(tmpStr));
        } else {
            this.setNumExecutionSlots(1);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public Capabilities getCapabilities() {
        return new RandomTree().getCapabilities();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_bagger = new Bagging();
        RandomTree rTree = new RandomTree();
        this.m_KValue = this.m_numFeatures;
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(data.numAttributes()) + 1;
        }
        rTree.setKValue(this.m_KValue);
        rTree.setMaxDepth(this.getMaxDepth());
        this.m_bagger.setClassifier(rTree);
        this.m_bagger.setSeed(this.m_randomSeed);
        this.m_bagger.setNumIterations(this.m_numTrees);
        this.m_bagger.setCalcOutOfBag(true);
        this.m_bagger.setNumExecutionSlots(this.m_numExecutionSlots);
        this.m_bagger.buildClassifier(data);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_bagger.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_bagger == null) {
            return "Random forest not built yet";
        }
        StringBuffer temp = new StringBuffer();
        temp.append("Random forest of " + this.m_numTrees + " trees, each constructed while considering " + this.m_KValue + " random feature" + (this.m_KValue == 1 ? "" : "s") + ".\nOut of bag error: " + Utils.doubleToString(this.m_bagger.measureOutOfBagError(), 4) + "\n" + (this.getMaxDepth() > 0 ? "Max. depth of trees: " + this.getMaxDepth() + "\n" : "") + "\n");
        if (this.m_printTrees) {
            temp.append(this.m_bagger.toString());
        }
        return temp.toString();
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        return this.m_bagger.getMembershipValues(inst);
    }

    @Override
    public int numElements() throws Exception {
        return this.m_bagger.numElements();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9186 $");
    }

    public static void main(String[] argv) {
        RandomForest.runClassifier(new RandomForest(), argv);
    }
}

