/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.rules.Item;
import weka.classifiers.rules.RuleL3;
import weka.classifiers.rules.Transaction;

public class Lazy_Pruning
implements Serializable {
    public static void lazy_main(String[] args) {
        String Rules_File = new String();
        String Transactions_File = new String();
        String Level1_Rules_File = new String();
        String Level2_Rules_File = new String();
        if (args.length != 4) {
            System.out.println("Wrong number of parameters, you must enter four file addresses, in the following order:");
            System.out.println("file with mined rules");
            System.out.println("file with transactions");
            System.out.println("text file where level1 rules should be stored");
            System.out.println("text file where level2 rules should be stored");
            System.exit(1);
        } else {
            Rules_File = args[0];
            Transactions_File = args[1];
            Level1_Rules_File = args[2];
            Level2_Rules_File = args[3];
        }
        ArrayList<RuleL3> List_of_Rules = new ArrayList();
        ArrayList<Transaction> List_of_Transactions = new ArrayList();
        List_of_Rules = Lazy_Pruning.readRules(Rules_File);
        List_of_Transactions = Lazy_Pruning.populateTransactions(Transactions_File);
        Lazy_Pruning.LazyPruning(List_of_Rules, List_of_Transactions, Level1_Rules_File, Level2_Rules_File);
    }

    public static ArrayList<RuleL3> readRules(String rules_file) {
        ArrayList<RuleL3> list_of_rules = new ArrayList<RuleL3>();
        int rule_no = 0;
        try {
            String next_rule;
            BufferedReader in = new BufferedReader(new FileReader(rules_file));
            if (!in.ready()) {
                throw new IOException();
            }
            while ((next_rule = in.readLine()) != null) {
                list_of_rules.add(new RuleL3(next_rule, rule_no++));
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list_of_rules;
    }

    public static ArrayList<Integer> readData(String filename) {
        File file = null;
        boolean file_end = false;
        int i_data = 0;
        String[] big_endian = new String[4];
        ArrayList<Integer> integers = new ArrayList<Integer>();
        file = new File(filename);
        try {
            FileInputStream file_input = new FileInputStream(file);
            DataInputStream data_in = new DataInputStream(file_input);
            while (!file_end) {
                try {
                    i_data = data_in.readInt();
                    Integer i_b = new Integer(i_data);
                    String little_endian = Integer.toBinaryString(i_data);
                    StringBuilder s_builder = new StringBuilder();
                    if (little_endian.length() != 32) {
                        for (int j = 0; j < 32 - little_endian.length(); ++j) {
                            s_builder.append(0);
                        }
                        little_endian = new String(s_builder) + little_endian;
                    }
                    for (int k = 1; k <= 4; ++k) {
                        big_endian[k - 1] = little_endian.substring(8 * (k - 1), 8 * k);
                    }
                    integers.add(Integer.parseInt(big_endian[3] + big_endian[2] + big_endian[1] + big_endian[0], 2));
                }
                catch (EOFException eof) {
                    file_end = true;
                }
            }
            data_in.close();
        }
        catch (IOException e) {
            System.out.println("IO Exception =: " + e);
        }
        return integers;
    }

    public static ArrayList<Transaction> populateTransactions(String transactions_file) {
        int counter = 0;
        ArrayList<Transaction> transaction_list = new ArrayList<Transaction>();
        int tid = 0;
        int cid = 0;
        ArrayList<Integer> integers = Lazy_Pruning.readData(transactions_file);
        while (counter != integers.size()) {
            tid = integers.get(counter++);
            cid = integers.get(counter++);
            int length = integers.get(counter++);
            int Num_Items = length - 1;
            Item[] Items = new Item[Num_Items];
            for (int j = 0; j < Num_Items; ++j) {
                Items[j] = new Item(integers.get(counter++));
            }
            int Class_ID = integers.get(counter++);
            transaction_list.add(new Transaction(tid, cid, Class_ID, Num_Items, Items));
        }
        return transaction_list;
    }

    public static void LazyPruning(ArrayList<RuleL3> list_of_rules, ArrayList<Transaction> list_of_transactions, String level1_rules_file, String level2_rules_file) {
        int transaction_number = 0;
        try {
            FileWriter outFile1 = new FileWriter(level1_rules_file, false);
            PrintWriter out1 = new PrintWriter(outFile1);
            FileWriter outFile2 = new FileWriter(level2_rules_file, false);
            PrintWriter out2 = new PrintWriter(outFile2);
            for (int rule_number = 0; rule_number < list_of_rules.size(); ++rule_number) {
                for (transaction_number = 0; transaction_number < list_of_transactions.size(); ++transaction_number) {
                    list_of_rules.get(rule_number).classifyTrans(list_of_transactions.get(transaction_number));
                }
                list_of_rules.get(rule_number).setLevel();
                if (list_of_rules.get(rule_number).getCorrect() > 0) {
                    transaction_number = 0;
                    while (transaction_number < list_of_transactions.size()) {
                        if (list_of_transactions.get(transaction_number).getLast_Rule() == list_of_rules.get(rule_number).getRule_ID()) {
                            list_of_transactions.remove(transaction_number);
                            transaction_number = 0;
                            continue;
                        }
                        ++transaction_number;
                    }
                }
                String rule = "{";
                for (int i = 0; i < list_of_rules.get(rule_number).getLength(); ++i) {
                    rule = rule + Integer.toString(list_of_rules.get(rule_number).getItems()[i].getValue());
                    if (i == list_of_rules.get(rule_number).getLength() - 1) continue;
                    rule = rule + ",";
                }
                rule = rule + "} -> " + Integer.toString(list_of_rules.get(rule_number).getClass_ID()) + " " + Integer.toString(list_of_rules.get(rule_number).getAbsolute_Support()) + " " + Float.toString(list_of_rules.get(rule_number).getConfidence()) + " " + Integer.toString(list_of_rules.get(rule_number).getCorrect()) + " " + Integer.toString(list_of_rules.get(rule_number).getIncorrect());
                if (list_of_rules.get(rule_number).getLevel() == 1) {
                    out1.println(rule);
                    continue;
                }
                if (list_of_rules.get(rule_number).getLevel() != 2) continue;
                out2.println(rule);
            }
            out1.close();
            out2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print_Transactions_List(ArrayList<Transaction> list_of_transactions) {
        for (int transaction_number = 0; transaction_number < list_of_transactions.size(); ++transaction_number) {
            System.out.println(list_of_transactions.get(transaction_number).gettid());
            System.out.println(list_of_transactions.get(transaction_number).getcid());
            System.out.println(list_of_transactions.get(transaction_number).getNum_Items());
            System.out.println(list_of_transactions.get(transaction_number).getClass_ID());
        }
    }
}

