/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Stacking;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Grading
extends Stacking
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5207837947890081170L;
    protected Classifier[] m_MetaClassifiers = new Classifier[0];
    protected double[] m_InstPerClass = null;

    @Override
    public String globalInfo() {
        return "Implements Grading. The base classifiers are \"graded\".\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A.K. Seewald and J. Fuernkranz");
        result.setValue(TechnicalInformation.Field.TITLE, "An Evaluation of Grading Classifiers");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Intelligent Data Analysis: 4th International Conference");
        result.setValue(TechnicalInformation.Field.EDITOR, "F. Hoffmann et al.");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.PAGES, "115-124");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin/Heidelberg/New York/Tokyo");
        return result;
    }

    @Override
    protected void generateMetaLevel(Instances newData, Random random) throws Exception {
        int i;
        this.m_MetaFormat = this.metaFormat(newData);
        Instances[] metaData = new Instances[this.m_Classifiers.length];
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            metaData[i] = this.metaFormat(newData);
        }
        for (int j = 0; j < this.m_NumFolds; ++j) {
            Instances train = newData.trainCV(this.m_NumFolds, j, random);
            Instances test = newData.testCV(this.m_NumFolds, j);
            for (int i2 = 0; i2 < this.m_Classifiers.length; ++i2) {
                this.getClassifier(i2).buildClassifier(train);
                for (int k = 0; k < test.numInstances(); ++k) {
                    metaData[i2].add(this.metaInstance(test.instance(k), i2));
                }
            }
        }
        this.m_InstPerClass = new double[newData.numClasses()];
        for (i = 0; i < newData.numClasses(); ++i) {
            this.m_InstPerClass[i] = 0.0;
        }
        for (i = 0; i < newData.numInstances(); ++i) {
            int n = (int)newData.instance(i).classValue();
            this.m_InstPerClass[n] = this.m_InstPerClass[n] + 1.0;
        }
        this.m_MetaClassifiers = AbstractClassifier.makeCopies(this.m_MetaClassifier, this.m_Classifiers.length);
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            this.m_MetaClassifiers[i].buildClassifier(metaData[i]);
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] preds;
        int i;
        int numPreds = 0;
        int numClassifiers = this.m_Classifiers.length;
        double[] predConfs = new double[numClassifiers];
        for (i = 0; i < numClassifiers; ++i) {
            preds = this.m_MetaClassifiers[i].distributionForInstance(this.metaInstance(instance, i));
            predConfs[i] = this.m_MetaClassifiers[i].classifyInstance(this.metaInstance(instance, i)) == 1.0 ? preds[1] : -preds[0];
        }
        if (predConfs[Utils.maxIndex(predConfs)] < 0.0) {
            for (i = 0; i < numClassifiers; ++i) {
                predConfs[i] = 1.0 + predConfs[i];
            }
        } else {
            for (i = 0; i < numClassifiers; ++i) {
                if (!(predConfs[i] < 0.0)) continue;
                predConfs[i] = 0.0;
            }
        }
        preds = new double[instance.numClasses()];
        for (i = 0; i < instance.numClasses(); ++i) {
            preds[i] = 0.0;
        }
        for (i = 0; i < numClassifiers; ++i) {
            int idxPreds;
            int n = idxPreds = (int)this.m_Classifiers[i].classifyInstance(instance);
            preds[n] = preds[n] + predConfs[i];
        }
        double maxPreds = preds[Utils.maxIndex(preds)];
        int MaxInstPerClass = -100;
        int MaxClass = -1;
        for (int i2 = 0; i2 < instance.numClasses(); ++i2) {
            if (preds[i2] != maxPreds) continue;
            ++numPreds;
            if (!(this.m_InstPerClass[i2] > (double)MaxInstPerClass)) continue;
            MaxInstPerClass = (int)this.m_InstPerClass[i2];
            MaxClass = i2;
        }
        int predictedIndex = numPreds == 1 ? Utils.maxIndex(preds) : MaxClass;
        double[] classProbs = new double[instance.numClasses()];
        classProbs[predictedIndex] = 1.0;
        return classProbs;
    }

    @Override
    public String toString() {
        int i;
        if (this.m_Classifiers.length == 0) {
            return "Grading: No base schemes entered.";
        }
        if (this.m_MetaClassifiers.length == 0) {
            return "Grading: No meta scheme selected.";
        }
        if (this.m_MetaFormat == null) {
            return "Grading: No model built yet.";
        }
        String result = "Grading\n\nBase classifiers\n\n";
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            result = result + this.getClassifier(i).toString() + "\n\n";
        }
        result = result + "\n\nMeta classifiers\n\n";
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            result = result + this.m_MetaClassifiers[i].toString() + "\n\n";
        }
        return result;
    }

    @Override
    protected Instances metaFormat(Instances instances) throws Exception {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            attributes.addElement(instances.attribute(i));
        }
        FastVector<String> nomElements = new FastVector<String>(2);
        nomElements.addElement("0");
        nomElements.addElement("1");
        attributes.addElement(new Attribute("PredConf", nomElements));
        Instances metaFormat = new Instances("Meta format", attributes, 0);
        metaFormat.setClassIndex(metaFormat.numAttributes() - 1);
        return metaFormat;
    }

    protected Instance metaInstance(Instance instance, int k) throws Exception {
        double predConf;
        double[] values = new double[this.m_MetaFormat.numAttributes()];
        int idx = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            values[idx] = instance.value(i);
            ++idx;
        }
        Classifier classifier = this.getClassifier(k);
        if (this.m_BaseFormat.classAttribute().isNumeric()) {
            throw new Exception("Class Attribute must not be numeric!");
        }
        double[] dist = classifier.distributionForInstance(instance);
        int maxIdx = 0;
        double maxVal = dist[0];
        for (int j = 1; j < dist.length; ++j) {
            if (!(dist[j] > maxVal)) continue;
            maxVal = dist[j];
            maxIdx = j;
        }
        values[idx] = predConf = instance.classValue() == (double)maxIdx ? 1.0 : 0.0;
        DenseInstance metaInstance = new DenseInstance(1.0, values);
        metaInstance.setDataset(this.m_MetaFormat);
        return metaInstance;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }

    public static void main(String[] argv) {
        Grading.runClassifier(new Grading(), argv);
    }
}

