/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;

public class DiscreteFunction
implements RevisionHandler {
    protected DoubleVector points;
    protected DoubleVector values;

    public DiscreteFunction() {
        this(null, null);
    }

    public DiscreteFunction(DoubleVector p) {
        this(p, null);
    }

    public DiscreteFunction(DoubleVector p, DoubleVector v) {
        this.points = p;
        this.values = v;
        this.formalize();
    }

    private DiscreteFunction formalize() {
        if (this.points == null) {
            this.points = new DoubleVector();
        }
        if (this.values == null) {
            this.values = new DoubleVector();
        }
        if (this.points.isEmpty()) {
            if (!this.values.isEmpty()) {
                throw new IllegalArgumentException("sizes not match");
            }
        } else {
            int n = this.points.size();
            if (this.values.isEmpty()) {
                this.values = new DoubleVector(n, 1.0 / (double)n);
            } else if (this.values.size() != n) {
                throw new IllegalArgumentException("sizes not match");
            }
        }
        return this;
    }

    public DiscreteFunction normalize() {
        double s;
        if (!this.values.isEmpty() && (s = this.values.sum()) != 0.0 && s != 1.0) {
            this.values.timesEquals(1.0 / s);
        }
        return this;
    }

    public void sort() {
        IntVector index = this.points.sortWithIndex();
        this.values = this.values.subvector(index);
    }

    public Object clone() {
        DiscreteFunction d = new DiscreteFunction();
        d.points = (DoubleVector)this.points.clone();
        d.values = (DoubleVector)this.values.clone();
        return d;
    }

    public DiscreteFunction unique() {
        int count = 0;
        if (this.size() < 2) {
            return this;
        }
        for (int i = 1; i <= this.size() - 1; ++i) {
            if (this.points.get(count) != this.points.get(i)) {
                this.points.set(++count, this.points.get(i));
                this.values.set(count, this.values.get(i));
                continue;
            }
            this.values.set(count, this.values.get(count) + this.values.get(i));
        }
        this.points = this.points.subvector(0, count);
        this.values = this.values.subvector(0, count);
        return this;
    }

    public int size() {
        if (this.points == null) {
            return 0;
        }
        return this.points.size();
    }

    public double getPointValue(int i) {
        return this.points.get(i);
    }

    public double getFunctionValue(int i) {
        return this.values.get(i);
    }

    public void setPointValue(int i, double p) {
        this.points.set(i, p);
    }

    public void setFunctionValue(int i, double v) {
        this.values.set(i, v);
    }

    protected DoubleVector getPointValues() {
        return this.points;
    }

    protected DoubleVector getFunctionValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DiscreteFunction plus(DiscreteFunction d) {
        return ((DiscreteFunction)this.clone()).plusEquals(d);
    }

    public DiscreteFunction plusEquals(DiscreteFunction d) {
        this.points = this.points.cat(d.points);
        this.values = this.values.cat(d.values);
        return this;
    }

    public DiscreteFunction timesEquals(double x) {
        this.values.timesEquals(x);
        return this;
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        FlexibleDecimalFormat nf1 = new FlexibleDecimalFormat(5);
        nf1.grouping(true);
        FlexibleDecimalFormat nf2 = new FlexibleDecimalFormat(5);
        nf2.grouping(true);
        for (i = 0; i < this.size(); ++i) {
            nf1.update(this.points.get(i));
            nf2.update(this.values.get(i));
        }
        text.append("\t" + nf1.formatString("Points") + "\t" + nf2.formatString("Values") + "\n\n");
        for (i = 0; i <= this.size() - 1; ++i) {
            text.append("\t" + nf1.format(this.points.get(i)) + "\t" + nf2.format(this.values.get(i)) + "\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] args) {
        double[] points = new double[]{2.0, 1.0, 2.0, 3.0, 3.0};
        double[] values = new double[]{3.0, 2.0, 4.0, 1.0, 3.0};
        DiscreteFunction d = new DiscreteFunction(new DoubleVector(points), new DoubleVector(values));
        System.out.println(d);
        d.normalize();
        System.out.println("d (after normalize) = \n" + d);
        points[1] = 10.0;
        System.out.println("d (after setting [1]) = \n" + d);
        d.sort();
        System.out.println("d (after sorting) = \n" + d);
        d.unique();
        System.out.println("d (after unique) = \n" + d);
    }
}

