/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PluginManager {
    protected static Map<String, Map<String, String>> PLUGINS = new HashMap<String, Map<String, String>>();
    protected static Set<String> DISABLED = new HashSet<String>();

    public static synchronized void addToDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.addToDisabledList(s);
        }
    }

    public static synchronized void addToDisabledList(String classname) {
        DISABLED.add(classname);
    }

    public static synchronized void removeFromDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.removeFromDisabledList(s);
        }
    }

    public static synchronized void removeFromDisabledList(String classname) {
        DISABLED.remove(classname);
    }

    public static boolean isInDisabledList(String classname) {
        return DISABLED.contains(classname);
    }

    public static synchronized void addFromProperties(File propsFile) throws Exception {
        BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
        PluginManager.addFromProperties(bi);
    }

    public static synchronized void addFromProperties(InputStream propsStream) throws Exception {
        Properties expProps = new Properties();
        expProps.load(propsStream);
        propsStream.close();
        propsStream = null;
        PluginManager.addFromProperties(expProps);
    }

    public static synchronized void addFromProperties(Properties props) throws Exception {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] parts;
            String implementations = props.getProperty(string);
            if (implementations == null || implementations.length() <= 0) continue;
            for (String impl : parts = implementations.split(",")) {
                PluginManager.addPlugin(string, impl.trim(), impl.trim());
            }
        }
    }

    public static Set<String> getPluginNamesOfType(String interfaceName) {
        if (PLUGINS.get(interfaceName) != null) {
            Set<String> match = PLUGINS.get(interfaceName).keySet();
            HashSet<String> result = new HashSet<String>();
            for (String s : match) {
                String impl = PLUGINS.get(interfaceName).get(s);
                if (DISABLED.contains(impl)) continue;
                result.add(s);
            }
            return result;
        }
        return null;
    }

    public static void addPlugin(String interfaceName, String name, String concreteType) {
        if (PLUGINS.get(interfaceName) == null) {
            TreeMap<String, String> pluginsOfInterfaceType = new TreeMap<String, String>();
            pluginsOfInterfaceType.put(name, concreteType);
            PLUGINS.put(interfaceName, pluginsOfInterfaceType);
        } else {
            PLUGINS.get(interfaceName).put(name, concreteType);
        }
    }

    public static void removePlugins(String interfaceName, List<String> names) {
        for (String name : names) {
            PluginManager.removePlugin(interfaceName, name);
        }
    }

    public static void removePlugin(String interfaceName, String name) {
        if (PLUGINS.get(interfaceName) != null) {
            PLUGINS.get(interfaceName).remove(name);
        }
    }

    public static Object getPluginInstance(String interfaceType, String name) throws Exception {
        if (PLUGINS.get(interfaceType) == null || PLUGINS.get(interfaceType).size() == 0) {
            throw new Exception("No plugins of interface type: " + interfaceType + " available!!");
        }
        Map<String, String> pluginsOfInterfaceType = PLUGINS.get(interfaceType);
        if (pluginsOfInterfaceType.get(name) == null) {
            throw new Exception("Can't find named plugin '" + name + "' of type '" + interfaceType + "'!");
        }
        String concreteImpl = pluginsOfInterfaceType.get(name);
        Object plugin = null;
        if (!DISABLED.contains(concreteImpl)) {
            plugin = Class.forName(concreteImpl).newInstance();
        }
        return plugin;
    }
}

