/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class HillClimber
extends LocalScoreSearchAlgorithm {
    static final long serialVersionUID = 4322783593818122403L;
    Cache m_Cache = null;
    boolean m_bUseArcReversal = false;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.initCache(bayesNet, instances);
        Operation oOperation = this.getOptimalOperation(bayesNet, instances);
        while (oOperation != null && oOperation.m_fDeltaScore > 0.0) {
            this.performOperation(bayesNet, instances, oOperation);
            oOperation = this.getOptimalOperation(bayesNet, instances);
        }
        this.m_Cache = null;
    }

    void initCache(BayesNet bayesNet, Instances instances) throws Exception {
        int iAttribute;
        double[] fBaseScores = new double[instances.numAttributes()];
        int nNrOfAtts = instances.numAttributes();
        this.m_Cache = new Cache(nNrOfAtts);
        for (iAttribute = 0; iAttribute < nNrOfAtts; ++iAttribute) {
            this.updateCache(iAttribute, nNrOfAtts, bayesNet.getParentSet(iAttribute));
        }
        for (iAttribute = 0; iAttribute < nNrOfAtts; ++iAttribute) {
            fBaseScores[iAttribute] = this.calcNodeScore(iAttribute);
        }
        for (int iAttributeHead = 0; iAttributeHead < nNrOfAtts; ++iAttributeHead) {
            for (int iAttributeTail = 0; iAttributeTail < nNrOfAtts; ++iAttributeTail) {
                if (iAttributeHead == iAttributeTail) continue;
                Operation oOperation = new Operation(iAttributeTail, iAttributeHead, 0);
                this.m_Cache.put(oOperation, this.calcScoreWithExtraParent(iAttributeHead, iAttributeTail) - fBaseScores[iAttributeHead]);
            }
        }
    }

    boolean isNotTabu(Operation oOperation) {
        return true;
    }

    Operation getOptimalOperation(BayesNet bayesNet, Instances instances) throws Exception {
        Operation oBestOperation = new Operation();
        oBestOperation = this.findBestArcToAdd(bayesNet, instances, oBestOperation);
        oBestOperation = this.findBestArcToDelete(bayesNet, instances, oBestOperation);
        if (this.getUseArcReversal()) {
            oBestOperation = this.findBestArcToReverse(bayesNet, instances, oBestOperation);
        }
        if (oBestOperation.m_fDeltaScore == -1.0E100) {
            return null;
        }
        return oBestOperation;
    }

    void performOperation(BayesNet bayesNet, Instances instances, Operation oOperation) throws Exception {
        switch (oOperation.m_nOperation) {
            case 0: {
                this.applyArcAddition(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Add " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
                break;
            }
            case 1: {
                this.applyArcDeletion(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Del " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
                break;
            }
            case 2: {
                this.applyArcDeletion(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                this.applyArcAddition(bayesNet, oOperation.m_nTail, oOperation.m_nHead, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Rev " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
            }
        }
    }

    void applyArcAddition(BayesNet bayesNet, int iHead, int iTail, Instances instances) {
        ParentSet bestParentSet = bayesNet.getParentSet(iHead);
        bestParentSet.addParent(iTail, instances);
        this.updateCache(iHead, instances.numAttributes(), bestParentSet);
    }

    void applyArcDeletion(BayesNet bayesNet, int iHead, int iTail, Instances instances) {
        ParentSet bestParentSet = bayesNet.getParentSet(iHead);
        bestParentSet.deleteParent(iTail, instances);
        this.updateCache(iHead, instances.numAttributes(), bestParentSet);
    }

    Operation findBestArcToAdd(BayesNet bayesNet, Instances instances, Operation oBestOperation) {
        int nNrOfAtts = instances.numAttributes();
        for (int iAttributeHead = 0; iAttributeHead < nNrOfAtts; ++iAttributeHead) {
            if (bayesNet.getParentSet(iAttributeHead).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
            for (int iAttributeTail = 0; iAttributeTail < nNrOfAtts; ++iAttributeTail) {
                Operation oOperation;
                if (!this.addArcMakesSense(bayesNet, instances, iAttributeHead, iAttributeTail) || !(this.m_Cache.get(oOperation = new Operation(iAttributeTail, iAttributeHead, 0)) > oBestOperation.m_fDeltaScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fDeltaScore = this.m_Cache.get(oOperation);
            }
        }
        return oBestOperation;
    }

    Operation findBestArcToDelete(BayesNet bayesNet, Instances instances, Operation oBestOperation) {
        int nNrOfAtts = instances.numAttributes();
        for (int iNode = 0; iNode < nNrOfAtts; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            for (int iParent = 0; iParent < parentSet.getNrOfParents(); ++iParent) {
                Operation oOperation = new Operation(parentSet.getParent(iParent), iNode, 1);
                if (!(this.m_Cache.get(oOperation) > oBestOperation.m_fDeltaScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fDeltaScore = this.m_Cache.get(oOperation);
            }
        }
        return oBestOperation;
    }

    Operation findBestArcToReverse(BayesNet bayesNet, Instances instances, Operation oBestOperation) {
        int nNrOfAtts = instances.numAttributes();
        for (int iNode = 0; iNode < nNrOfAtts; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            for (int iParent = 0; iParent < parentSet.getNrOfParents(); ++iParent) {
                Operation oOperation;
                int iTail = parentSet.getParent(iParent);
                if (!this.reverseArcMakesSense(bayesNet, instances, iNode, iTail) || bayesNet.getParentSet(iTail).getNrOfParents() >= this.m_nMaxNrOfParents || !(this.m_Cache.get(oOperation = new Operation(parentSet.getParent(iParent), iNode, 2)) > oBestOperation.m_fDeltaScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fDeltaScore = this.m_Cache.get(oOperation);
            }
        }
        return oBestOperation;
    }

    void updateCache(int iAttributeHead, int nNrOfAtts, ParentSet parentSet) {
        double fBaseScore = this.calcNodeScore(iAttributeHead);
        int nNrOfParents = parentSet.getNrOfParents();
        for (int iAttributeTail = 0; iAttributeTail < nNrOfAtts; ++iAttributeTail) {
            Operation oOperation;
            if (iAttributeTail == iAttributeHead) continue;
            if (!parentSet.contains(iAttributeTail)) {
                if (nNrOfParents >= this.m_nMaxNrOfParents) continue;
                oOperation = new Operation(iAttributeTail, iAttributeHead, 0);
                this.m_Cache.put(oOperation, this.calcScoreWithExtraParent(iAttributeHead, iAttributeTail) - fBaseScore);
                continue;
            }
            oOperation = new Operation(iAttributeTail, iAttributeHead, 1);
            this.m_Cache.put(oOperation, this.calcScoreWithMissingParent(iAttributeHead, iAttributeTail) - fBaseScore);
        }
    }

    public void setMaxNrOfParents(int nMaxNrOfParents) {
        this.m_nMaxNrOfParents = nMaxNrOfParents;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tMaximum number of parents", "P", 1, "-P <nr of parents>"));
        newVector.addElement(new Option("\tUse arc reversal operation.\n\t(default false)", "R", 0, "-R"));
        newVector.addElement(new Option("\tInitial structure is empty (instead of Naive Bayes)", "N", 0, "-N"));
        newVector.addElement(new Option("\tInitial structure specified in XML BIF file", "X", 1, "-X"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseArcReversal(Utils.getFlag('R', options));
        this.setInitAsNaiveBayes(!Utils.getFlag('N', options));
        this.m_sInitalBIFFile = Utils.getOption('X', options);
        String sMaxNrOfParents = Utils.getOption('P', options);
        if (sMaxNrOfParents.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(sMaxNrOfParents));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[9 + superOptions.length];
        int current = 0;
        if (this.getUseArcReversal()) {
            options[current++] = "-R";
        }
        if (!this.getInitAsNaiveBayes()) {
            options[current++] = "-N";
        }
        if (this.m_sInitalBIFFile != null && !this.m_sInitalBIFFile.equals("")) {
            options[current++] = "-X";
            options[current++] = this.m_sInitalBIFFile;
        }
        options[current++] = "-P";
        options[current++] = "" + this.m_nMaxNrOfParents;
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setInitAsNaiveBayes(boolean bInitAsNaiveBayes) {
        this.m_bInitAsNaiveBayes = bInitAsNaiveBayes;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public boolean getUseArcReversal() {
        return this.m_bUseArcReversal;
    }

    public void setUseArcReversal(boolean bUseArcReversal) {
        this.m_bUseArcReversal = bUseArcReversal;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a hill climbing algorithm adding, deleting and reversing arcs. The search is not restricted by an order on the variables (unlike K2). The difference with B and B2 is that this hill climber also considers arrows part of the naive Bayes structure for deletion.";
    }

    public String useArcReversalTipText() {
        return "When set to true, the arc reversal operation is used in the search.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    class Cache
    implements RevisionHandler {
        double[][] m_fDeltaScoreAdd;
        double[][] m_fDeltaScoreDel;

        Cache(int nNrOfNodes) {
            this.m_fDeltaScoreAdd = new double[nNrOfNodes][nNrOfNodes];
            this.m_fDeltaScoreDel = new double[nNrOfNodes][nNrOfNodes];
        }

        public void put(Operation oOperation, double fValue) {
            if (oOperation.m_nOperation == 0) {
                this.m_fDeltaScoreAdd[oOperation.m_nTail][oOperation.m_nHead] = fValue;
            } else {
                this.m_fDeltaScoreDel[oOperation.m_nTail][oOperation.m_nHead] = fValue;
            }
        }

        public double get(Operation oOperation) {
            switch (oOperation.m_nOperation) {
                case 0: {
                    return this.m_fDeltaScoreAdd[oOperation.m_nTail][oOperation.m_nHead];
                }
                case 1: {
                    return this.m_fDeltaScoreDel[oOperation.m_nTail][oOperation.m_nHead];
                }
                case 2: {
                    return this.m_fDeltaScoreDel[oOperation.m_nTail][oOperation.m_nHead] + this.m_fDeltaScoreAdd[oOperation.m_nHead][oOperation.m_nTail];
                }
            }
            return 0.0;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    class Operation
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -4880888790432547895L;
        static final int OPERATION_ADD = 0;
        static final int OPERATION_DEL = 1;
        static final int OPERATION_REVERSE = 2;
        public int m_nTail;
        public int m_nHead;
        public int m_nOperation;
        public double m_fDeltaScore = -1.0E100;

        public Operation() {
        }

        public Operation(int nTail, int nHead, int nOperation) {
            this.m_nHead = nHead;
            this.m_nTail = nTail;
            this.m_nOperation = nOperation;
        }

        public boolean equals(Operation other) {
            if (other == null) {
                return false;
            }
            return this.m_nOperation == other.m_nOperation && this.m_nHead == other.m_nHead && this.m_nTail == other.m_nTail;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

