/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.NumericToBinary;

public class InfoGainAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    static final long serialVersionUID = -1949849512589218930L;
    private boolean m_missing_merge;
    private boolean m_Binarize;
    private double[] m_InfoGains;

    public String globalInfo() {
        return "InfoGainAttributeEval :\n\nEvaluates the worth of an attribute by measuring the information gain with respect to the class.\n\nInfoGain(Class,Attribute) = H(Class) - H(Class | Attribute).\n";
    }

    public InfoGainAttributeEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        newVector.addElement(new Option("\tjust binarize numeric attributes instead \n\tof properly discretizing them.", "B", 0, "-B"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', options));
        this.setBinarizeNumericAttributes(Utils.getFlag('B', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (!this.getMissingMerge()) {
            options[current++] = "-M";
        }
        if (this.getBinarizeNumericAttributes()) {
            options[current++] = "-B";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String binarizeNumericAttributesTipText() {
        return "Just binarize numeric attributes instead of properly discretizing them.";
    }

    public void setBinarizeNumericAttributes(boolean b) {
        this.m_Binarize = b;
    }

    public boolean getBinarizeNumericAttributes() {
        return this.m_Binarize;
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean b) {
        this.m_missing_merge = b;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        int k;
        this.getCapabilities().testWithFail(data);
        int classIndex = data.classIndex();
        int numInstances = data.numInstances();
        if (!this.m_Binarize) {
            Discretize disTransform = new Discretize();
            disTransform.setUseBetterEncoding(true);
            disTransform.setInputFormat(data);
            data = Filter.useFilter(data, disTransform);
        } else {
            NumericToBinary binTransform = new NumericToBinary();
            binTransform.setInputFormat(data);
            data = Filter.useFilter(data, binTransform);
        }
        int numClasses = data.attribute(classIndex).numValues();
        double[][][] counts = new double[data.numAttributes()][][];
        for (int k2 = 0; k2 < data.numAttributes(); ++k2) {
            if (k2 == classIndex) continue;
            int numValues = data.attribute(k2).numValues();
            counts[k2] = new double[numValues + 1][numClasses + 1];
        }
        double[] temp = new double[numClasses + 1];
        for (k = 0; k < numInstances; ++k) {
            Instance inst = data.instance(k);
            if (inst.classIsMissing()) {
                int n = numClasses;
                temp[n] = temp[n] + inst.weight();
                continue;
            }
            int n = (int)inst.classValue();
            temp[n] = temp[n] + inst.weight();
        }
        for (k = 0; k < counts.length; ++k) {
            if (k == classIndex) continue;
            for (int i = 0; i < temp.length; ++i) {
                counts[k][0][i] = temp[i];
            }
        }
        for (k = 0; k < numInstances; ++k) {
            Instance inst = data.instance(k);
            for (int i = 0; i < inst.numValues(); ++i) {
                if (inst.index(i) == classIndex) continue;
                if (inst.isMissingSparse(i) || inst.classIsMissing()) {
                    if (!inst.isMissingSparse(i)) {
                        double[] dArray = counts[inst.index(i)][(int)inst.valueSparse(i)];
                        int n = numClasses;
                        dArray[n] = dArray[n] + inst.weight();
                        double[] dArray2 = counts[inst.index(i)][0];
                        int n2 = numClasses;
                        dArray2[n2] = dArray2[n2] - inst.weight();
                        continue;
                    }
                    if (!inst.classIsMissing()) {
                        double[] dArray = counts[inst.index(i)][data.attribute(inst.index(i)).numValues()];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                        double[] dArray3 = counts[inst.index(i)][0];
                        int n3 = (int)inst.classValue();
                        dArray3[n3] = dArray3[n3] - inst.weight();
                        continue;
                    }
                    double[] dArray = counts[inst.index(i)][data.attribute(inst.index(i)).numValues()];
                    int n = numClasses;
                    dArray[n] = dArray[n] + inst.weight();
                    double[] dArray4 = counts[inst.index(i)][0];
                    int n4 = numClasses;
                    dArray4[n4] = dArray4[n4] - inst.weight();
                    continue;
                }
                double[] dArray = counts[inst.index(i)][(int)inst.valueSparse(i)];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] + inst.weight();
                double[] dArray5 = counts[inst.index(i)][0];
                int n5 = (int)inst.classValue();
                dArray5[n5] = dArray5[n5] - inst.weight();
            }
        }
        if (this.m_missing_merge) {
            for (k = 0; k < data.numAttributes(); ++k) {
                int j;
                int i;
                if (k == classIndex) continue;
                int numValues = data.attribute(k).numValues();
                double[] rowSums = new double[numValues];
                double[] columnSums = new double[numClasses];
                double sum = 0.0;
                for (int i2 = 0; i2 < numValues; ++i2) {
                    for (int j2 = 0; j2 < numClasses; ++j2) {
                        int n = i2;
                        rowSums[n] = rowSums[n] + counts[k][i2][j2];
                        int n6 = j2;
                        columnSums[n6] = columnSums[n6] + counts[k][i2][j2];
                    }
                    sum += rowSums[i2];
                }
                if (!Utils.gr(sum, 0.0)) continue;
                double[][] additions = new double[numValues][numClasses];
                for (i = 0; i < numValues; ++i) {
                    for (j = 0; j < numClasses; ++j) {
                        additions[i][j] = rowSums[i] / sum * counts[k][numValues][j];
                    }
                }
                for (i = 0; i < numClasses; ++i) {
                    for (j = 0; j < numValues; ++j) {
                        double[] dArray = additions[j];
                        int n = i;
                        dArray[n] = dArray[n] + columnSums[i] / sum * counts[k][j][numClasses];
                    }
                }
                for (i = 0; i < numClasses; ++i) {
                    for (j = 0; j < numValues; ++j) {
                        double[] dArray = additions[j];
                        int n = i;
                        dArray[n] = dArray[n] + counts[k][j][i] / sum * counts[k][numValues][numClasses];
                    }
                }
                double[][] newTable = new double[numValues][numClasses];
                for (int i3 = 0; i3 < numValues; ++i3) {
                    for (int j3 = 0; j3 < numClasses; ++j3) {
                        newTable[i3][j3] = counts[k][i3][j3] + additions[i3][j3];
                    }
                }
                counts[k] = newTable;
            }
        }
        this.m_InfoGains = new double[data.numAttributes()];
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (i == classIndex) continue;
            this.m_InfoGains[i] = ContingencyTables.entropyOverColumns(counts[i]) - ContingencyTables.entropyConditionedOnRows(counts[i]);
        }
    }

    protected void resetOptions() {
        this.m_InfoGains = null;
        this.m_missing_merge = true;
        this.m_Binarize = false;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        return this.m_InfoGains[attribute];
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_InfoGains == null) {
            text.append("Information Gain attribute evaluator has not been built");
        } else {
            text.append("\tInformation Gain Ranking Filter");
            if (!this.m_missing_merge) {
                text.append("\n\tMissing values treated as seperate");
            }
            if (this.m_Binarize) {
                text.append("\n\tNumeric attributes are just binarized");
            }
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        InfoGainAttributeEval.runEvaluator(new InfoGainAttributeEval(), args);
    }
}

