/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers.weightedvoters;

import development.DataSets;
import fileIO.OutFile;
import java.io.FileNotFoundException;
import timeseriesweka.classifiers.ensembles.voting.BestIndividualTrain;
import timeseriesweka.classifiers.ensembles.voting.MajorityConfidence;
import timeseriesweka.classifiers.ensembles.weightings.EqualWeighting;
import timeseriesweka.classifiers.ensembles.weightings.TrainAcc;
import utilities.ClassifierResults;
import utilities.StatisticalUtilities;
import vector_classifiers.CAWPE;
import weka.core.Instances;

public class CAWPE_TunedAlpha
extends CAWPE {
    public int[] alphaParaRange = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, Integer.MAX_VALUE};
    public int alpha = 4;
    public double[] alphaParaAccs = null;

    public CAWPE_TunedAlpha() {
        this.ensembleIdentifier = "HESCA_TunedAlpha";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        long buildTime;
        this.printlnDebug("**HESCA TRAIN**");
        if (this.resultsFilesParametersInitialised) {
            if (this.readResultsFilesDirectories.length > 1 && this.readResultsFilesDirectories.length != this.modules.length) {
                throw new Exception("HESCA.buildClassifier: more than one results path given, but number given does not align with the number of classifiers/modules.");
            }
            if (this.writeResultsFilesDirectory == null) {
                this.writeResultsFilesDirectory = this.readResultsFilesDirectories[0];
            }
        }
        long startTime = System.currentTimeMillis();
        this.train = this.transform == null ? new Instances(data) : this.transform.process(data);
        this.numTrainInsts = this.train.numInstances();
        this.numClasses = this.train.numClasses();
        this.numAttributes = this.train.numAttributes();
        this.initialiseModules();
        ClassifierResults[] alphaResults = new ClassifierResults[this.alphaParaRange.length];
        this.alphaParaAccs = new double[this.alphaParaRange.length];
        double maxAcc = -1.0;
        int maxAccInd = -1;
        for (int i = 0; i < this.alphaParaRange.length; ++i) {
            this.initCombinationSchemes(this.alphaParaRange[i]);
            alphaResults[i] = this.doEnsembleCV(data);
            this.alphaParaAccs[i] = alphaResults[i].acc;
            if (!(alphaResults[i].acc > maxAcc)) continue;
            maxAcc = alphaResults[i].acc;
            maxAccInd = i;
        }
        this.alpha = this.alphaParaRange[maxAccInd];
        this.initCombinationSchemes(this.alpha);
        this.ensembleTrainResults = alphaResults[maxAccInd];
        this.ensembleTrainResults.buildTime = buildTime = System.currentTimeMillis() - startTime;
        if (this.writeEnsembleTrainingFile) {
            this.writeEnsembleCVResults(this.train);
        }
        this.testInstCounter = 0;
    }

    protected void initCombinationSchemes(int alphaVal) throws Exception {
        if (alphaVal == 0) {
            this.weightingScheme = new EqualWeighting();
            this.votingScheme = new MajorityConfidence();
        } else if (alphaVal == Integer.MAX_VALUE) {
            this.weightingScheme = new EqualWeighting();
            this.votingScheme = new BestIndividualTrain();
        } else {
            this.weightingScheme = new TrainAcc(alphaVal);
            this.votingScheme = new MajorityConfidence();
        }
        this.weightingScheme.defineWeightings(this.modules, this.numClasses);
        this.votingScheme.trainVotingScheme(this.modules, this.numClasses);
    }

    @Override
    public String getParameters() {
        StringBuilder out = new StringBuilder();
        if (this.ensembleTrainResults != null) {
            out.append("BuildTime,").append(this.ensembleTrainResults.buildTime).append(",Trainacc,").append(this.ensembleTrainResults.acc).append(",");
        } else {
            out.append("BuildTime,").append("-1").append(",Trainacc,").append("-1").append(",");
        }
        out.append(this.weightingScheme.toString()).append(",").append(this.votingScheme.toString()).append(",");
        for (int m = 0; m < this.modules.length; ++m) {
            out.append(this.modules[m].getModuleName()).append("(").append(this.modules[m].priorWeight);
            for (int j = 0; j < this.modules[m].posteriorWeights.length; ++j) {
                out.append("/").append(this.modules[m].posteriorWeights[j]);
            }
            out.append("),");
        }
        out.append("alphaParaAccs=").append(this.alphaParaRange[0]).append(":").append(this.alphaParaAccs[0]);
        for (int i = 1; i < this.alphaParaRange.length; ++i) {
            out.append("/").append(this.alphaParaRange[i]).append(":").append(this.alphaParaAccs[i]);
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
    }

    public static void buildParaAnalysisFiles() throws FileNotFoundException {
        String resPath = "C:/JamesLPHD/HESCA/UCI/UCIResults/";
        int numfolds = 30;
        String[] dsets = DataSets.UCIContinuousFileNames;
        String classifier = "HESCA_TunedAlpha";
        OutFile outAlphaSelected = new OutFile(resPath + classifier + "/alphaParaValues.csv");
        OutFile outDsetStdDevOverAlpha = new OutFile(resPath + classifier + "/alphaParaStdDevOverAlphaAccForEachFold.csv");
        OutFile outTSSAlphaAccs = new OutFile(resPath + classifier + "/alphaParaAccsByFold.csv");
        OutFile outDsetAvgAlphaAccs = new OutFile(resPath + classifier + "/alphaParasAvgOverDataset.csv");
        OutFile outDsetStdDevOverFolds = new OutFile(resPath + classifier + "/alphaParaStdDevInAccOverFoldsForEachPara.csv");
        for (int alpha : new CAWPE_TunedAlpha().alphaParaRange) {
            outTSSAlphaAccs.writeString("," + alpha);
            outDsetStdDevOverFolds.writeString("," + alpha);
            outDsetAvgAlphaAccs.writeString("," + alpha);
        }
        outTSSAlphaAccs.writeLine("");
        outDsetStdDevOverFolds.writeLine("");
        outDsetAvgAlphaAccs.writeLine("");
        System.out.println("\t" + classifier);
        for (String dset : dsets) {
            System.out.println(dset);
            outAlphaSelected.writeString(dset);
            outDsetStdDevOverAlpha.writeString(dset);
            outDsetAvgAlphaAccs.writeString(dset);
            outDsetStdDevOverFolds.writeString(dset);
            double[][] alphaByFoldAccs = new double[new CAWPE_TunedAlpha().alphaParaRange.length][numfolds];
            for (int fold = 0; fold < numfolds; ++fold) {
                String predictions = resPath + classifier + "/Predictions/" + dset;
                ClassifierResults cr = new ClassifierResults(predictions + "/testFold" + fold + ".csv");
                String[] paraParts = cr.getParas().split(",");
                outTSSAlphaAccs.writeString(dset + "_" + fold);
                String[] alphaParaAccStrings = paraParts[paraParts.length - 1].split("/");
                double[] alphaAccsOnThisFold = new double[alphaParaAccStrings.length];
                for (int i = 0; i < alphaParaAccStrings.length; ++i) {
                    String paraAcc = alphaParaAccStrings[i];
                    double acc = Double.parseDouble(paraAcc.split(":")[1]);
                    outTSSAlphaAccs.writeString("," + acc);
                    alphaAccsOnThisFold[i] = acc;
                    alphaByFoldAccs[i][fold] = acc;
                }
                outTSSAlphaAccs.writeLine("");
                outDsetStdDevOverAlpha.writeString("," + StatisticalUtilities.standardDeviation(alphaAccsOnThisFold, false, StatisticalUtilities.mean(alphaAccsOnThisFold, false)));
                String weightToString = paraParts[2];
                if (weightToString.equals("EqualWeighting")) {
                    outAlphaSelected.writeString(",equal");
                    continue;
                }
                if (weightToString.equals("BestIndividualTrain")) {
                    outAlphaSelected.writeString(",pickbest");
                    continue;
                }
                int alphaSelected = 1;
                if (weightToString.contains("(")) {
                    alphaSelected = (int)Double.parseDouble(weightToString.split("\\(")[1].split("\\)")[0]);
                }
                outAlphaSelected.writeString("," + alphaSelected);
            }
            for (int i = 0; i < alphaByFoldAccs.length; ++i) {
                double meanAlphaAccOnDset = StatisticalUtilities.mean(alphaByFoldAccs[i], false);
                outDsetAvgAlphaAccs.writeString("," + meanAlphaAccOnDset);
                outDsetStdDevOverFolds.writeString("," + StatisticalUtilities.standardDeviation(alphaByFoldAccs[i], false, meanAlphaAccOnDset));
            }
            outAlphaSelected.writeLine("");
            outDsetStdDevOverAlpha.writeLine("");
            outDsetAvgAlphaAccs.writeLine("");
            outDsetStdDevOverFolds.writeLine("");
        }
        outAlphaSelected.closeFile();
        outTSSAlphaAccs.closeFile();
        outDsetAvgAlphaAccs.closeFile();
        outDsetStdDevOverFolds.closeFile();
        outDsetStdDevOverAlpha.closeFile();
    }
}

