/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import development.CollateResults;
import development.Experiments;
import fileIO.OutFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import timeseriesweka.classifiers.ParameterSplittable;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.CrossValidator;
import utilities.DebugPrinting;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.SaveEachParameter;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class TunedXGBoost
extends AbstractClassifier
implements SaveParameterInfo,
DebugPrinting,
TrainAccuracyEstimate,
SaveEachParameter,
ParameterSplittable {
    int seed = 0;
    Random rng = null;
    int numTrainInsts = -1;
    int numAtts = -1;
    int numClasses = -1;
    Instances trainInsts = null;
    DMatrix trainDMat = null;
    Booster booster = null;
    ClassifierResults trainResults = new ClassifierResults();
    float rowSubsampling = 0.8f;
    float colSubsampling = 0.8f;
    float learningRate = 0.1f;
    static float[] learningRateParaRange = new float[]{0.01f, 0.05f, 0.1f, 0.2f, 0.3f};
    int maxTreeDepth = 4;
    static int[] maxTreeDepthParaRange = new int[]{2, 4, 6, 8, 10};
    int minChildWeight = 1;
    static int[] minChildWeightParaRange = new int[]{1, 3, 5, 7, 9};
    int numIterations = 500;
    static int[] numIterationsParaRange = new int[]{50, 100, 250, 500, 1000};
    int maxOptionsPerPara = 5;
    int cvFolds = 10;
    boolean tuneParameters = false;
    boolean estimateAcc = true;
    protected String resultsPath;
    protected boolean saveEachParaAcc = false;
    ArrayList<Double> paramAccuracies;
    private long combinedBuildTime;
    String trainPath = "";
    protected boolean findTrainAcc = true;
    static int numPCs = 7;

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int rngSeed) {
        this.seed = rngSeed;
    }

    public boolean getTuneParameters() {
        return this.tuneParameters;
    }

    public void setTuneParameters(boolean tuneParameters) {
        this.tuneParameters = tuneParameters;
    }

    public float getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(float learningRate) {
        this.learningRate = learningRate;
    }

    public int getMaxTreeDepth() {
        return this.maxTreeDepth;
    }

    public void setMaxTreeDepth(int maxTreeDepth) {
        this.maxTreeDepth = maxTreeDepth;
    }

    public int getMinChildWeight() {
        return this.minChildWeight;
    }

    public void setMinChildWeight(int minChildWeight) {
        this.minChildWeight = minChildWeight;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void tuneHyperparameters() throws Exception {
        File f;
        ClassifierResults tempResults;
        this.printlnDebug("tuneHyperparameters()");
        double minErr = 1.0;
        this.paramAccuracies = new ArrayList();
        Instances trainCopy = new Instances(this.trainInsts);
        CrossValidator cv = new CrossValidator();
        cv.setSeed(this.seed);
        cv.setNumFolds(this.cvFolds);
        cv.buildFolds(trainCopy);
        ArrayList<XGBoostParamResultsHolder> ties = new ArrayList<XGBoostParamResultsHolder>();
        int count = 0;
        OutFile temp = null;
        for (float p1 : learningRateParaRange) {
            for (int p2 : maxTreeDepthParaRange) {
                for (int p3 : minChildWeightParaRange) {
                    for (int p4 : numIterationsParaRange) {
                        File f2;
                        if (this.saveEachParaAcc && (f2 = new File(this.resultsPath + ++count + ".csv")).exists()) {
                            if (CollateResults.validateSingleFoldFile(this.resultsPath + count + ".csv")) continue;
                            System.out.println("Deleting file " + this.resultsPath + count + ".csv because size =" + f2.length());
                        }
                        TunedXGBoost model = new TunedXGBoost();
                        model.setLearningRate(p1);
                        model.setMaxTreeDepth(p2);
                        model.setMinChildWeight(p3);
                        model.setNumIterations(p4);
                        model.tuneParameters = false;
                        model.estimateAcc = false;
                        model.setSeed(count);
                        tempResults = cv.crossValidateWithStats(model, trainCopy);
                        tempResults.setName("XGBoostPara" + count);
                        tempResults.setParas("learningRate," + p1 + ",maxTreeDepth," + p2 + ",minChildWeight," + p3 + ",numIterations=" + p4);
                        double e = 1.0 - tempResults.acc;
                        this.printlnDebug("learningRate=" + p1 + ",maxTreeDepth" + p2 + ",minChildWeight=" + p3 + ",numIterations=" + p4 + " Acc = " + (1.0 - e));
                        this.paramAccuracies.add(tempResults.acc);
                        if (this.saveEachParaAcc) {
                            temp = new OutFile(this.resultsPath + count + ".csv");
                            temp.writeLine(tempResults.writeResultsFileToString());
                            temp.closeFile();
                            f = new File(this.resultsPath + count + ".csv");
                            if (!f.exists()) continue;
                            f.setWritable(true, false);
                            continue;
                        }
                        if (e < minErr) {
                            minErr = e;
                            ties = new ArrayList();
                            ties.add(new XGBoostParamResultsHolder(p1, p2, p3, p4, tempResults));
                            continue;
                        }
                        if (e != minErr) continue;
                        ties.add(new XGBoostParamResultsHolder(p1, p2, p3, p4, tempResults));
                    }
                }
            }
        }
        minErr = 1.0;
        if (this.saveEachParaAcc) {
            int missing = 0;
            for (float p1 : learningRateParaRange) {
                for (int p2 : maxTreeDepthParaRange) {
                    for (int p3 : minChildWeightParaRange) {
                        for (int p4 : numIterationsParaRange) {
                            File f3 = new File(this.resultsPath + count + ".csv");
                            if (f3.exists() && f3.length() > 0L) continue;
                            ++missing;
                        }
                    }
                }
            }
            if (missing == 0) {
                this.combinedBuildTime = 0L;
                count = 0;
                for (float p1 : learningRateParaRange) {
                    for (int p2 : maxTreeDepthParaRange) {
                        for (int p3 : minChildWeightParaRange) {
                            for (int p4 : numIterationsParaRange) {
                                tempResults = new ClassifierResults();
                                tempResults.loadFromFile(this.resultsPath + ++count + ".csv");
                                this.combinedBuildTime += tempResults.buildTime;
                                double e = 1.0 - tempResults.acc;
                                if (e < minErr) {
                                    minErr = e;
                                    ties = new ArrayList();
                                    ties.add(new XGBoostParamResultsHolder(p1, p2, p3, p4, tempResults));
                                } else if (e == minErr) {
                                    ties.add(new XGBoostParamResultsHolder(p1, p2, p3, p4, tempResults));
                                }
                                f = new File(this.resultsPath + count + ".csv");
                                if (f.delete()) continue;
                                System.out.println("DELETE FAILED " + this.resultsPath + count + ".csv");
                            }
                        }
                    }
                }
                XGBoostParamResultsHolder best = (XGBoostParamResultsHolder)Collections.max(ties);
                this.printlnDebug("Best learning rate =" + best.learningRate + " best max depth = " + best.maxTreeDepth + " best min child weight =" + best.minChildWeight + " best num iterations =" + best.numIterations + " acc = " + this.trainResults.acc + " (num ties = " + ties.size() + ")");
                this.setLearningRate(best.learningRate);
                this.setMaxTreeDepth(best.maxTreeDepth);
                this.setMinChildWeight(best.minChildWeight);
                this.trainResults = best.results;
            } else {
                System.out.println(this.resultsPath + " error: missing  =" + missing + " parameter values");
            }
        } else {
            this.printlnDebug("\nTies Handling: ");
            for (XGBoostParamResultsHolder tie : ties) {
                this.printlnDebug(tie.toString());
            }
            this.printlnDebug("\n");
            XGBoostParamResultsHolder best = (XGBoostParamResultsHolder)Collections.max(ties);
            this.printlnDebug("Best learning rate =" + best.learningRate + " best max depth = " + best.maxTreeDepth + " best min child weight =" + best.minChildWeight + " best num iterations =" + best.numIterations + " acc = " + this.trainResults.acc + " (num ties = " + ties.size() + ")");
            this.setLearningRate(best.learningRate);
            this.setMaxTreeDepth(best.maxTreeDepth);
            this.setMinChildWeight(best.minChildWeight);
            this.trainResults = best.results;
        }
    }

    public void buildActualClassifer() throws Exception {
        if (this.tuneParameters) {
            this.tuneHyperparameters();
        }
        String objective = "multi:softprob";
        this.trainDMat = TunedXGBoost.wekaInstancesToDMatrix(this.trainInsts);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            params.put("nthread", 1);
        }
        params.put("silent", 1);
        params.put("objective", objective);
        if (objective.contains("multi")) {
            params.put("num_class", this.numClasses);
        }
        params.put("seed", this.seed);
        params.put("subsample", Float.valueOf(this.rowSubsampling));
        params.put("colsample_bytree", Float.valueOf(this.colSubsampling));
        params.put("learning_rate", Float.valueOf(this.learningRate));
        params.put("max_depth", this.maxTreeDepth);
        params.put("min_child_weight", this.minChildWeight);
        HashMap watches = new HashMap();
        this.booster = XGBoost.train((DMatrix)this.trainDMat, params, (int)this.numIterations, watches, null, null);
    }

    public ClassifierResults estimateTrainAcc(Instances insts) throws Exception {
        this.printlnDebug("estimateTrainAcc()");
        TunedXGBoost xg = new TunedXGBoost();
        xg.setLearningRate(this.learningRate);
        xg.setMaxTreeDepth(this.maxTreeDepth);
        xg.setMinChildWeight(this.minChildWeight);
        xg.setNumIterations(this.numIterations);
        xg.tuneParameters = false;
        xg.estimateAcc = false;
        xg.setSeed(this.seed);
        CrossValidator cv = new CrossValidator();
        cv.setSeed(this.seed);
        cv.setNumFolds(this.cvFolds);
        cv.buildFolds(insts);
        return cv.crossValidateWithStats(xg, insts);
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        long startTime = System.currentTimeMillis();
        this.booster = null;
        this.trainResults = new ClassifierResults();
        this.trainInsts = new Instances(insts);
        this.numTrainInsts = insts.numInstances();
        this.numAtts = insts.numAttributes();
        this.numClasses = insts.numClasses();
        if (this.cvFolds > this.numTrainInsts) {
            this.cvFolds = this.numTrainInsts;
        }
        this.rng = new Random(this.seed);
        this.buildActualClassifer();
        if (this.estimateAcc && !this.tuneParameters) {
            this.trainResults = this.estimateTrainAcc(this.trainInsts);
        }
        this.trainResults.buildTime = this.saveEachParaAcc ? this.combinedBuildTime : System.currentTimeMillis() - startTime;
        if (this.trainPath != "") {
            OutFile f = new OutFile(this.trainPath);
            f.writeLine(this.trainInsts.relationName() + "," + (this.tuneParameters ? "TunedXGBoost" : "XGBoost") + ",Train");
            f.writeLine(this.getParameters());
            f.writeLine(this.trainResults.acc + "");
            f.writeLine(this.trainResults.writeInstancePredictions());
            f.closeFile();
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) {
        double[] dist = new double[this.numClasses];
        Instances instHolder = new Instances(this.trainInsts, 0);
        instHolder.add(inst);
        DMatrix testInstMat = null;
        try {
            testInstMat = TunedXGBoost.wekaInstancesToDMatrix(instHolder);
        }
        catch (XGBoostError ex) {
            System.err.println("Error converting test inst to DMatrix form: \n" + (Object)((Object)ex));
            System.exit(0);
        }
        try {
            float[][] predicts = this.booster.predict(testInstMat);
            for (int c = 0; c < this.numClasses; ++c) {
                dist[c] = predicts[0][c];
            }
        }
        catch (XGBoostError ex) {
            System.err.println("Error predicting test inst: \n" + (Object)((Object)ex));
            System.exit(0);
        }
        return dist;
    }

    public static DMatrix wekaInstancesToDMatrix(Instances insts) throws XGBoostError {
        int numRows = insts.numInstances();
        int numCols = insts.numAttributes() - 1;
        float[] data = new float[numRows * numCols];
        float[] labels = new float[numRows];
        int ind = 0;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                data[ind++] = (float)insts.instance(i).value(j);
            }
            labels[i] = (float)insts.instance(i).classValue();
        }
        DMatrix dmat = new DMatrix(data, numRows, numCols);
        dmat.setLabel(labels);
        return dmat;
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainPath = train;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.trainResults;
    }

    @Override
    public void setPathToSaveParameters(String r) {
        this.resultsPath = r;
        this.setSaveEachParaAcc(true);
    }

    @Override
    public void setSaveEachParaAcc(boolean bln) {
        this.saveEachParaAcc = bln;
    }

    @Override
    public void setParamSearch(boolean bln) {
        this.tuneParameters = bln;
    }

    @Override
    public void setParametersFromIndex(int x) {
        this.tuneParameters = false;
        if (x < 1 || x > this.maxOptionsPerPara * this.maxOptionsPerPara * this.maxOptionsPerPara * this.maxOptionsPerPara) {
            throw new UnsupportedOperationException("ERROR parameter index " + x + " out of range for TunedXGBoost");
        }
        int learningRateIndex = (x - 1) / (this.maxOptionsPerPara * this.maxOptionsPerPara * this.maxOptionsPerPara);
        int maxTreeDepthIndex = (x - 1) / (this.maxOptionsPerPara * this.maxOptionsPerPara) % this.maxOptionsPerPara;
        int minChildWeightIndex = (x - 1) / this.maxOptionsPerPara % this.maxOptionsPerPara;
        int numIterationsIndex = x % this.maxOptionsPerPara;
        this.setLearningRate(learningRateParaRange[learningRateIndex]);
        this.setMaxTreeDepth(maxTreeDepthParaRange[maxTreeDepthIndex]);
        this.setMinChildWeight(minChildWeightParaRange[minChildWeightIndex]);
        this.setNumIterations(numIterationsParaRange[numIterationsIndex]);
        this.printlnDebug("Index =" + x + " LearningRate=" + this.learningRate + " MaxTreeDepth=" + this.maxTreeDepth + " MinChildWeight =" + this.minChildWeight + " NumIterations =" + this.numIterations);
    }

    @Override
    public String getParameters() {
        String result = "BuildTime," + this.trainResults.buildTime + ",CVAcc," + this.trainResults.acc;
        result = result + ",learningRate," + this.learningRate;
        result = result + ",maxTreeDepth," + this.maxTreeDepth;
        result = result + ",minChildWeight," + this.minChildWeight;
        result = result + ",numIterations," + this.numIterations;
        if (this.tuneParameters) {
            for (double d : this.paramAccuracies) {
                result = result + "," + d;
            }
        }
        return result;
    }

    @Override
    public String getParas() {
        return this.getParameters();
    }

    @Override
    public double getAcc() {
        return this.trainResults.acc;
    }

    public static void main(String[] args) throws Exception {
        int initialInd = Integer.parseInt(args[0]) % numPCs;
        for (int maxFolds : new int[]{10, 15, 20, 25, 30}) {
            int fold;
            int ind = initialInd;
            for (fold = 5; fold < maxFolds; ++fold) {
                TunedXGBoost.fillerExps(ind, fold, true);
            }
            ++ind;
            ind %= numPCs;
            for (fold = 5; fold < maxFolds; ++fold) {
                TunedXGBoost.fillerExps(ind, fold, false);
            }
        }
    }

    public static void fillerExps(int ind, int nFolds, boolean order) throws Exception {
        String[] dsets = new String[]{"abalone", "acute-inflammation", "acute-nephritis", "annealing", "arrhythmia", "audiology-std", "balance-scale", "balloons", "bank", "blood", "breast-cancer", "breast-cancer-wisc", "breast-cancer-wisc-diag", "breast-cancer-wisc-prog", "breast-tissue", "car", "cardiotocography-3clases", "cardiotocography-10clases", "chess-krvkp", "congressional-voting", "conn-bench-sonar-mines-rocks", "conn-bench-vowel-deterding", "contrac", "credit-approval", "cylinder-bands", "dermatology", "echocardiogram", "ecoli", "energy-y1", "energy-y2", "fertility", "flags", "glass", "haberman-survival", "hayes-roth", "heart-cleveland", "heart-hungarian", "heart-switzerland", "heart-va", "hepatitis", "hill-valley", "horse-colic", "ilpd-indian-liver", "image-segmentation", "ionosphere", "iris", "led-display", "lenses", "letter", "libras", "low-res-spect", "lung-cancer", "lymphography", "magic", "mammographic", "molec-biol-promoter", "molec-biol-splice", "monks-1", "monks-2", "monks-3", "mushroom", "musk-1", "musk-2", "nursery", "oocytes_merluccius_nucleus_4d", "oocytes_merluccius_states_2f", "oocytes_trisopterus_nucleus_2f", "oocytes_trisopterus_states_5b", "optical", "ozone", "page-blocks", "parkinsons", "pendigits", "pima", "pittsburg-bridges-MATERIAL", "pittsburg-bridges-REL-L", "pittsburg-bridges-SPAN", "pittsburg-bridges-T-OR-D", "pittsburg-bridges-TYPE", "planning", "plant-margin", "plant-shape", "plant-texture", "post-operative", "primary-tumor", "ringnorm", "seeds", "semeion", "soybean", "spambase", "spect", "spectf", "statlog-australian-credit", "statlog-german-credit", "statlog-heart", "statlog-image", "statlog-landsat", "statlog-shuttle", "statlog-vehicle", "steel-plates", "synthetic-control", "teaching", "thyroid", "tic-tac-toe", "titanic", "trains", "twonorm", "vertebral-column-2clases", "vertebral-column-3clases", "wall-following", "waveform", "waveform-noise", "wine", "wine-quality-red", "wine-quality-white", "yeast", "zoo"};
        List<String> dsetsToSkip = Arrays.asList("adult", "chess-kvrk", "miniboone", "magic");
        int dsetInc = (int)Math.ceil(dsets.length / numPCs);
        if (order) {
            for (int dset = ind * dsetInc; dset < (ind + 1) * dsetInc && dset < dsets.length; ++dset) {
                if (dsetsToSkip.contains(dsets[dset])) continue;
                for (int fold = 0; fold < nFolds; ++fold) {
                    Experiments.main(new String[]{"Z:/Data/UCIContinuous/", "Z:/Results/UCIContinuous/", "true", "TunedXGBoost", dsets[dset], "" + (fold + 1), "true"});
                }
            }
        } else {
            for (int dset = (ind + 1) * dsetInc - 1; dset >= ind * dsetInc && dset < dsets.length; --dset) {
                if (dsetsToSkip.contains(dsets[dset])) continue;
                for (int fold = 0; fold < nFolds; ++fold) {
                    Experiments.main(new String[]{"Z:/Data/UCIContinuous/", "Z:/Results/UCIContinuous/", "true", "TunedXGBoost", dsets[dset], "" + (fold + 1), "true"});
                }
            }
        }
    }

    public static void exps(int ind) {
        String resPath = "Z:/Results/TSCProblems/";
        int numfolds = 30;
        String[] dsetsAll = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxOutlineCorrect", "DistalPhalanxTW", "Earthquakes", "ECG200", "ECG5000", "ECGFiveDays", "ElectricDevices", "FaceAll", "FaceFour", "FacesUCR", "fiftywords", "fish", "FordA", "FordB", "GunPoint", "Ham", "HandOutlines", "Haptics", "Herring", "InlineSkate", "InsectWingbeatSound", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "MALLAT", "Meat", "MedicalImages", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxTW", "MoteStrain", "NonInvasiveFatalECGThorax1", "NonInvasiveFatalECGThorax2", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Phoneme", "Plane", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "StarLightCurves", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryAll", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "yoga"};
        String[][] dsets = new String[][]{{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxOutlineCorrect", "DistalPhalanxTW", "Earthquakes", "ECG200", "ECG5000", "ECGFiveDays", "ElectricDevices", "FaceAll", "FaceFour", "FacesUCR", "fiftywords", "fish", "FordA"}, {"FordB", "GunPoint", "Ham", "HandOutlines", "Haptics", "Herring", "InlineSkate", "InsectWingbeatSound", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "MALLAT", "Meat", "MedicalImages", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxTW", "MoteStrain"}, {"NonInvasiveFatalECGThorax1", "NonInvasiveFatalECGThorax2", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Phoneme", "Plane", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2"}, {"StarLightCurves", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryAll", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "yoga"}};
        String classifier = "XGBoost";
        System.out.println("\t" + classifier);
        for (String dset : dsets[ind]) {
            System.out.println(dset);
            Instances train = ClassifierTools.loadData("Z:/Data/TSCProblems/" + dset + "/" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("Z:/Data/TSCProblems/" + dset + "/" + dset + "_TEST.arff");
            for (int fold = 0; fold < numfolds; ++fold) {
                System.out.print(fold + ",");
                String predictions = resPath + classifier + "/Predictions/" + dset;
                File f = new File(predictions);
                if (!f.exists()) {
                    f.mkdirs();
                }
                if (CollateResults.validateSingleFoldFile(predictions + "/testFold" + fold + ".csv")) continue;
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, fold);
                Classifier c = Experiments.setClassifier(classifier, fold);
                Experiments.singleClassifierAndFoldTrainTestSplit(data[0], data[1], c, fold, predictions);
            }
            System.out.println("");
        }
    }

    public static class XGBoostParamResultsHolder
    implements Comparable<XGBoostParamResultsHolder> {
        float learningRate;
        int maxTreeDepth;
        int minChildWeight;
        int numIterations;
        int conservedness;
        ClassifierResults results;

        XGBoostParamResultsHolder(float learningRate, int maxTreeDepth, int minChildWeight, int numIterations, ClassifierResults r) {
            this.learningRate = learningRate;
            this.maxTreeDepth = maxTreeDepth;
            this.minChildWeight = minChildWeight;
            this.numIterations = numIterations;
            this.conservedness = this.computeConservedness();
            this.results = r;
        }

        public String toString() {
            return "learningRate=" + this.learningRate + ",maxTreeDepth=" + this.maxTreeDepth + ",minChildWeight" + this.minChildWeight + ",numIterations=" + this.numIterations + ",conservedness=" + this.conservedness + ",acc=" + this.results.acc;
        }

        public int computeConservedness() {
            return (1 + Arrays.binarySearch(learningRateParaRange, this.learningRate)) * (1 + Arrays.binarySearch(maxTreeDepthParaRange, this.maxTreeDepth)) * (1 + (minChildWeightParaRange.length - Arrays.binarySearch(minChildWeightParaRange, this.minChildWeight))) * (1 + Arrays.binarySearch(numIterationsParaRange, this.numIterations));
        }

        @Override
        public int compareTo(XGBoostParamResultsHolder other) {
            return other.conservedness - this.conservedness;
        }
    }
}

