/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import utilities.ClassifierTools;
import utilities.GenericTools;
import utilities.InstanceTools;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.functions.LinearRegression;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class MultiLinearRegression
extends AbstractClassifier {
    Instances numericClassInsts = null;
    LinearRegression[] regressors = null;

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.numericClassInsts = new Instances(data);
        this.numericClassInsts.setClassIndex(0);
        this.numericClassInsts.deleteAttributeAt(this.numericClassInsts.numAttributes() - 1);
        Attribute newClassAtt = new Attribute("newClassVal");
        this.numericClassInsts.insertAttributeAt(newClassAtt, this.numericClassInsts.numAttributes());
        this.numericClassInsts.setClassIndex(this.numericClassInsts.numAttributes() - 1);
        this.regressors = new LinearRegression[data.numClasses()];
        double[] trueClassVals = data.attributeToDoubleArray(data.classIndex());
        for (int c = 0; c < data.numClasses(); ++c) {
            for (int i = 0; i < this.numericClassInsts.numInstances(); ++i) {
                double cval = trueClassVals[i] == (double)c ? 1.0 : 0.0;
                this.numericClassInsts.instance(i).setClassValue(cval);
            }
            this.regressors[c] = new LinearRegression();
            this.regressors[c].buildClassifier(this.numericClassInsts);
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        Instances newinst = new Instances(this.numericClassInsts, 0);
        newinst.add(new DenseInstance(1.0, inst.toDoubleArray()));
        newinst.instance(0).setClassMissing();
        double[] outputs = new double[this.regressors.length];
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = this.regressors[i].classifyInstance(newinst.instance(0));
        }
        double max = GenericTools.max(outputs);
        double min = GenericTools.min(outputs);
        double sum = 0.0;
        if (max == min) {
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = 1.0 / (double)outputs.length;
            }
        } else {
            int i;
            for (i = 0; i < outputs.length; ++i) {
                outputs[i] = (outputs[i] - min) / (max - min);
                sum += outputs[i];
            }
            i = 0;
            while (i < outputs.length) {
                int n = i++;
                outputs[n] = outputs[n] / sum;
            }
        }
        return outputs;
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        double[] dist = this.distributionForInstance(inst);
        return GenericTools.indexOfMax(dist);
    }

    public static void main(String[] args) throws Exception {
        Instances all = ClassifierTools.loadData("Z:/Data/UCIContinuous/molec-biol-promoter/molec-biol-promoter.arff");
        int folds = 10;
        double acc = 0.0;
        for (int i = 0; i < folds; ++i) {
            Instances[] data = InstanceTools.resampleInstances(all, i, 0.5);
            MultiLinearRegression mlr = new MultiLinearRegression();
            mlr.buildClassifier(data[0]);
            double a = 0.0;
            for (int j = 0; j < data[1].numInstances(); ++j) {
                double p;
                double pred = mlr.classifyInstance(data[1].instance(j));
                if (pred != (p = data[1].instance(i).classValue())) continue;
                a += 1.0;
            }
            System.out.println(a / (double)data[1].numInstances());
            acc += a / (double)data[1].numInstances();
        }
        System.out.println("acc=" + acc / (double)folds);
    }
}

