/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class ChooseDatasetFromFile
implements Classifier {
    private Random randomNumber;
    private final int bufferSize = 100000;
    private int foldNumber = 0;
    private int indexOfLargest = 0;
    ArrayList<String> line;
    private String resultsPath = "Results/";
    private String name = "EnsembleResults";
    private String classifier;
    private String finalRelationName;
    private String[] relationNames;
    private double[] accuracies;
    private File dir;
    private BufferedReader[] trainFiles;
    private BufferedReader testFile;
    private BufferedWriter outTrain;
    private BufferedWriter outTest;

    public void setFold(int foldNumber) {
        this.foldNumber = foldNumber;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setResultsPath(String resultsPath) {
        this.resultsPath = resultsPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRelationNames(String[] names) {
        this.relationNames = names;
    }

    public void setFinalRelationName(String name) {
        this.finalRelationName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.dir = new File(this.resultsPath + "/" + this.name + "/Predictions/" + this.finalRelationName + "/trainFold" + this.foldNumber + ".csv");
        if (!this.dir.exists()) {
            try {
                int i;
                int i2;
                this.trainFiles = new BufferedReader[this.relationNames.length];
                this.accuracies = new double[this.relationNames.length];
                for (i2 = 0; i2 < this.relationNames.length; ++i2) {
                    this.trainFiles[i2] = new BufferedReader(new FileReader(this.resultsPath + "/" + this.classifier + "/Predictions/" + this.relationNames[i2] + "/trainFold" + this.foldNumber + ".csv"), 100000);
                    this.trainFiles[i2].mark(100000);
                    this.trainFiles[i2].readLine();
                    this.trainFiles[i2].readLine();
                    this.accuracies[i2] = Double.valueOf(this.trainFiles[i2].readLine());
                }
                for (i2 = 0; i2 < this.accuracies.length; ++i2) {
                    if (!(this.accuracies[i2] > this.accuracies[this.indexOfLargest])) continue;
                    this.indexOfLargest = i2;
                }
                ArrayList<Integer> duplicates = new ArrayList<Integer>();
                for (i = 0; i < this.accuracies.length; ++i) {
                    if (this.accuracies[this.indexOfLargest] != this.accuracies[i] || this.indexOfLargest == i) continue;
                    duplicates.add(i);
                }
                this.randomNumber = new Random(this.foldNumber);
                if (!duplicates.isEmpty()) {
                    this.indexOfLargest = this.randomNumber.nextInt(duplicates.size());
                }
                this.dir = new File(this.resultsPath + "/" + this.name + "/Predictions/" + this.finalRelationName);
                this.dir.mkdirs();
                this.outTrain = new BufferedWriter(new FileWriter(this.dir + "/trainFold" + this.foldNumber + ".csv"));
                this.trainFiles[this.indexOfLargest].reset();
                this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine().split(",")));
                this.line.set(1, this.name);
                this.outTrain.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTrain.newLine();
                this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine().split(",")));
                this.line.add("originalDataset");
                this.line.add(this.relationNames[this.indexOfLargest]);
                this.outTrain.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTrain.newLine();
                while ((this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine()))).get(0) != null) {
                    this.outTrain.write(this.line.get(0));
                    this.outTrain.newLine();
                }
                this.outTest = new BufferedWriter(new FileWriter(this.dir + "/testFold" + this.foldNumber + ".csv"));
                this.testFile = new BufferedReader(new FileReader(this.resultsPath + "/" + this.classifier + "/Predictions/" + this.relationNames[this.indexOfLargest] + "/testFold" + this.foldNumber + ".csv"), 100000);
                this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine().split(",")));
                this.line.set(1, this.name);
                this.outTest.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTest.newLine();
                this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine().split(",")));
                this.line.add("originalDataset");
                this.line.add(this.relationNames[this.indexOfLargest]);
                this.outTest.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTest.newLine();
                while ((this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine()))).get(0) != null) {
                    this.outTest.write(this.line.get(0));
                    this.outTest.newLine();
                }
                for (i = 0; i < this.relationNames.length; ++i) {
                    this.trainFiles[i].close();
                    this.testFile.close();
                }
                this.outTrain.flush();
                this.outTrain.close();
                this.outTest.flush();
                this.outTest.close();
            }
            catch (FileNotFoundException | NumberFormatException e) {
                System.out.println("Fold " + this.foldNumber + " not present: " + e);
            }
        } else {
            System.out.println(this.dir.getAbsolutePath() + ": Already exists.");
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.classifyInstance(instance);
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

