/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class ChooseClassifierFromFile
implements Classifier {
    private Random randomNumber;
    private final int bufferSize = 100000;
    private int foldNumber = 0;
    private int indexOfLargest = 0;
    ArrayList<String> line;
    private String[] resultsPaths = new String[]{"Results/"};
    private String resultsWritePath = null;
    private String[] classifiers = new String[]{"TunedSVMRBF", "TunedSVMPolynomial"};
    private String name = "EnsembleResults";
    private String relationName = "abalone";
    private double[] accuracies;
    private File dir;
    private BufferedReader[] trainFiles;
    private BufferedReader testFile;
    private BufferedWriter outTrain;
    private BufferedWriter outTest;

    public void setFold(int foldNumber) {
        this.foldNumber = foldNumber;
    }

    public void setClassifiers(String[] classifiers) {
        this.classifiers = classifiers;
    }

    public void setResultsPath(String[] resultsPaths) {
        this.resultsPaths = resultsPaths;
    }

    public void setResultsPath(String resultsPath) {
        this.resultsPaths = new String[]{resultsPath};
    }

    public void setResultsWritePath(String writePath) {
        this.resultsWritePath = writePath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRelationName(String name) {
        this.relationName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.resultsPaths.length > 1 && this.resultsPaths.length != this.classifiers.length) {
            throw new Exception("ChooseClassifierFromFile.buildClassifier: more than one results path given, but number given does not align with the number of classifiers.");
        }
        if (this.resultsWritePath == null) {
            this.resultsWritePath = this.resultsPaths[0];
        }
        this.dir = new File(this.resultsWritePath + "/" + this.name + "/Predictions/" + this.relationName + "/trainFold" + this.foldNumber + ".csv");
        if (!this.dir.exists()) {
            try {
                int pathIndex;
                int i;
                this.trainFiles = new BufferedReader[this.classifiers.length];
                this.accuracies = new double[this.classifiers.length];
                for (i = 0; i < this.classifiers.length; ++i) {
                    pathIndex = this.resultsPaths.length == 1 ? 0 : i;
                    this.trainFiles[i] = new BufferedReader(new FileReader(this.resultsPaths[pathIndex] + "/" + this.classifiers[i] + "/Predictions/" + this.relationName + "/trainFold" + this.foldNumber + ".csv"), 100000);
                    this.trainFiles[i].mark(100000);
                    this.trainFiles[i].readLine();
                    this.trainFiles[i].readLine();
                    this.accuracies[i] = Double.valueOf(this.trainFiles[i].readLine());
                }
                for (i = 0; i < this.accuracies.length; ++i) {
                    if (!(this.accuracies[i] > this.accuracies[this.indexOfLargest])) continue;
                    this.indexOfLargest = i;
                }
                ArrayList<Integer> duplicates = new ArrayList<Integer>();
                for (int i2 = 0; i2 < this.accuracies.length; ++i2) {
                    if (this.accuracies[this.indexOfLargest] != this.accuracies[i2] || this.indexOfLargest == i2) continue;
                    duplicates.add(i2);
                }
                this.randomNumber = new Random(this.foldNumber);
                if (!duplicates.isEmpty()) {
                    this.indexOfLargest = this.randomNumber.nextInt(duplicates.size());
                }
                this.dir = new File(this.resultsWritePath + "/" + this.name + "/Predictions/" + this.relationName);
                this.dir.mkdirs();
                this.outTrain = new BufferedWriter(new FileWriter(this.dir + "/trainFold" + this.foldNumber + ".csv"));
                this.trainFiles[this.indexOfLargest].reset();
                this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine().split(",")));
                this.line.set(1, this.name);
                this.outTrain.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTrain.newLine();
                this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine().split(",")));
                this.line.add("originalClassifier");
                this.line.add(this.classifiers[this.indexOfLargest]);
                this.outTrain.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTrain.newLine();
                while ((this.line = new ArrayList<String>(Arrays.asList(this.trainFiles[this.indexOfLargest].readLine()))).get(0) != null) {
                    this.outTrain.write(this.line.get(0));
                    this.outTrain.newLine();
                }
                this.outTest = new BufferedWriter(new FileWriter(this.dir + "/testFold" + this.foldNumber + ".csv"));
                pathIndex = this.resultsPaths.length == 1 ? 0 : this.indexOfLargest;
                this.testFile = new BufferedReader(new FileReader(this.resultsPaths[pathIndex] + "/" + this.classifiers[this.indexOfLargest] + "/Predictions/" + this.relationName + "/testFold" + this.foldNumber + ".csv"), 100000);
                this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine().split(",")));
                this.line.set(1, this.name);
                this.outTest.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTest.newLine();
                this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine().split(",")));
                this.line.add("originalClassifier");
                this.line.add(this.classifiers[this.indexOfLargest]);
                this.outTest.write(this.line.toString().replace("[", "").replace("]", ""));
                this.outTest.newLine();
                while ((this.line = new ArrayList<String>(Arrays.asList(this.testFile.readLine()))).get(0) != null) {
                    this.outTest.write(this.line.get(0));
                    this.outTest.newLine();
                }
                for (int i3 = 0; i3 < this.classifiers.length; ++i3) {
                    this.trainFiles[i3].close();
                    this.testFile.close();
                }
                this.outTrain.flush();
                this.outTrain.close();
                this.outTest.flush();
                this.outTest.close();
            }
            catch (FileNotFoundException | NumberFormatException e) {
                System.out.println("Fold " + this.foldNumber + " not present: " + e);
            }
        } else {
            System.out.println(this.dir.getAbsolutePath() + ": Already exists.");
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.classifyInstance(instance);
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

