/*
 * Decompiled with CFR 0.152.
 */
package utilities.multivariate_tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import utilities.ClassifierTools;
import utilities.multivariate_tools.ConvertDatasets;
import utilities.multivariate_tools.MultivariateInstanceTools;
import weka.core.Instances;

public class createMultivariateDatasetFromCSV {
    public static void main(String[] args) throws FileNotFoundException {
        File f = new File("D:\\Work\\Dropbox\\Multivariate TSC\\Baydogan Matlab\\");
        for (File f1 : f.listFiles()) {
            String name = f1.getName();
            createMultivariateDatasetFromCSV.createDataset(f1.getAbsolutePath() + "\\", name, name + "_train.csv", "TRAIN");
            createMultivariateDatasetFromCSV.createDataset(f1.getAbsolutePath() + "\\", name, name + "_test.csv", "TEST");
        }
    }

    static void createDataset(String dir, String name, String dataset_csv, String affix) throws FileNotFoundException {
        int i;
        List<Data> dataset = createMultivariateDatasetFromCSV.loadDataset(new File(dir + dataset_csv));
        int shortest_length = dataset.stream().mapToInt(e -> e.mat.stream().mapToInt(e1 -> ((double[])e1).length).min().getAsInt()).min().getAsInt();
        for (Data data : dataset) {
            for (int i2 = 0; i2 < data.mat.size(); ++i2) {
                data.mat.set(i2, Arrays.copyOfRange(data.mat.get(i2), 0, shortest_length));
            }
        }
        Instances[] univariate_datasets = new Instances[dataset.get((int)0).mat.size()];
        for (i = 0; i < univariate_datasets.length; ++i) {
            ArrayList<double[]> series = new ArrayList<double[]>();
            double[] labels = new double[dataset.size()];
            for (int j = 0; j < dataset.size(); ++j) {
                series.add(dataset.get((int)j).mat.get(i));
                labels[j] = dataset.get((int)j).val;
            }
            univariate_datasets[i] = ConvertDatasets.buildArff(series, labels);
        }
        for (i = 0; i < univariate_datasets.length; ++i) {
            ClassifierTools.saveDataset(univariate_datasets[i], dir + name + "_" + i + "_" + affix);
        }
        Instances output = MultivariateInstanceTools.mergeToMultivariateInstances(univariate_datasets);
        ClassifierTools.saveDataset(output, dir + name + "_" + affix);
    }

    static List<Data> loadDataset(File fname) throws FileNotFoundException {
        Scanner sc = new Scanner(fname);
        ArrayList<Data> dataset = new ArrayList<Data>();
        ArrayList<Object> mat = new ArrayList<double[]>();
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            if (line.length() > 2) {
                double[] doubleValues = Arrays.stream(line.split(",")).mapToDouble(Double::parseDouble).toArray();
                mat.add(doubleValues);
                continue;
            }
            dataset.add(new Data(mat, Double.parseDouble(line)));
            mat = new ArrayList();
        }
        return dataset;
    }

    static class Data {
        List<double[]> mat;
        double val;

        Data(List<double[]> matrix, double classValue) {
            this.mat = matrix;
            this.val = classValue;
        }
    }
}

