/*
 * Decompiled with CFR 0.152.
 */
package utilities.multivariate_tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import utilities.ClassifierTools;
import utilities.GenericTools;
import utilities.multivariate_tools.MultivariateInstanceTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;

public class ConvertDatasets {
    static int classIndex = 0;

    public static void main(String[] args) throws FileNotFoundException {
        ConvertDatasets.createMVMotion();
    }

    static void createAALTD() {
        String[] end = new String[]{"X", "Y", "Z"};
        String dir = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
        String dataset = "AALTD";
        for (int i = 0; i < 8; ++i) {
            Instances[] data = new Instances[end.length];
            int j = 0;
            for (String en : end) {
                data[j++] = ClassifierTools.loadData(dir + dataset + "\\univariate\\" + dataset + "_" + i + "_" + en + "_TRAIN");
            }
            Instances merged = MultivariateInstanceTools.mergeToMultivariateInstances(data);
            ClassifierTools.saveDataset(merged, dir + dataset + "\\" + dataset + "_" + i);
            Instances[] train_test = MultivariateInstanceTools.resampleMultivariateInstances(merged, 0L, 0.5);
            ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_" + i + "_TRAIN");
            ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_" + i + "_TEST");
        }
    }

    static void createCricket() {
        String[] end = new String[]{"X", "Y", "Z"};
        String dir = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
        String dataset = "Cricket";
        for (String LR : new String[]{"Left", "Right"}) {
            Instances[] data = new Instances[end.length];
            int j = 0;
            for (String end1 : end) {
                data[j++] = ClassifierTools.loadData(dir + dataset + "\\univariate\\" + dataset + end1 + LR);
            }
            Instances merged = MultivariateInstanceTools.mergeToMultivariateInstances(data);
            ClassifierTools.saveDataset(merged, dir + dataset + "\\" + dataset + "_" + LR);
            Instances[] train_test = MultivariateInstanceTools.resampleMultivariateInstances(merged, 0L, 0.5);
            ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_" + LR + "_TRAIN");
            ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_" + LR + "_TEST");
        }
    }

    public static void createArticularyWord() {
        String[] end = new String[]{"X", "Y", "Z"};
        String dir = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
        String dataset = "ArticularyWord";
        for (String LR : new String[]{"LL", "T1", "UL"}) {
            Instances[] data = new Instances[end.length];
            int j = 0;
            for (String end1 : end) {
                data[j++] = ClassifierTools.loadData(dir + dataset + "\\univariate\\" + dataset + LR + end1);
            }
            Instances merged = MultivariateInstanceTools.mergeToMultivariateInstances(data);
            ClassifierTools.saveDataset(merged, dir + dataset + "\\" + dataset + "_" + LR);
            Instances[] train_test = MultivariateInstanceTools.resampleMultivariateInstances(merged, 0L, 0.5);
            ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_" + LR + "_TRAIN");
            ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_" + LR + "_TEST");
        }
    }

    public static void createVillar() {
        String dir = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
        String dataset = "VillarData";
        Instances[] train_test = MultivariateInstanceTools.resampleMultivariateInstances(ClassifierTools.loadData(dir + dataset + "\\" + dataset), 0L, 0.5);
        ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_TRAIN");
        ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_TEST");
    }

    public static void createMVMotion() {
        String dir = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
        String dir2 = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\Old data\\MVMotion\\MVMotion2.arff";
        Instances data = ClassifierTools.loadData(dir2);
        Instances[] data_channels = MultivariateInstanceTools.splitMultivariateInstances(data);
        Instances[] accel_channels = Arrays.copyOfRange(data_channels, 0, 3);
        Instances accel = MultivariateInstanceTools.mergeToMultivariateInstances(accel_channels);
        Instances[] gyro_channels = Arrays.copyOfRange(data_channels, 3, 6);
        Instances gyro = MultivariateInstanceTools.mergeToMultivariateInstances(gyro_channels);
        String dataset = "MVMotionA";
        Instances[] train_test = MultivariateInstanceTools.resampleMultivariateInstances(accel, 0L, 0.5);
        ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_TRAIN");
        ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_TEST");
        dataset = "MVMotionAG";
        train_test = MultivariateInstanceTools.resampleMultivariateInstances(data, 0L, 0.5);
        ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_TRAIN");
        ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_TEST");
        dataset = "MVMotionG";
        train_test = MultivariateInstanceTools.resampleMultivariateInstances(gyro, 0L, 0.5);
        ClassifierTools.saveDataset(train_test[0], dir + dataset + "\\" + dataset + "_TRAIN");
        ClassifierTools.saveDataset(train_test[1], dir + dataset + "\\" + dataset + "_TEST");
    }

    public static void createSingleDatasets(String dir1, String dirName, int classInd) throws FileNotFoundException {
        classIndex = classInd;
        File dir = new File(dir1 + dirName + "\\");
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            Instances data = ConvertDatasets.createArff(f);
            ClassifierTools.saveDataset(data, dir + "\\" + dirName + "_" + f.getName());
        }
    }

    public static Instances createArff(File f_in) throws FileNotFoundException {
        Scanner sc = new Scanner(f_in);
        ArrayList<double[]> timeseries = new ArrayList<double[]>();
        ArrayList<Double> classVals = new ArrayList<Double>();
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] data = line.split("\\s+");
            int end = classIndex == 0 ? data.length : data.length - 1;
            double[] d = new double[data.length - 1];
            int i2 = 0;
            for (int start = classIndex == 0 ? 1 : 0; start < end; ++start) {
                d[i2++] = Double.parseDouble(data[start]);
            }
            timeseries.add(d);
            classVals.add(Double.parseDouble(data[classIndex]));
        }
        return ConvertDatasets.buildArff(timeseries, classVals.stream().mapToDouble(i -> i).toArray());
    }

    public static Instances buildArff(List<double[]> dataRows, double[] classVals) {
        int i;
        Instances output = null;
        int dimCols = dataRows.get(0).length;
        int dimRows = dataRows.size();
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i2 = 0; i2 < dimCols; ++i2) {
            attributes.addElement(new Attribute("attr" + String.valueOf(i2 + 1)));
        }
        double[] values = ConvertDatasets.uniqueValues(classVals);
        Arrays.sort(values);
        FastVector<String> vals = new FastVector<String>(values.length);
        for (i = 0; i < values.length; ++i) {
            vals.addElement("" + values[i]);
        }
        attributes.addElement(new Attribute("classAttribute", vals));
        output = new Instances("", attributes, dataRows.size());
        for (i = 0; i < dimRows; ++i) {
            output.add(new DenseInstance(dimCols + 1));
            for (int j = 0; j < dimCols; ++j) {
                output.instance(i).setValue(j, dataRows.get(i)[j]);
            }
            output.instance(i).setValue(dimCols, GenericTools.indexOf(values, classVals[i]));
        }
        output.setClassIndex(output.numAttributes() - 1);
        return output;
    }

    public static double[] uniqueValues(double[] classVals) {
        HashSet<Double> set = new HashSet<Double>();
        for (double d : classVals) {
            set.add(d);
        }
        return set.stream().mapToDouble(Double::doubleValue).toArray();
    }
}

