/*
 * Decompiled with CFR 0.152.
 */
package utilities.multivariate_tools;

import fileIO.OutFile;
import java.util.Arrays;
import java.util.Map;
import multivariate_timeseriesweka.DataSets;
import timeseriesweka.filters.SummaryStats;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.multivariate_tools.MultivariateInstanceTools;
import weka.core.Instances;

public class CalculateDatasetsStats {
    public static void main(String[] args) throws Exception {
        for (String dataset : DataSets.arransList) {
            int j;
            int i;
            OutFile out = new OutFile(DataSets.dropboxPath + dataset + "_summarystats.txt");
            Instances train = ClassifierTools.loadData(DataSets.dropboxPath + dataset + "/" + dataset + "_TRAIN.arff");
            Instances[] channels = MultivariateInstanceTools.splitMultivariateInstances(train);
            out.writeLine("num instances " + train.numInstances());
            out.writeLine("num dimenions " + channels.length);
            out.writeLine("dimension length " + channels[0].numAttributes());
            out.writeLine("num classes " + train.numClasses());
            out.writeLine("[mean, variance, skewness, kurtosis, min, max]");
            double[][][] overallStatsByClass = new double[channels.length][train.numClasses()][6];
            double[][] overallStats = new double[channels.length][6];
            for (i = 0; i < channels.length; ++i) {
                overallStatsByClass[i] = CalculateDatasetsStats.calculateStatsForInstances(channels[i]);
            }
            for (i = 0; i < channels.length; ++i) {
                j = 0;
                while (j < 6) {
                    for (int k = 0; k < train.numClasses(); ++k) {
                        double[] dArray = overallStats[i];
                        int n = j;
                        dArray[n] = dArray[n] + overallStatsByClass[i][k][j];
                    }
                    double[] dArray = overallStats[i];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)train.numClasses();
                }
                out.writeLine("Channel " + i + " " + Arrays.toString(overallStats[i]));
            }
            for (i = 0; i < channels.length; ++i) {
                out.writeLine("Channel " + i);
                for (j = 0; j < overallStatsByClass[i].length; ++j) {
                    out.writeLine("class: " + j + " " + Arrays.toString(overallStatsByClass[i][j]));
                }
            }
            out.closeFile();
        }
    }

    public static double[][] calculateStatsForInstances(Instances dataset) throws Exception {
        Instances filter = new SummaryStats().process(dataset);
        Map<Double, Instances> instancesMap = InstanceTools.createClassInstancesMap(filter);
        double[][] seriesStats = new double[instancesMap.size()][filter.numAttributes() - 1];
        for (Map.Entry<Double, Instances> pair : instancesMap.entrySet()) {
            int i;
            Instances inst = pair.getValue();
            double[][] data = InstanceTools.fromWekaInstancesArray(inst, true);
            double[] averagedStats = new double[inst.numAttributes() - 1];
            for (i = 0; i < averagedStats.length; ++i) {
                for (int j = 0; j < inst.numInstances(); ++j) {
                    int n = i;
                    averagedStats[n] = averagedStats[n] + data[j][i];
                }
            }
            i = 0;
            while (i < averagedStats.length) {
                int n = i++;
                averagedStats[n] = averagedStats[n] / (double)inst.numInstances();
            }
            seriesStats[(int)pair.getKey().doubleValue()] = averagedStats;
        }
        return seriesStats;
    }
}

