/*
 * Decompiled with CFR 0.152.
 */
package utilities.class_distributions;

import java.util.Collection;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import utilities.class_distributions.ClassDistribution;
import weka.core.Instance;
import weka.core.Instances;

public class TreeSetClassDistribution
extends ClassDistribution {
    TreeMap<Double, Integer> classDistribution = new TreeMap();

    public TreeSetClassDistribution(Instances data) {
        ListIterator it = data.listIterator();
        while (it.hasNext()) {
            double classValue = ((Instance)it.next()).classValue();
            Integer val = this.classDistribution.get(classValue);
            val = val != null ? val + 1 : 1;
            this.classDistribution.put(classValue, val);
        }
    }

    public TreeSetClassDistribution() {
    }

    public TreeSetClassDistribution(ClassDistribution in) {
        for (double val : in.keySet()) {
            this.classDistribution.put(val, in.get(val));
        }
    }

    @Override
    public int get(double classValue) {
        return this.classDistribution.getOrDefault(classValue, 0);
    }

    @Override
    public void put(double classValue, int value) {
        this.classDistribution.put(classValue, value);
    }

    @Override
    public int size() {
        return this.classDistribution.size();
    }

    @Override
    public int get(int accessValue) {
        return this.classDistribution.getOrDefault(accessValue, 0);
    }

    @Override
    public void addTo(double classVal, int value) {
        this.put(classVal, this.get(classVal) + value);
    }

    @Override
    public Set<Double> keySet() {
        return this.classDistribution.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.classDistribution.values();
    }
}

