/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import development.DataSets;
import development.MultipleClassifierEvaluation;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.function.Function;
import statistics.tests.TwoSampleTests;
import utilities.ClassifierResults;
import utilities.ClassifierResultsCollection;
import utilities.DebugPrinting;
import utilities.ErrorReport;
import utilities.StatisticalUtilities;
import vector_classifiers.ChooseDatasetFromFile;

public class MultipleClassifierResultsCollection
implements DebugPrinting {
    public String[] datasets;
    public String[] classifierNames;
    public ClassifierResultsCollection[] allResults;
    public int numFolds;
    public String baseReadPath;
    public boolean testResultsOnly;
    public boolean cleanResults;
    public boolean allowMissingResults;

    public MultipleClassifierResultsCollection(String[] classifierNames, String[] datasets, int numFolds, String baseReadPath, boolean testResultsOnly, boolean cleanResults, boolean allowMissingResults) throws Exception {
        this.classifierNames = classifierNames;
        this.datasets = datasets;
        this.numFolds = numFolds;
        this.baseReadPath = baseReadPath;
        this.testResultsOnly = testResultsOnly;
        this.cleanResults = cleanResults;
        this.allowMissingResults = allowMissingResults;
        this.allResults = new ClassifierResultsCollection[classifierNames.length];
        ErrorReport er = new ErrorReport("Results files not found:\n");
        for (int i = 0; i < classifierNames.length; ++i) {
            try {
                this.allResults[i] = new ClassifierResultsCollection(classifierNames[i], datasets, numFolds, baseReadPath, testResultsOnly, cleanResults, allowMissingResults);
                continue;
            }
            catch (Exception e) {
                er.log("Classifier Errors: " + classifierNames[i] + "\n" + e);
            }
        }
        if (allowMissingResults) {
            if (!er.isEmpty()) {
                this.printlnDebug(er.getLog());
            }
        } else {
            er.throwIfErrors();
        }
    }

    public ClassifierResults[][][][] convertToBigOlArray() {
        ClassifierResults[][][][] res = new ClassifierResults[2][this.allResults.length][][];
        for (int i = 0; i < this.classifierNames.length; ++i) {
            res[0][i] = this.allResults[i].trainResults;
            res[1][i] = this.allResults[i].testResults;
        }
        return res;
    }

    public ClassifierResults[][][] getAllResultsForDataset(String dataset) throws Exception {
        ClassifierResults[][][] res = new ClassifierResults[2][this.allResults.length][];
        int dsetIndex = Arrays.asList(this.datasets).indexOf(dataset);
        if (dsetIndex == -1) {
            throw new Exception("(getAllResultsForDataset) Results not loaded for dataset: " + dataset);
        }
        for (int i = 0; i < this.classifierNames.length; ++i) {
            res[0][i] = this.allResults[i].trainResults[dsetIndex];
            res[1][i] = this.allResults[i].testResults[dsetIndex];
        }
        return res;
    }

    public ClassifierResults[][][] getAllResultsForClassifier(String classifierName) throws Exception {
        int clsIndex = Arrays.asList(this.classifierNames).indexOf(classifierName);
        if (clsIndex == -1) {
            throw new Exception("(getAllResultsForDataset) Results not loaded for dataset: " + classifierName);
        }
        ClassifierResults[][][] res = new ClassifierResults[][][]{this.allResults[clsIndex].trainResults, this.allResults[clsIndex].testResults};
        return res;
    }

    public double[][][][] getAccuracies() {
        return this.getInfo(cr -> cr.acc);
    }

    public double[][][][] getInfo(Function<ClassifierResults, Double> getter) {
        int i;
        ClassifierResults[][][][] allRes = this.convertToBigOlArray();
        double[][][][] info = new double[2][this.classifierNames.length][this.datasets.length][this.numFolds];
        int n = i = this.testResultsOnly ? 1 : 0;
        while (i < 2) {
            for (int j = 0; j < this.classifierNames.length; ++j) {
                for (int k = 0; k < this.datasets.length; ++k) {
                    for (int l = 0; l < this.numFolds; ++l) {
                        info[i][j][k][l] = getter.apply(allRes[i][j][k][l]);
                    }
                }
            }
            ++i;
        }
        return info;
    }

    public static void main(String[] args) throws Exception {
        MultipleClassifierResultsCollection.tests3();
    }

    public static void tests3() throws Exception {
        new MultipleClassifierEvaluation("C:/JamesLPHD/TSC_Smoothing/Analysis/", "EDvsED_FilteredFirst", 30).setBuildMatlabDiagrams(false).setDatasets(DataSets.fileNames).readInClassifiers(new String[]{"ED", "ED_Filtered"}, "C:/JamesLPHD/TSC_Smoothing/Results/").runComparison();
    }

    public static void tests2() throws Exception {
        String classifier = "ED";
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] baseDatasets = DataSets.fileNames;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        for (int dset = 0; dset < numBaseDatasets; ++dset) {
            for (int fold = 0; fold < numFolds; ++fold) {
                final String baseDset = baseDatasets[dset];
                ChooseDatasetFromFile cdff = new ChooseDatasetFromFile();
                cdff.setName(classifier + "_Filtered");
                cdff.setClassifier(classifier);
                cdff.setFinalRelationName(baseDset);
                cdff.setResultsPath(baseReadPath);
                cdff.setFold(fold);
                Object[] datasets = new File(baseReadPath + classifier + "/Predictions/").list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains(baseDset);
                    }
                });
                Arrays.sort(datasets);
                if (!((String)datasets[0]).equals(baseDset)) {
                    throw new Exception("hwut" + baseDset + "\n" + Arrays.toString(datasets));
                }
                cdff.setRelationNames((String[])datasets);
                cdff.buildClassifier(null);
            }
        }
    }

    public static void tests1() throws Exception {
        double P_VAL = 0.05;
        String baseReadPath = "C:/JamesLPHD/TSC_Smoothing/Results/";
        String[] classifiers = new String[]{"ED"};
        String[] baseDatasets = DataSets.fileNames;
        int numBaseDatasets = baseDatasets.length;
        int numFolds = 30;
        boolean testResultsOnly = false;
        boolean cleanResults = true;
        boolean allowMissing = false;
        MultipleClassifierResultsCollection[] mcrcs = new MultipleClassifierResultsCollection[numBaseDatasets];
        boolean[] aFilteredVersionIsSigBetter = new boolean[numBaseDatasets];
        boolean[] aFilteredVersionIsBetter = new boolean[numBaseDatasets];
        boolean[] unFilteredVersionIsSigBetterThanAllFiltered = new boolean[numBaseDatasets];
        for (int i = 0; i < numBaseDatasets; ++i) {
            MultipleClassifierResultsCollection mcrc;
            final String datasetBase = baseDatasets[i];
            Object[] datasets = new File(baseReadPath + classifiers[0] + "/Predictions/").list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(datasetBase);
                }
            });
            Arrays.sort(datasets);
            if (!((String)datasets[0]).equals(datasetBase)) {
                throw new Exception("hwut" + datasetBase + "\n" + Arrays.toString(datasets));
            }
            mcrcs[i] = mcrc = new MultipleClassifierResultsCollection(classifiers, (String[])datasets, numFolds, baseReadPath, testResultsOnly, cleanResults, allowMissing);
            double[][] resFolds = mcrc.getAccuracies()[1][0];
            double[] resDsets = StatisticalUtilities.averageFinalDimension(resFolds);
            double unfilteredAcc = resDsets[0];
            boolean allFilteredAreSigWorse = true;
            for (int j = 1; j < resDsets.length; ++j) {
                double p = TwoSampleTests.studentT_PValue(resFolds[0], resFolds[j]);
                if (resDsets[j] > unfilteredAcc) {
                    aFilteredVersionIsBetter[i] = true;
                    if (!(p < 0.05)) continue;
                    aFilteredVersionIsSigBetter[i] = true;
                    continue;
                }
                if (!(p > 0.05)) continue;
                allFilteredAreSigWorse = false;
            }
            unFilteredVersionIsSigBetterThanAllFiltered[i] = allFilteredAreSigWorse;
        }
        System.out.println("aFilteredVersionIsSigBetter: " + MultipleClassifierResultsCollection.countNumTrue(aFilteredVersionIsSigBetter));
        System.out.println("aFilteredVersionIsBetter: " + MultipleClassifierResultsCollection.countNumTrue(aFilteredVersionIsBetter));
        System.out.println("unFilteredVersionIsSigBetterThanAllFiltered: " + MultipleClassifierResultsCollection.countNumTrue(unFilteredVersionIsSigBetterThanAllFiltered));
    }

    public static int countNumTrue(boolean[] arr) {
        int counter = 0;
        for (boolean b : arr) {
            if (!b) continue;
            ++counter;
        }
        return counter;
    }
}

