/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.FileNotFoundException;
import utilities.ClassifierResults;
import utilities.DebugPrinting;
import utilities.ErrorReport;

public class ClassifierResultsCollection
implements DebugPrinting {
    public ClassifierResults[][] trainResults = null;
    public ClassifierResults[][] testResults = null;
    public String[] datasets;
    public String classifierName;
    public int numFolds;
    public String baseReadPath;
    public boolean testResultsOnly;
    public boolean cleanResults;
    public boolean allowMissingResults;

    public ClassifierResultsCollection(String classifierName, String[] datasets, int numFolds, String baseReadPath, boolean testResultsOnly, boolean cleanResults, boolean allowMissingResults) throws Exception {
        this.classifierName = classifierName;
        this.datasets = datasets;
        this.numFolds = numFolds;
        this.baseReadPath = baseReadPath;
        this.testResultsOnly = testResultsOnly;
        this.cleanResults = cleanResults;
        this.allowMissingResults = allowMissingResults;
        this.readInAllClassifierResults();
    }

    private void readInAllClassifierResults() throws Exception {
        if (this.baseReadPath.charAt(this.baseReadPath.length() - 1) != '/') {
            this.baseReadPath = this.baseReadPath + "/";
        }
        new ClassifierResults().printlnDebug(this.classifierName + " reading");
        int totalFnfs = 0;
        ErrorReport er = new ErrorReport("FileNotFoundExceptions thrown (### total):\n");
        this.testResults = new ClassifierResults[this.datasets.length][this.numFolds];
        this.trainResults = this.testResultsOnly ? (ClassifierResults[][])null : new ClassifierResults[this.datasets.length][this.numFolds];
        for (int d = 0; d < this.datasets.length; ++d) {
            for (int f = 0; f < this.numFolds; ++f) {
                if (!this.testResultsOnly) {
                    String trainFile = this.baseReadPath + this.classifierName + "/Predictions/" + this.datasets[d] + "/trainFold" + f + ".csv";
                    try {
                        this.trainResults[d][f] = new ClassifierResults(trainFile);
                        this.trainResults[d][f].findAllStatsOnce();
                        if (this.cleanResults) {
                            this.trainResults[d][f].cleanPredictionInfo();
                        }
                    }
                    catch (FileNotFoundException ex) {
                        er.log(trainFile + "\n");
                        ++totalFnfs;
                        this.trainResults[d][f] = null;
                    }
                }
                String testFile = this.baseReadPath + this.classifierName + "/Predictions/" + this.datasets[d] + "/testFold" + f + ".csv";
                try {
                    this.testResults[d][f] = new ClassifierResults(testFile);
                    this.testResults[d][f].findAllStatsOnce();
                    if (!this.cleanResults) continue;
                    this.testResults[d][f].cleanPredictionInfo();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    er.log(testFile + "\n");
                    ++totalFnfs;
                    this.testResults[d][f] = null;
                }
            }
        }
        er.setLog(er.getLog().replace("###", totalFnfs + ""));
        if (this.allowMissingResults) {
            if (!er.isEmpty()) {
                this.printlnDebug(er.getLog());
            } else {
                er.throwIfErrors();
            }
        }
        new ClassifierResults().printlnDebug(this.classifierName + " successfully read in");
    }
}

