/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import ResultsProcessing.MatlabController;
import ResultsProcessing.ResultColumn;
import ResultsProcessing.ResultTable;
import development.MultipleClassifiersPairwiseTest;
import fileIO.OutFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import statistics.tests.OneSampleTests;
import statistics.tests.TwoSampleTests;
import utilities.ClassifierResults;
import utilities.GenericTools;
import utilities.InstanceTools;
import utilities.StatisticalUtilities;
import utilities.generic_storage.Pair;
import weka.clusterers.XMeans;
import weka.core.Instances;

public class ClassifierResultsAnalysis {
    public static String expRootDirectory;
    protected static String matlabFilePath;
    protected static String pairwiseScatterDiaPath;
    protected static String cdDiaPath;
    protected static String pairwiseCDDiaDirectoryName;
    protected static String friedmanCDDiaDirectoryName;
    public static double FRIEDMANCDDIA_PVAL;
    public static boolean buildMatlabDiagrams;
    public static boolean testResultsOnly;
    protected static final Function<ClassifierResults, Double> getAccs;
    protected static final Function<ClassifierResults, Double> getBalAccs;
    protected static final Function<ClassifierResults, Double> getAUROCs;
    protected static final Function<ClassifierResults, Double> getNLLs;
    protected static final Function<ClassifierResults, Double> getF1s;
    protected static final Function<ClassifierResults, Double> getMCCs;
    protected static final Function<ClassifierResults, Double> getPrecisions;
    protected static final Function<ClassifierResults, Double> getRecalls;
    protected static final Function<ClassifierResults, Double> getSensitivities;
    protected static final Function<ClassifierResults, Double> getSpecificities;
    private static final String testLabel = "TEST";
    private static final String trainLabel = "TRAIN";
    private static final String trainTestDiffLabel = "TRAINTESTDIFFS";
    public static final String clusterGroupingIdentifier = "PostHocXmeansClustering";

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getDefaultStatistics() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("BALACC", getBalAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("AUROC", getAUROCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("NLL", getNLLs));
        return stats;
    }

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getDefaultStatistics_AndF1MCC() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("BALACC", getBalAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("AUROC", getAUROCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("NLL", getNLLs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("F1", getF1s));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("MCC", getMCCs));
        return stats;
    }

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getAllStatistics() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("BALACC", getBalAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("AUROC", getAUROCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("NLL", getNLLs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("F1", getF1s));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("MCC", getMCCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Prec", getPrecisions));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Recall", getRecalls));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Sens", getSensitivities));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Spec", getSpecificities));
        return stats;
    }

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getAccuracyStatisticOnly() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        return stats;
    }

    protected static void writeTableFile(String filename, String tableName, double[][] accs, String[] cnames, String[] dsets) {
        OutFile out = new OutFile(filename);
        out.writeLine(tableName + ":" + ClassifierResultsAnalysis.tabulate(accs, cnames, dsets));
        out.closeFile();
    }

    protected static void writeTableFileRaw(String filename, double[][] accs, String[] cnames) {
        OutFile out = new OutFile(filename);
        out.writeLine(ClassifierResultsAnalysis.tabulateRaw(accs, cnames));
        out.closeFile();
    }

    protected static String[] writeStatisticSummaryFile(String outPath, String filename, String statName, double[][][] statPerFold, double[][] statPerDset, double[][] ranks, double[][] stddevsFoldAccs, String[] cnames, String[] dsets) {
        StringBuilder suppressedSummaryStats = new StringBuilder();
        suppressedSummaryStats.append(ClassifierResultsAnalysis.header(cnames)).append("\n");
        suppressedSummaryStats.append("Avg" + statName + ":").append(ClassifierResultsAnalysis.mean(statPerDset)).append("\n");
        suppressedSummaryStats.append("Avg" + statName + "_RANK:").append(ClassifierResultsAnalysis.mean(ranks)).append("\n");
        StringBuilder summaryStats = new StringBuilder();
        summaryStats.append(statName).append(ClassifierResultsAnalysis.header(cnames)).append("\n");
        summaryStats.append("avgOverDsets:").append(ClassifierResultsAnalysis.mean(statPerDset)).append("\n");
        summaryStats.append("stddevOverDsets:").append(ClassifierResultsAnalysis.stddev(statPerDset)).append("\n");
        summaryStats.append("avgStddevsOverFolds:").append(ClassifierResultsAnalysis.mean(stddevsFoldAccs)).append("\n");
        summaryStats.append("avgRankOverDsets:").append(ClassifierResultsAnalysis.mean(ranks)).append("\n");
        summaryStats.append("stddevsRankOverDsets:").append(ClassifierResultsAnalysis.stddev(ranks)).append("\n");
        String[] wdl = ClassifierResultsAnalysis.winsDrawsLosses(statPerDset, cnames, dsets);
        String[] sig01wdl = ClassifierResultsAnalysis.sigWinsDrawsLosses(0.01, statPerDset, statPerFold, cnames, dsets);
        String[] sig05wdl = ClassifierResultsAnalysis.sigWinsDrawsLosses(0.05, statPerDset, statPerFold, cnames, dsets);
        new File(outPath + "/WinsDrawsLosses/").mkdir();
        OutFile outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLFLAT_" + statName + ".csv");
        outwdl.writeLine(wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLSig01_" + statName + ".csv");
        outwdl.writeLine(sig01wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLSig05_" + statName + ".csv");
        outwdl.writeLine(sig05wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLFLAT_" + statName + ".csv");
        outwdl.writeLine(wdl[2]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLSig01_" + statName + ".csv");
        outwdl.writeLine(sig01wdl[2]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLSig05_" + statName + ".csv");
        outwdl.writeLine(sig05wdl[2]);
        outwdl.closeFile();
        OutFile out = new OutFile(outPath + filename + "_" + statName + "_SUMMARY.csv");
        out.writeLine(summaryStats.toString());
        out.writeLine(wdl[0]);
        out.writeLine("\n");
        out.writeLine(sig01wdl[0]);
        out.writeLine("\n");
        out.writeLine(sig05wdl[0]);
        out.writeLine("\n");
        String cliques = "";
        try {
            out.writeLine(MultipleClassifiersPairwiseTest.runTests(outPath + filename + "_" + statName + ".csv").toString());
            cliques = MultipleClassifiersPairwiseTest.printCliques();
            out.writeLine("\n\n" + cliques);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.closeFile();
        return new String[]{summaryStats.toString(), suppressedSummaryStats.toString(), cliques};
    }

    protected static String cdFileName(String filename, String statistic) {
        return "cd_" + filename + "_" + statistic + "S";
    }

    protected static String pwsFileName(String filename, String statistic) {
        return "pws_" + filename + "_" + statistic + "S";
    }

    protected static String pwsIndFileName(String c1, String c2, String statistic) {
        return "pws_" + c1 + "VS" + c2 + "_" + statistic + "S";
    }

    protected static String[] writeStatisticOnSplitFiles(String outPath, String filename, String groupingName, String evalSet, String statName, double[][][] foldVals, String[] cnames, String[] dsets, Map<String, Map<String, String[]>> dsetGroupings) throws FileNotFoundException {
        outPath = outPath + evalSet + "/";
        if (groupingName != null && !groupingName.equals("")) {
            outPath = outPath + groupingName + "/";
        }
        double[][] dsetVals = ClassifierResultsAnalysis.findAvgsOverFolds(foldVals);
        double[][] stddevsFoldVals = ClassifierResultsAnalysis.findStddevsOverFolds(foldVals);
        double[][] ranks = ClassifierResultsAnalysis.findRanks(dsetVals);
        ClassifierResultsAnalysis.writePerFoldFiles(outPath + evalSet + "FOLD" + statName + "S/", foldVals, cnames, dsets, evalSet);
        int[] ordering = ClassifierResultsAnalysis.findOrdering(ranks);
        ranks = ClassifierResultsAnalysis.order(ranks, ordering);
        cnames = ClassifierResultsAnalysis.order(cnames, ordering);
        foldVals = ClassifierResultsAnalysis.order(foldVals, ordering);
        dsetVals = ClassifierResultsAnalysis.order(dsetVals, ordering);
        stddevsFoldVals = ClassifierResultsAnalysis.order(stddevsFoldVals, ordering);
        if (evalSet.equalsIgnoreCase(testLabel)) {
            String cdFolder = expRootDirectory + cdDiaPath;
            new File(cdFolder).mkdirs();
            OutFile out = new OutFile(cdFolder + "readme.txt");
            out.writeLine("remember that nlls are auto-negated now for cd dia ordering\n");
            out.writeLine("and that basic notepad wont show the line breaks properly, view (cliques especially) in notepad++");
            out.closeFile();
            for (String subFolder : new String[]{pairwiseCDDiaDirectoryName, friedmanCDDiaDirectoryName}) {
                new File(cdFolder + subFolder + "/").mkdirs();
                String cdName = cdFolder + subFolder + "/" + ClassifierResultsAnalysis.cdFileName(filename, statName) + ".csv";
                if (statName.contains("NLL")) {
                    double[][] negatedDsetVals = new double[dsetVals.length][dsetVals[0].length];
                    for (int i = 0; i < dsetVals.length; ++i) {
                        for (int j = 0; j < dsetVals[i].length; ++j) {
                            negatedDsetVals[i][j] = dsetVals[i][j] * -1.0;
                        }
                    }
                    ClassifierResultsAnalysis.writeTableFileRaw(cdName, negatedDsetVals, cnames);
                    continue;
                }
                ClassifierResultsAnalysis.writeTableFileRaw(cdName, dsetVals, cnames);
            }
            String pwsFolder = expRootDirectory + pairwiseScatterDiaPath;
            new File(pwsFolder).mkdirs();
            String pwsName = pwsFolder + ClassifierResultsAnalysis.pwsFileName(filename, statName) + ".csv";
            ClassifierResultsAnalysis.writeTableFileRaw(pwsName, dsetVals, cnames);
        }
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + "RANKS.csv", evalSet + statName + "RANKS", ranks, cnames, dsets);
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + ".csv", evalSet + statName, dsetVals, cnames, dsets);
        ClassifierResultsAnalysis.writeTableFileRaw(outPath + filename + "_" + evalSet + statName + "RAW.csv", dsetVals, cnames);
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + "STDDEVS.csv", evalSet + statName + "STDDEVS", stddevsFoldVals, cnames, dsets);
        String[] groupingSummary = new String[]{""};
        if (dsetGroupings != null && dsetGroupings.size() != 0) {
            groupingSummary = ClassifierResultsAnalysis.writeDatasetGroupingsFiles(outPath, filename, evalSet, statName, foldVals, cnames, dsets, dsetGroupings);
        }
        String[] summaryStrings = ClassifierResultsAnalysis.writeStatisticSummaryFile(outPath, filename, evalSet + statName, foldVals, dsetVals, ranks, stddevsFoldVals, cnames, dsets);
        ClassifierResultsAnalysis.writeCliqueHelperFiles(expRootDirectory + cdDiaPath + pairwiseCDDiaDirectoryName, filename, statName, summaryStrings[2]);
        String[] summaryStrings2 = new String[summaryStrings.length + groupingSummary.length];
        for (int i = 0; i < summaryStrings.length; ++i) {
            summaryStrings2[i] = summaryStrings[i];
        }
        for (int j = 0; j < groupingSummary.length; ++j) {
            summaryStrings2[i] = groupingSummary[j];
        }
        return summaryStrings2;
    }

    public static String[] writeDatasetGroupingsFiles(String outPathBase, String filename, String evalSet, String statName, double[][][] foldVals, String[] cnames, String[] dsets, Map<String, Map<String, String[]>> dsetGroupings) throws FileNotFoundException {
        String outPath = expRootDirectory + "DatasetGroupings/";
        new File(outPath).mkdir();
        for (Map.Entry<String, Map<String, String[]>> dsetGroupingMethodEntry : dsetGroupings.entrySet()) {
            String groupingMethodName = dsetGroupingMethodEntry.getKey();
            String groupingMethodPath = outPath + groupingMethodName + "/";
            new File(groupingMethodPath + statName + "/" + evalSet + "/").mkdirs();
            Map<String, String[]> dsetGroupingMethod = dsetGroupingMethodEntry.getValue();
            if (groupingMethodName.equals(clusterGroupingIdentifier)) {
                assert (dsetGroupingMethod == null);
                dsetGroupingMethod = new HashMap<String, String[]>();
                int[] assignments = ClassifierResultsAnalysis.performDatasetResultsClustering(StatisticalUtilities.averageFinalDimension(foldVals));
                assert (assignments.length == dsets.length + 1);
                int numClusters = assignments[dsets.length];
                String[] clusterNames = new String[numClusters];
                String[][] clusterDsets = new String[numClusters][];
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    ArrayList<String> dsetAlist = new ArrayList<String>();
                    for (int dset = 0; dset < dsets.length; ++dset) {
                        if (assignments[dset] != cluster) continue;
                        dsetAlist.add(dsets[dset]);
                    }
                    clusterNames[cluster] = "Cluster " + (cluster + 1);
                    clusterDsets[cluster] = dsetAlist.toArray(new String[0]);
                    dsetGroupingMethod.put(clusterNames[cluster], clusterDsets[cluster]);
                }
                OutFile allDsetsOut = new OutFile(groupingMethodPath + statName + "/" + evalSet + "/clusters.csv");
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    allDsetsOut.writeString(clusterNames[cluster] + ",");
                }
                allDsetsOut.writeLine("");
                int dsetInd = 0;
                boolean allDone = false;
                while (!allDone) {
                    allDone = true;
                    for (int cluster = 0; cluster < numClusters; ++cluster) {
                        if (dsetInd < clusterDsets[cluster].length) {
                            allDsetsOut.writeString(clusterDsets[cluster][dsetInd]);
                            allDone = false;
                        }
                        allDsetsOut.writeString(",");
                    }
                    allDsetsOut.writeLine("");
                    ++dsetInd;
                }
                allDsetsOut.closeFile();
                String clusterGroupsPath = groupingMethodPath + statName + "/" + evalSet + "/DsetClustersTxtFiles/";
                new File(clusterGroupsPath).mkdir();
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    OutFile clusterFile = new OutFile(clusterGroupsPath + clusterNames[cluster] + ".txt");
                    for (String dset : clusterDsets[cluster]) {
                        clusterFile.writeLine(dset);
                    }
                    clusterFile.closeFile();
                }
            }
            int numGroups = dsetGroupingMethod.size();
            String[] groupNames = new String[numGroups];
            HashMap<String, double[]> groupWins = new HashMap<String, double[]>();
            HashMap<String, double[]> groupAccs = new HashMap<String, double[]>();
            for (int i = 0; i < cnames.length; ++i) {
                groupWins.put(cnames[i], new double[numGroups]);
                groupAccs.put(cnames[i], new double[numGroups]);
            }
            StringBuilder[] groupSummaryStringBuilders = new StringBuilder[numGroups];
            int groupIndex = 0;
            for (Map.Entry<String, String[]> dsetGroup : dsetGroupingMethod.entrySet()) {
                String groupName;
                groupNames[groupIndex] = groupName = dsetGroup.getKey();
                String[] groupDsets = dsetGroup.getValue();
                double[][][] groupFoldVals = ClassifierResultsAnalysis.collectDsetVals(foldVals, dsets, groupDsets);
                String groupFileName = filename + "-" + groupName + "-";
                String[] groupSummaryFileStrings = ClassifierResultsAnalysis.writeStatisticOnSplitFiles(groupingMethodPath + statName + "/", groupFileName, groupName, evalSet, statName, groupFoldVals, cnames, groupDsets, null);
                String[] classifierNamesLine = groupSummaryFileStrings[1].split("\n")[0].split(",");
                assert (classifierNamesLine.length - 1 == cnames.length);
                String[] accLineParts = groupSummaryFileStrings[1].split("\n")[1].split(",");
                for (int i = 1; i < accLineParts.length; ++i) {
                    double[] accs = (double[])groupAccs.get(classifierNamesLine[i]);
                    accs[groupIndex] = Double.parseDouble(accLineParts[i]);
                    groupAccs.put(classifierNamesLine[i], accs);
                }
                Scanner ranksFileIn = new Scanner(new File(groupingMethodPath + statName + "/" + evalSet + "/" + groupName + "/" + groupFileName + "_" + evalSet + statName + "RANKS.csv"));
                classifierNamesLine = ranksFileIn.nextLine().split(",");
                double[] winCounts = new double[classifierNamesLine.length];
                while (ranksFileIn.hasNextLine()) {
                    String[] ranksStr = ranksFileIn.nextLine().split(",");
                    double[] ranks = new double[ranksStr.length];
                    ranks[0] = Double.MAX_VALUE;
                    for (int i = 1; i < ranks.length; ++i) {
                        ranks[i] = Double.parseDouble(ranksStr[i]);
                    }
                    ArrayList<Integer> minRanks = ClassifierResultsAnalysis.min(ranks);
                    for (Integer minRank : minRanks) {
                        int n = minRank;
                        winCounts[n] = winCounts[n] + 1.0 / (double)minRanks.size();
                    }
                }
                ranksFileIn.close();
                for (int i = 1; i < winCounts.length; ++i) {
                    double[] wins = (double[])groupWins.get(classifierNamesLine[i]);
                    wins[groupIndex] = winCounts[i];
                    groupWins.put(classifierNamesLine[i], wins);
                }
                StringBuilder sb = new StringBuilder("Group: " + groupName + "\n");
                sb.append(groupSummaryFileStrings[1]);
                String cliques = groupSummaryFileStrings[2];
                cliques = cliques.replace("cliques = [", "cliques=,").replace("]", "");
                cliques = cliques.replace(" ", ",").replace("\n", "\n,");
                sb.append("\n" + cliques);
                groupSummaryStringBuilders[groupIndex] = sb;
                ++groupIndex;
            }
            String groupMethodSummaryFilename = groupingMethodPath + filename + "_" + groupingMethodName + "_" + evalSet + statName + ".csv";
            ClassifierResultsAnalysis.datasetGroupings_writeGroupingMethodSummaryFile(groupMethodSummaryFilename, groupSummaryStringBuilders, cnames, groupNames, groupWins, groupAccs);
        }
        return new String[0];
    }

    public static void datasetGroupings_writeGroupingMethodSummaryFile(String filename, StringBuilder[] groupSummaryStringBuilders, String[] cnames, String[] groupNames, Map<String, double[]> groupWins, Map<String, double[]> groupAccs) {
        OutFile groupingMethodSummaryFile = new OutFile(filename);
        for (StringBuilder groupSummary : groupSummaryStringBuilders) {
            groupingMethodSummaryFile.writeLine(groupSummary.toString());
            groupingMethodSummaryFile.writeLine("\n\n");
        }
        groupingMethodSummaryFile.writeString(ClassifierResultsAnalysis.datasetGroupings_buildAccsTableString(groupAccs, cnames, groupNames));
        groupingMethodSummaryFile.writeLine("\n\n");
        groupingMethodSummaryFile.writeString(ClassifierResultsAnalysis.datasetGroupings_buildWinsTableString(groupWins, cnames, groupNames));
        groupingMethodSummaryFile.closeFile();
    }

    public static String datasetGroupings_buildWinsTableString(Map<String, double[]> groupWins, String[] cnames, String[] groupNames) {
        int numGroups = groupNames.length;
        StringBuilder sb = new StringBuilder();
        sb.append("This table accounts for ties on a dset e.g if 2 classifiers share best accuracy that will count as half a win for each").append("\n");
        sb.append("NumWinsInGroups:");
        for (String cname : cnames) {
            sb.append("," + cname);
        }
        sb.append(",TotalNumDsetsInGroup").append("\n");
        double[] groupSums = new double[numGroups];
        double[] clsfrSums = new double[cnames.length];
        for (int i = 0; i < numGroups; ++i) {
            sb.append(groupNames[i]);
            int j = 0;
            while (j < cnames.length) {
                double val = groupWins.get(cnames[j])[i];
                int n = i;
                groupSums[n] = groupSums[n] + val;
                int n2 = j++;
                clsfrSums[n2] = clsfrSums[n2] + val;
                sb.append("," + val);
            }
            sb.append("," + groupSums[i]).append("\n");
        }
        double globalSum = 0.0;
        sb.append("TotalNumWinsForClassifier");
        for (int j = 0; j < cnames.length; ++j) {
            globalSum += clsfrSums[j];
            sb.append("," + clsfrSums[j]);
        }
        sb.append("," + globalSum).append("\n");
        return sb.toString();
    }

    public static String datasetGroupings_buildAccsTableString(Map<String, double[]> groupAccs, String[] cnames, String[] groupNames) {
        int numGroups = groupNames.length;
        StringBuilder sb = new StringBuilder();
        sb.append("AvgAccsOnGroups:");
        for (String cname : cnames) {
            sb.append("," + cname);
        }
        sb.append(",Averages").append("\n");
        double[] groupAvgs = new double[numGroups];
        double[] clsfrAvgs = new double[cnames.length];
        for (int i = 0; i < numGroups; ++i) {
            sb.append(groupNames[i]);
            int j = 0;
            while (j < cnames.length) {
                double val = groupAccs.get(cnames[j])[i];
                int n = i;
                groupAvgs[n] = groupAvgs[n] + val;
                int n2 = j++;
                clsfrAvgs[n2] = clsfrAvgs[n2] + val;
                sb.append("," + val);
            }
            sb.append("," + groupAvgs[i] / (double)cnames.length).append("\n");
        }
        double globalAvg = 0.0;
        sb.append("Averages");
        for (int j = 0; j < cnames.length; ++j) {
            double avg = clsfrAvgs[j] / (double)numGroups;
            globalAvg += avg;
            sb.append("," + avg);
        }
        sb.append("," + (globalAvg /= (double)cnames.length)).append("\n");
        return sb.toString();
    }

    public static double[][][] collectDsetVals(double[][][] foldVals, String[] dsets, String[] groupDsets) {
        double[][][] groupFoldVals = new double[foldVals.length][groupDsets.length][foldVals[0][0].length];
        for (int groupDsetInd = 0; groupDsetInd < groupDsets.length; ++groupDsetInd) {
            String dset = groupDsets[groupDsetInd];
            int globalDsetInd = Arrays.asList(dsets).indexOf(dset);
            for (int classifier = 0; classifier < foldVals.length; ++classifier) {
                for (int fold = 0; fold < foldVals[classifier][globalDsetInd].length; ++fold) {
                    groupFoldVals[classifier][groupDsetInd][fold] = foldVals[classifier][globalDsetInd][fold];
                }
            }
        }
        return groupFoldVals;
    }

    public static void summariseTestAccuracies(String outPath, String filename, double[][][] testFolds, String[] cnames, String[] dsets, Map<String, Map<String, String[]>> dsetGroupings) throws FileNotFoundException {
        ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, null, testLabel, "ACC", testFolds, cnames, dsets, dsetGroupings);
    }

    protected static String[] writeStatisticFiles(String outPath, String filename, ArrayList<ClassifierEvaluation> results, Pair<String, Function<ClassifierResults, Double>> evalStatistic, String[] cnames, String[] dsets, Map<String, Map<String, String[]>> dsetGroupings) throws FileNotFoundException {
        String statName = (String)evalStatistic.var1;
        outPath = outPath + statName + "/";
        new File(outPath).mkdirs();
        double[][][] testFolds = ClassifierResultsAnalysis.getInfo(results, (Function)evalStatistic.var2, testLabel);
        if (!testResultsOnly) {
            double[][][] trainFolds = ClassifierResultsAnalysis.getInfo(results, (Function)evalStatistic.var2, trainLabel);
            double[][][] trainTestDiffsFolds = ClassifierResultsAnalysis.findTrainTestDiffs(trainFolds, testFolds);
            ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, null, trainLabel, statName, trainFolds, cnames, dsets, dsetGroupings);
            ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, null, trainTestDiffLabel, statName, trainTestDiffsFolds, cnames, dsets, dsetGroupings);
        }
        return ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, null, testLabel, statName, testFolds, cnames, dsets, dsetGroupings);
    }

    public static void writeAllEvaluationFiles(String outPath, String expname, ArrayList<ClassifierEvaluation> results, String[] dsets) {
        ClassifierResultsAnalysis.writeAllEvaluationFiles(outPath, expname, ClassifierResultsAnalysis.getDefaultStatistics(), results, dsets, new HashMap<String, Map<String, String[]>>());
    }

    public static void writeAllEvaluationFiles(String outPath, String expname, ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics, ArrayList<ClassifierEvaluation> results, String[] dsets, Map<String, Map<String, String[]>> dsetGroupings) {
        MultipleClassifiersPairwiseTest.beQuiet = true;
        OneSampleTests.beQuiet = true;
        if (!(outPath = outPath.replace("\\", "/")).endsWith("/")) {
            outPath = outPath + "/";
        }
        outPath = outPath + expname + "/";
        new File(outPath).mkdirs();
        expRootDirectory = outPath;
        OutFile bigSummary = new OutFile(outPath + expname + "_BIGglobalSummary.csv");
        OutFile smallSummary = new OutFile(outPath + expname + "_SMALLglobalSummary.csv");
        String[] cnames = ClassifierResultsAnalysis.getNames(results);
        String[] statCliques = new String[statistics.size()];
        String[] statNames = new String[statistics.size()];
        for (int i = 0; i < statistics.size(); ++i) {
            Pair<String, Function<ClassifierResults, Double>> stat = statistics.get(i);
            String[] summary = null;
            try {
                summary = ClassifierResultsAnalysis.writeStatisticFiles(outPath, expname, results, stat, cnames, dsets, dsetGroupings);
            }
            catch (FileNotFoundException fnf) {
                System.out.println("Something went wrong, later stages of analysis could not find files that should have been madeinternally in earlier stages of the pipeline, FATAL");
                fnf.printStackTrace();
                System.exit(0);
            }
            bigSummary.writeString((String)stat.var1 + ":");
            bigSummary.writeLine(summary[0]);
            smallSummary.writeString((String)stat.var1 + ":");
            smallSummary.writeLine(summary[1]);
            statNames[i] = (String)stat.var1;
            statCliques[i] = summary[2];
        }
        bigSummary.closeFile();
        smallSummary.closeFile();
        ClassifierResultsAnalysis.buildResultsSpreadsheet(outPath, expname, statistics);
        if (buildMatlabDiagrams) {
            MatlabController proxy = MatlabController.getInstance();
            proxy.eval("addpath(genpath('" + matlabFilePath + "'))");
            ClassifierResultsAnalysis.buildCDDias(expname, statNames, statCliques);
            ClassifierResultsAnalysis.buildPairwiseScatterDiagrams(outPath, expname, statNames, dsets);
        }
    }

    protected static void writeCliqueHelperFiles(String cdCSVpath, String expname, String stat, String cliques) {
        new File(cdCSVpath).mkdirs();
        OutFile out = new OutFile(cdCSVpath + ClassifierResultsAnalysis.cdFileName(expname, stat) + "_cliques.txt");
        out.writeString(cliques);
        out.closeFile();
    }

    protected static void buildCDDias(String expname, String[] stats, String[] cliques) {
        MatlabController proxy = MatlabController.getInstance();
        proxy.eval("buildDiasInDirectory('" + expRootDirectory + "/cdDias/" + friedmanCDDiaDirectoryName + "', 0, " + FRIEDMANCDDIA_PVAL + ")");
        proxy.eval("clear");
        proxy.eval("buildDiasInDirectory('" + expRootDirectory + "/cdDias/" + pairwiseCDDiaDirectoryName + "', 1)");
        proxy.eval("clear");
    }

    protected static void writePerFoldFiles(String outPath, double[][][] folds, String[] cnames, String[] dsets, String splitLabel) {
        new File(outPath).mkdirs();
        StringBuilder headers = new StringBuilder("folds:");
        for (int f = 0; f < folds[0][0].length; ++f) {
            headers.append("," + f);
        }
        for (int c = 0; c < folds.length; ++c) {
            OutFile out = new OutFile(outPath + cnames[c] + "_" + splitLabel + "FOLDS.csv");
            out.writeLine(headers.toString());
            for (int d = 0; d < folds[c].length; ++d) {
                out.writeString(dsets[d]);
                for (int f = 0; f < folds[c][d].length; ++f) {
                    out.writeString("," + folds[c][d][f]);
                }
                out.writeLine("");
            }
            out.closeFile();
        }
        OutFile out = new OutFile(outPath + "TEXASPLOT_" + splitLabel + ".csv");
        out.writeString(cnames[0]);
        for (int c = 1; c < cnames.length; ++c) {
            out.writeString("," + cnames[c]);
        }
        out.writeLine("");
        for (int d = 0; d < dsets.length; ++d) {
            for (int f = 0; f < folds[0][0].length; ++f) {
                out.writeDouble(folds[0][d][f]);
                for (int c = 1; c < cnames.length; ++c) {
                    out.writeString("," + folds[c][d][f]);
                }
                out.writeLine("");
            }
        }
        out.closeFile();
    }

    protected static String tabulate(double[][] res, String[] cnames, String[] dsets) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassifierResultsAnalysis.header(cnames));
        for (int i = 0; i < res[0].length; ++i) {
            sb.append("\n").append(dsets[i]);
            for (int j = 0; j < res.length; ++j) {
                sb.append("," + res[j][i]);
            }
        }
        return sb.toString();
    }

    protected static String tabulateRaw(double[][] res, String[] cnames) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassifierResultsAnalysis.header(cnames).substring(1));
        for (int i = 0; i < res[0].length; ++i) {
            sb.append("\n").append(res[0][i]);
            for (int j = 1; j < res.length; ++j) {
                sb.append("," + res[j][i]);
            }
        }
        return sb.toString();
    }

    protected static String header(String[] names) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            sb.append(",").append(names[i]);
        }
        return sb.toString();
    }

    protected static String mean(double[][] res) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < res.length; ++i) {
            sb.append(",").append(StatisticalUtilities.mean(res[i], false));
        }
        return sb.toString();
    }

    protected static String stddev(double[][] res) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < res.length; ++i) {
            sb.append(",").append(StatisticalUtilities.standardDeviation(res[i], false, StatisticalUtilities.mean(res[i], false)));
        }
        return sb.toString();
    }

    protected static double[][][] findTrainTestDiffs(double[][][] trainFoldAccs, double[][][] testFoldAccs) {
        double[][][] diffs = new double[trainFoldAccs.length][trainFoldAccs[0].length][trainFoldAccs[0][0].length];
        for (int c = 0; c < diffs.length; ++c) {
            for (int d = 0; d < diffs[c].length; ++d) {
                for (int f = 0; f < diffs[c][d].length; ++f) {
                    diffs[c][d][f] = trainFoldAccs[c][d][f] - testFoldAccs[c][d][f];
                }
            }
        }
        return diffs;
    }

    protected static double[][] findAvgsOverFolds(double[][][] foldaccs) {
        double[][] accs = new double[foldaccs.length][foldaccs[0].length];
        for (int i = 0; i < accs.length; ++i) {
            for (int j = 0; j < accs[i].length; ++j) {
                accs[i][j] = StatisticalUtilities.mean(foldaccs[i][j], false);
            }
        }
        return accs;
    }

    protected static double[][] findStddevsOverFolds(double[][][] foldaccs) {
        double[][] devs = new double[foldaccs.length][foldaccs[0].length];
        for (int i = 0; i < devs.length; ++i) {
            for (int j = 0; j < devs[i].length; ++j) {
                devs[i][j] = StatisticalUtilities.standardDeviation(foldaccs[i][j], false, StatisticalUtilities.mean(foldaccs[i][j], false));
            }
        }
        return devs;
    }

    protected static int[] findOrdering(double[][] r) {
        double[] avgranks = new double[r.length];
        for (int i = 0; i < r.length; ++i) {
            avgranks[i] = StatisticalUtilities.mean(r[i], false);
        }
        double[] cpy = Arrays.copyOf(avgranks, avgranks.length);
        int[] res = new int[avgranks.length];
        int i = 0;
        while (i < res.length) {
            ArrayList<Integer> mins = ClassifierResultsAnalysis.min(avgranks);
            for (int j = 0; j < mins.size(); ++j) {
                res[mins.get((int)j).intValue()] = i++;
                avgranks[mins.get((int)j).intValue()] = Double.MAX_VALUE;
            }
        }
        return res;
    }

    protected static int[] findReverseOrdering(double[][] r) {
        double[] avgranks = new double[r.length];
        for (int i = 0; i < r.length; ++i) {
            avgranks[i] = StatisticalUtilities.mean(r[i], false);
        }
        double[] cpy = Arrays.copyOf(avgranks, avgranks.length);
        int[] res = new int[avgranks.length];
        int i = 0;
        while (i < res.length) {
            ArrayList<Integer> maxs = ClassifierResultsAnalysis.max(avgranks);
            for (int j = 0; j < maxs.size(); ++j) {
                res[maxs.get((int)j).intValue()] = i++;
                avgranks[maxs.get((int)j).intValue()] = -1.7976931348623157E308;
            }
        }
        return res;
    }

    protected static ArrayList<Integer> min(double[] d) {
        double min = d.length + 1;
        ArrayList<Integer> minIndices = null;
        for (int c = 0; c < d.length; ++c) {
            if (d[c] < min) {
                min = d[c];
                minIndices = new ArrayList<Integer>();
                minIndices.add(c);
                continue;
            }
            if (d[c] != min) continue;
            minIndices.add(c);
        }
        return minIndices;
    }

    protected static ArrayList<Integer> max(double[] d) {
        double max = -1.0;
        ArrayList<Integer> maxIndices = null;
        for (int c = 0; c < d.length; ++c) {
            if (d[c] > max) {
                max = d[c];
                maxIndices = new ArrayList<Integer>();
                maxIndices.add(c);
                continue;
            }
            if (d[c] != max) continue;
            maxIndices.add(c);
        }
        return maxIndices;
    }

    protected static String[] order(String[] s, int[] ordering) {
        String[] res = new String[s.length];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][] order(double[][] s, int[] ordering) {
        double[][] res = new double[s.length][];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][][] order(double[][][] s, int[] ordering) {
        double[][][] res = new double[s.length][][];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][] findRanks(double[][] accs) {
        double[][] ranks = new double[accs.length][accs[0].length];
        for (int d = 0; d < accs[0].length; ++d) {
            int c;
            Double[] orderedAccs = new Double[accs.length];
            for (int c2 = 0; c2 < accs.length; ++c2) {
                orderedAccs[c2] = accs[c2][d];
            }
            Arrays.sort(orderedAccs, Collections.reverseOrder());
            for (int rank = 0; rank < accs.length; ++rank) {
                for (c = 0; c < accs.length; ++c) {
                    if (orderedAccs[rank] != accs[c][d]) continue;
                    ranks[c][d] = rank;
                }
            }
            int[] hist = new int[accs.length];
            for (c = 0; c < accs.length; ++c) {
                int n = (int)ranks[c][d];
                hist[n] = hist[n] + 1;
            }
            for (int r = 0; r < hist.length; ++r) {
                if (hist[r] <= 1) continue;
                double newRank = 0.0;
                for (int i = 0; i < hist[r]; ++i) {
                    newRank += (double)(r - i);
                }
                newRank /= (double)hist[r];
                for (int c3 = 0; c3 < ranks.length; ++c3) {
                    if (ranks[c3][d] != (double)r) continue;
                    ranks[c3][d] = newRank;
                }
            }
            for (c = 0; c < accs.length; ++c) {
                double[] dArray = ranks[c];
                int n = d;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return ranks;
    }

    protected static String[] winsDrawsLosses(double[][] accs, String[] cnames, String[] dsets) {
        StringBuilder table = new StringBuilder();
        ArrayList wdlList = new ArrayList();
        ArrayList<String> wdlListNames = new ArrayList<String>();
        String[][] wdlPlusMinus = new String[cnames.length * cnames.length][dsets.length];
        table.append("flat" + ClassifierResultsAnalysis.header(cnames)).append("\n");
        int count = 0;
        for (int c1 = 0; c1 < accs.length; ++c1) {
            table.append(cnames[c1]);
            for (int c2 = 0; c2 < accs.length; ++c2) {
                wdlListNames.add(cnames[c1] + "_VS_" + cnames[c2]);
                wdlList.add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                int wins = 0;
                int draws = 0;
                int losses = 0;
                for (int d = 0; d < dsets.length; ++d) {
                    if (accs[c1][d] > accs[c2][d]) {
                        ++wins;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(0)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "1";
                        continue;
                    }
                    if (accs[c1][d] == accs[c2][d]) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    ++losses;
                    ((ArrayList)((ArrayList)wdlList.get(count)).get(2)).add(dsets[d]);
                    wdlPlusMinus[count][d] = "-1";
                }
                table.append("," + wins + "|" + draws + "|" + losses);
                ++count;
            }
            table.append("\n");
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < wdlListNames.size(); ++i) {
            list.append((String)wdlListNames.get(i));
            list.append("\n");
            list.append("Wins(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(0)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(0)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Draws(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(1)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(1)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Losses(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(2)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(2)) {
                list.append(",").append(dset);
            }
            list.append("\n\n");
        }
        StringBuilder plusMinuses = new StringBuilder();
        for (int j = 0; j < wdlPlusMinus.length; ++j) {
            plusMinuses.append(",").append((String)wdlListNames.get(j));
        }
        for (int i = 0; i < dsets.length; ++i) {
            plusMinuses.append("\n").append(dsets[i]);
            for (int j = 0; j < wdlPlusMinus.length; ++j) {
                plusMinuses.append(",").append(wdlPlusMinus[j][i]);
            }
        }
        return new String[]{table.toString(), list.toString(), plusMinuses.toString()};
    }

    protected static String[] sigWinsDrawsLosses(double pval, double[][] accs, double[][][] foldAccs, String[] cnames, String[] dsets) {
        StringBuilder table = new StringBuilder();
        ArrayList wdlList = new ArrayList();
        ArrayList<String> wdlListNames = new ArrayList<String>();
        String[][] wdlPlusMinus = new String[cnames.length * cnames.length][dsets.length];
        table.append("p=" + pval + ClassifierResultsAnalysis.header(cnames)).append("\n");
        int count = 0;
        for (int c1 = 0; c1 < foldAccs.length; ++c1) {
            table.append(cnames[c1]);
            for (int c2 = 0; c2 < foldAccs.length; ++c2) {
                wdlListNames.add(cnames[c1] + "_VS_" + cnames[c2]);
                wdlList.add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                int wins = 0;
                int draws = 0;
                int losses = 0;
                for (int d = 0; d < dsets.length; ++d) {
                    if (accs[c1][d] == accs[c2][d]) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    double p = TwoSampleTests.studentT_PValue(foldAccs[c1][d], foldAccs[c2][d]);
                    if (p > pval) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    if (accs[c1][d] > accs[c2][d]) {
                        ++wins;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(0)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "1";
                        continue;
                    }
                    ++losses;
                    ((ArrayList)((ArrayList)wdlList.get(count)).get(2)).add(dsets[d]);
                    wdlPlusMinus[count][d] = "-1";
                }
                table.append("," + wins + "|" + draws + "|" + losses);
                ++count;
            }
            table.append("\n");
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < wdlListNames.size(); ++i) {
            list.append((String)wdlListNames.get(i));
            list.append("\n");
            list.append("Wins(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(0)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(0)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Draws(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(1)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(1)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Losses(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(2)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(2)) {
                list.append(",").append(dset);
            }
            list.append("\n\n");
        }
        StringBuilder plusMinuses = new StringBuilder();
        for (int j = 0; j < wdlPlusMinus.length; ++j) {
            plusMinuses.append(",").append((String)wdlListNames.get(j));
        }
        for (int i = 0; i < dsets.length; ++i) {
            plusMinuses.append("\n").append(dsets[i]);
            for (int j = 0; j < wdlPlusMinus.length; ++j) {
                plusMinuses.append(",").append(wdlPlusMinus[j][i]);
            }
        }
        return new String[]{table.toString(), list.toString(), plusMinuses.toString()};
    }

    protected static double[][][] getInfo(ArrayList<ClassifierEvaluation> res, Function<ClassifierResults, Double> getter, String trainortest) {
        double[][][] info = new double[res.size()][res.get((int)0).testResults.length][res.get((int)0).testResults[0].length];
        for (int i = 0; i < res.size(); ++i) {
            int k;
            int j;
            if (trainortest.equalsIgnoreCase(trainLabel)) {
                for (j = 0; j < res.get((int)i).trainResults.length; ++j) {
                    for (k = 0; k < res.get((int)i).trainResults[j].length; ++k) {
                        info[i][j][k] = getter.apply(res.get((int)i).trainResults[j][k]);
                    }
                }
                continue;
            }
            if (trainortest.equalsIgnoreCase(testLabel)) {
                for (j = 0; j < res.get((int)i).testResults.length; ++j) {
                    for (k = 0; k < res.get((int)i).testResults[j].length; ++k) {
                        info[i][j][k] = getter.apply(res.get((int)i).testResults[j][k]);
                    }
                }
                continue;
            }
            System.out.println("teh fook? getInfo(), trainortest=" + trainortest);
            System.exit(0);
        }
        return info;
    }

    protected static String[] getNames(ArrayList<ClassifierEvaluation> res) {
        String[] names = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            names[i] = res.get((int)i).classifierName;
        }
        return names;
    }

    protected static void buildResultsSpreadsheet(String basePath, String expName, ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics) {
        WritableWorkbook wb = null;
        WorkbookSettings wbs = new WorkbookSettings();
        wbs.setLocale(new Locale("en", "EN"));
        try {
            wb = Workbook.createWorkbook((File)new File(basePath + expName + "ResultsSheet.xls"), (WorkbookSettings)wbs);
        }
        catch (Exception e) {
            System.out.println("ERROR CREATING RESULTS SPREADSHEET");
            System.out.println(e);
            System.exit(0);
        }
        WritableSheet summarySheet = wb.createSheet("GlobalSummary", 0);
        String summaryCSV = basePath + expName + "_SMALLglobalSummary.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(summarySheet, summaryCSV);
        for (int i = 0; i < statistics.size(); ++i) {
            String statName = (String)statistics.get((int)i).var1;
            String path = basePath + statName + "/";
            ClassifierResultsAnalysis.buildStatSheets(wb, expName, path, statName, i);
        }
        try {
            wb.write();
            wb.close();
        }
        catch (Exception e) {
            System.out.println("ERROR WRITING AND CLOSING RESULTS SPREADSHEET");
            System.out.println(e);
            System.exit(0);
        }
    }

    protected static void buildStatSheets(WritableWorkbook wb, String expName, String filenameprefix, String statName, int statIndex) {
        boolean initialSummarySheetOffset = true;
        int numSubStats = 3;
        int testOffset = 0;
        if (!testResultsOnly) {
            numSubStats = 5;
            testOffset = 2;
            WritableSheet trainSheet = wb.createSheet(statName + "Train", 1 + statIndex * numSubStats + 0);
            String trainCSV = filenameprefix + trainLabel + "/" + expName + "_" + trainLabel + statName + ".csv";
            ClassifierResultsAnalysis.copyCSVIntoSheet(trainSheet, trainCSV);
            WritableSheet trainTestDiffSheet = wb.createSheet(statName + "TrainTestDiffs", 1 + statIndex * numSubStats + 1);
            String trainTestDiffCSV = filenameprefix + trainTestDiffLabel + "/" + expName + "_" + trainTestDiffLabel + statName + ".csv";
            ClassifierResultsAnalysis.copyCSVIntoSheet(trainTestDiffSheet, trainTestDiffCSV);
        }
        WritableSheet testSheet = wb.createSheet(statName + "Test", 1 + statIndex * numSubStats + 0 + testOffset);
        String testCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + ".csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(testSheet, testCSV);
        WritableSheet rankSheet = wb.createSheet(statName + "TestRanks", 1 + statIndex * numSubStats + 1 + testOffset);
        String rankCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + "RANKS.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(rankSheet, rankCSV);
        WritableSheet summarySheet = wb.createSheet(statName + "TestSigDiffs", 1 + statIndex * numSubStats + 2 + testOffset);
        String summaryCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + "_SUMMARY.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(summarySheet, summaryCSV);
    }

    protected static void copyCSVIntoSheet(WritableSheet sheet, String csvFile) {
        try {
            Scanner fileIn = new Scanner(new File(csvFile));
            int rowInd = 0;
            while (fileIn.hasNextLine()) {
                Scanner lineIn = new Scanner(fileIn.nextLine());
                lineIn.useDelimiter(",");
                int colInd = -1;
                while (lineIn.hasNext()) {
                    ++colInd;
                    String cellContents = lineIn.next();
                    WritableFont font = new WritableFont(WritableFont.ARIAL, 10);
                    WritableCellFormat format = new WritableCellFormat(font);
                    try {
                        int iCellContents = Integer.parseInt(cellContents);
                        sheet.addCell((WritableCell)new Number(colInd, rowInd, (double)iCellContents, (CellFormat)format));
                    }
                    catch (NumberFormatException iCellContents) {
                        try {
                            double dCellContents = Double.parseDouble(cellContents);
                            sheet.addCell((WritableCell)new Number(colInd, rowInd, dCellContents, (CellFormat)format));
                        }
                        catch (NumberFormatException numberFormatException) {
                            sheet.addCell((WritableCell)new Label(colInd, rowInd, cellContents, (CellFormat)format));
                        }
                    }
                }
                ++rowInd;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR BUILDING RESULTS SPREADSHEET, COPYING CSV");
            System.out.println(e);
            System.exit(0);
        }
    }

    public static Pair<String[], double[][]> readTheFileFFS(String file, int numDsets) throws FileNotFoundException {
        ArrayList<String> cnames = new ArrayList<String>();
        Scanner in = new Scanner(new File(file));
        Scanner linein = new Scanner(in.nextLine());
        linein.useDelimiter(",");
        while (linein.hasNext()) {
            cnames.add(linein.next());
        }
        double[][] vals = new double[cnames.size()][numDsets];
        for (int d = 0; d < numDsets; ++d) {
            linein = new Scanner(in.nextLine());
            linein.useDelimiter(",");
            for (int c = 0; c < cnames.size(); ++c) {
                vals[c][d] = linein.nextDouble();
            }
        }
        return new Pair<String[], double[][]>(cnames.toArray(new String[0]), vals);
    }

    public static void buildPairwiseScatterDiagrams(String outPath, String expName, String[] statNames, String[] dsets) {
        outPath = outPath + pairwiseScatterDiaPath;
        for (String statName : statNames) {
            try {
                Pair<String[], double[][]> asd = ClassifierResultsAnalysis.readTheFileFFS(outPath + ClassifierResultsAnalysis.pwsFileName(expName, statName) + ".csv", dsets.length);
                ResultTable rt = new ResultTable(ResultTable.createColumns((String[])asd.var1, dsets, (double[][])asd.var2));
                int numClassiifers = rt.getColumns().size();
                MatlabController proxy = MatlabController.getInstance();
                for (int c1 = 0; c1 < numClassiifers - 1; ++c1) {
                    for (int c2 = c1 + 1; c2 < numClassiifers; ++c2) {
                        String c2name;
                        String c1name = rt.getColumns().get(c1).getName();
                        if (c1name.compareTo(c2name = rt.getColumns().get(c2).getName()) > 0) {
                            String t = c1name;
                            c1name = c2name;
                            c2name = t;
                        }
                        String pwFolderName = outPath + c1name + "vs" + c2name + "/";
                        new File(pwFolderName).mkdir();
                        ArrayList<ResultColumn> pwrl = new ArrayList<ResultColumn>(2);
                        pwrl.add(rt.getColumn(c1name).get());
                        pwrl.add(rt.getColumn(c2name).get());
                        ResultTable pwrt = new ResultTable(pwrl);
                        proxy.eval("array = [" + pwrt.toStringValues(false) + "];");
                        StringBuilder concat = new StringBuilder();
                        concat.append("'");
                        concat.append(c1name.replaceAll("_", "\\\\_"));
                        concat.append("',");
                        concat.append("'");
                        concat.append(c2name.replaceAll("_", "\\\\_"));
                        concat.append("'");
                        proxy.eval("labels = {" + concat.toString() + "}");
                        proxy.eval("pairedscatter('" + pwFolderName + ClassifierResultsAnalysis.pwsIndFileName(c1name, c2name, statName).replaceAll("\\.", "") + "',array(:,1),array(:,2),labels,'" + statName + "')");
                        proxy.eval("clear");
                    }
                }
            }
            catch (Exception io) {
                System.out.println("buildPairwiseScatterDiagrams(" + outPath + ") failed loading " + statName + " file\n" + io);
            }
        }
    }

    public static int[] performDatasetResultsClustering(double[][] results) {
        double[][] dsetScores = GenericTools.cloneAndTranspose(results);
        int numDsets = dsetScores.length;
        for (int dset = 0; dset < dsetScores.length; ++dset) {
            double dsetAvg = StatisticalUtilities.mean(dsetScores[dset], false);
            int clsfr = 0;
            while (clsfr < dsetScores[dset].length) {
                double[] dArray = dsetScores[dset];
                int n = clsfr++;
                dArray[n] = dArray[n] - dsetAvg;
            }
        }
        Instances clusterData = InstanceTools.toWekaInstances(dsetScores);
        XMeans xmeans = new XMeans();
        xmeans.setMaxNumClusters(Math.min((int)Math.sqrt(numDsets), 5));
        xmeans.setSeed(0);
        try {
            xmeans.buildClusterer(new Instances(clusterData));
        }
        catch (Exception e) {
            System.out.println("Problem building clusterer for post hoc dataset groupings\n" + e);
        }
        int numClusters = xmeans.numberOfClusters();
        int[] assignments = new int[numDsets + 1];
        assignments[numDsets] = numClusters;
        for (int i = 0; i < numDsets; ++i) {
            try {
                assignments[i] = xmeans.clusterInstance(clusterData.instance(i));
                continue;
            }
            catch (Exception e) {
                System.out.println("Problem assigning clusters in post hoc dataset groupings, dataset " + i + "\n" + e);
            }
        }
        return assignments;
    }

    static {
        matlabFilePath = "matlabfiles/";
        pairwiseScatterDiaPath = "PairwiseScatterDias/";
        cdDiaPath = "cddias/";
        pairwiseCDDiaDirectoryName = "pairwise/";
        friedmanCDDiaDirectoryName = "friedman/";
        FRIEDMANCDDIA_PVAL = 0.05;
        buildMatlabDiagrams = false;
        testResultsOnly = false;
        getAccs = cr -> cr.acc;
        getBalAccs = cr -> cr.balancedAcc;
        getAUROCs = cr -> cr.meanAUROC;
        getNLLs = cr -> cr.nll;
        getF1s = cr -> cr.f1;
        getMCCs = cr -> cr.mcc;
        getPrecisions = cr -> cr.precision;
        getRecalls = cr -> cr.recall;
        getSensitivities = cr -> cr.sensitivity;
        getSpecificities = cr -> cr.specificity;
    }

    public static class BVOnDset {
        public int numClasses;
        public int[] trueClassVals;
        public ArrayList<Integer>[] allPreds;

        public BVOnDset(int[] trueClassVals, int numClasses) {
            this.trueClassVals = trueClassVals;
            this.numClasses = numClasses;
            this.allPreds = new ArrayList[trueClassVals.length];
            for (int i = 0; i < this.allPreds.length; ++i) {
                this.allPreds[i] = new ArrayList();
            }
        }

        public void storePreds(int[] testInds, int[] testPreds) {
            for (int i = 0; i < testInds.length; ++i) {
                this.allPreds[testInds[i]].add(testPreds[i]);
            }
        }

        public int[][] getFinalPreds() {
            int[][] res = new int[this.allPreds.length][];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new int[this.allPreds[i].size()];
                for (int j = 0; j < this.allPreds[i].size(); ++j) {
                    res[i][j] = this.allPreds[i].get(j);
                }
            }
            return res;
        }
    }

    public static class ClassifierEvaluation {
        public String classifierName;
        public ClassifierResults[][] testResults;
        public ClassifierResults[][] trainResults;
        public BVOnDset[] bvs;

        public ClassifierEvaluation(String name, ClassifierResults[][] testResults, ClassifierResults[][] trainResults, BVOnDset[] bvs) {
            this.classifierName = name;
            this.testResults = testResults;
            this.trainResults = trainResults;
            this.bvs = bvs;
        }
    }
}

