/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.Serializable;
import java.util.Arrays;

public class BitWord
implements Comparable<BitWord>,
Serializable {
    private static final String[] alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
    private static String[] alphabetSymbols = new String[]{"a", "b", "c", "d"};
    private int word;
    private byte length;
    public static final int WORD_SPACE = 32;
    public static final int BITS_PER_LETTER = 2;
    public static final int MAX_LENGTH = 16;
    private static final int POP_MASK = 3;
    private static final int[] LETTER_MASKS = new int[]{3, 12, 48, 192, 768, 3072, 12288, 49152, 196608, 786432, 0x300000, 0xC00000, 0x3000000, 0xC000000, 0x30000000, -1073741824};

    public BitWord() {
        this.word = 0;
        this.length = (byte)32;
    }

    public BitWord(BitWord bw) {
        this.word = bw.word;
        this.length = bw.length;
    }

    public BitWord(int length) {
        this.word = 0;
    }

    public BitWord(int[] letters) throws Exception {
        this.setWord(letters);
    }

    public int getWord() {
        return this.word;
    }

    public int getLength() {
        return this.length;
    }

    public void setWord(int[] letters) {
        this.word = 0;
        this.length = (byte)letters.length;
        this.packAll(letters);
    }

    public void push(int letter) {
        this.word = this.word << 2 | letter;
        this.length = (byte)(this.length + 1);
    }

    public int pop() {
        int letter = this.word & 3;
        this.shorten(1);
        return letter;
    }

    public void packAll(int[] letters) {
        for (int i = 0; i < letters.length; ++i) {
            this.push(letters[i]);
        }
    }

    public int[] unpackAll() {
        int[] letters = new int[this.length];
        int shift = 32 - this.length * 2;
        for (int i = this.length - 1; i > -1; --i) {
            letters[this.length - 1 - i] = this.word << shift >>> 30;
            shift += 2;
        }
        return letters;
    }

    public void shortenByFourierCoefficient() {
        this.shorten(2);
    }

    public void shorten(int amount) {
        this.length = (byte)(this.length - amount);
        this.word >>>= amount * 2;
    }

    @Override
    public int compareTo(BitWord o) {
        return Integer.compare(this.word, o.word);
    }

    public boolean equals(Object other) {
        if (other instanceof BitWord) {
            return this.compareTo((BitWord)other) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.word;
        hash = 29 * hash + this.length;
        return hash;
    }

    public String buildString() {
        int[] letters = this.unpackAll();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < letters.length; ++i) {
            word.append(alphabet[letters[i]]);
        }
        return word.toString();
    }

    public String toString() {
        return Arrays.toString(this.unpackAll());
    }

    public String toString(PrintFormat format) {
        switch (format) {
            case RAW: {
                return String.valueOf(Integer.toString(this.word));
            }
            case BINARY: {
                return String.format("%32s", Integer.toBinaryString(this.word)).replace(' ', '0');
            }
            case LETTERS: {
                return Arrays.toString(this.unpackAll());
            }
            case STRING: {
                return this.buildString();
            }
        }
        return "err";
    }

    public static void main(String[] args) throws Exception {
        BitWord.quickTest();
    }

    private static void buildMasks() {
        for (int i = 0; i < 16; ++i) {
            int j;
            System.out.print("0b");
            for (j = 15; j > i; --j) {
                System.out.print("00");
            }
            System.out.print("11");
            for (j = 0; j < i; ++j) {
                System.out.print("00");
            }
            System.out.println(",");
        }
    }

    private static void quickTest() throws Exception {
        int[] letters = new int[]{0, 1, 2, 3, 2, 1, 2, 0, 1};
        BitWord w = new BitWord(letters);
        System.out.println(Arrays.toString(letters));
        System.out.println(w.toString(PrintFormat.LETTERS));
        w.shortenByFourierCoefficient();
        System.out.println(w.toString(PrintFormat.LETTERS));
        System.out.println("  ");
        int[] letters2 = new int[]{0, 1, 2, 3, 2, 1, 2, 0};
        BitWord w2 = new BitWord(letters2);
        System.out.println(Arrays.toString(letters2));
        System.out.println(w2.toString(PrintFormat.LETTERS));
        w2.shortenByFourierCoefficient();
        System.out.println(w2.toString(PrintFormat.LETTERS));
    }

    public static enum PrintFormat {
        RAW,
        BINARY,
        LETTERS,
        STRING;

    }
}

