/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import statistics.distributions.NormalDistribution;
import weka.core.Instance;
import weka.core.Instances;

public abstract class Transformations {
    boolean supervised = false;
    boolean response = false;
    public static int width = 100;

    public boolean isSupervised() {
        return this.supervised;
    }

    public boolean isResponseTransform() {
        return this.response;
    }

    public abstract Instances transform(Instances var1);

    public abstract Instances invert(Instances var1);

    public abstract Instances staticTransform(Instances var1);

    public abstract double[] invertPredictedResponse(double[] var1);

    public double[] invertPredictedQuantiles(double[] d) {
        return this.invertPredictedResponse(d);
    }

    public static void setWidth(int w) {
        width = w;
    }

    public static double[] getNormalQuantiles(double mean, double variance) {
        double[] q = new double[width];
        NormalDistribution norm = new NormalDistribution(mean, Math.sqrt(variance));
        for (int i = 0; i < width; ++i) {
            q[i] = norm.getQuantile((double)(i + 1) / (double)width);
        }
        return q;
    }

    public static double[] getNormalQuantiles(double[] standard, double mean, double variance) {
        double stDev = Math.sqrt(variance);
        double[] q = new double[standard.length];
        for (int i = 0; i < standard.length; ++i) {
            q[i] = standard[i] * stDev + mean;
        }
        return q;
    }

    public double[] findResiduals(double[] actual, double[] fitted) {
        if (actual.length != fitted.length) {
            System.out.println(" Error, mismatched lengths in findResiduals");
            System.exit(0);
        }
        double[] res = new double[actual.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = actual[i] - fitted[i];
        }
        return res;
    }

    public static Instances powerTransform(Instances data, int[] pos, double[] powers) {
        int p = data.classIndex();
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            for (int j = 0; j < pos.length; ++j) {
                if (pos[j] == p) continue;
                if (powers[j] != 0.0) {
                    inst.setValue(pos[j], Math.pow(inst.value(j), powers[j]));
                    continue;
                }
                inst.setValue(pos[j], Math.log(inst.value(j)));
            }
        }
        return data;
    }
}

