/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import java.io.FileReader;
import transformations.YeoJohnson;
import weka.core.Instances;
import weka.core.matrix.Matrix;

public class LinearModel {
    double variance;
    double standardisedError;
    double SSE;
    double SST;
    double SSR;
    double yBar;
    Matrix Xt;
    Matrix X;
    Matrix XtXinv;
    Matrix Y;
    Matrix B;
    double[] paras;
    double[] y;
    double[] H_Diagonal;
    double[] predicted;
    double[] residual;
    double[] stdResidual;
    int n;
    int m;
    public Matrix HatDiagonal;

    public LinearModel(double[][] data, double[] response) {
        this.m = data.length;
        this.n = data[0].length;
        this.y = response;
        this.Xt = new Matrix(data);
        this.X = this.Xt.transpose();
        this.Y = new Matrix(this.y, this.y.length);
    }

    public LinearModel(Instances data) {
        int i;
        this.n = data.numInstances();
        this.m = data.numAttributes();
        this.y = data.attributeToDoubleArray(data.classIndex());
        this.Y = new Matrix(this.y, this.y.length);
        double[][] xt = new double[this.m][this.n];
        for (i = 0; i < this.n; ++i) {
            xt[0][i] = 1.0;
        }
        for (i = 1; i < this.m; ++i) {
            xt[i] = data.attributeToDoubleArray(i - 1);
        }
        this.Xt = new Matrix(xt);
        this.X = this.Xt.transpose();
    }

    public double[] getY() {
        return this.y;
    }

    public double[] getPredicted() {
        return this.predicted;
    }

    public double[] getResiduals() {
        return this.stdResidual;
    }

    public double getSSR() {
        return this.SSR;
    }

    public void fitModel() {
        this.XtXinv = this.Xt.times(this.X);
        this.XtXinv = this.XtXinv.inverse();
        Matrix temp = this.XtXinv.times(this.Xt);
        this.B = temp.times(this.Y);
        this.paras = this.B.getColumnPackedCopy();
        this.H_Diagonal = new double[this.n];
        double sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            Matrix t2 = this.X.getMatrix(i, i, 0, this.m - 1);
            Matrix t3 = t2.transpose();
            t3 = this.XtXinv.times(t3);
            t3 = t2.times(t3);
            this.H_Diagonal[i] = t3.get(0, 0);
            sum += this.H_Diagonal[i];
        }
    }

    public double findInverseStats(double l, double[] untransformed) {
        this.formTrainPredictions();
        this.predicted = YeoJohnson.invert(l, this.predicted);
        this.y = untransformed;
        this.findTrainStatistics();
        return this.variance;
    }

    public double findStats() {
        this.formTrainPredictions();
        this.findTrainStatistics();
        return this.variance;
    }

    public double[] formTrainPredictions() {
        this.predicted = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.predicted[i] = this.paras[0];
            for (int j = 1; j < this.paras.length; ++j) {
                int n = i;
                this.predicted[n] = this.predicted[n] + this.paras[j] * this.X.get(i, j);
            }
        }
        return this.predicted;
    }

    public void findTrainStatistics() {
        int i;
        this.SSE = 0.0;
        this.stdResidual = new double[this.n];
        this.residual = new double[this.n];
        this.yBar = 0.0;
        for (i = 0; i < this.n; ++i) {
            this.residual[i] = this.y[i] - this.predicted[i];
            this.SSE += this.residual[i] * this.residual[i];
            this.yBar += this.y[i];
        }
        this.yBar /= (double)this.n;
        this.variance = this.SSE / (double)(this.n - this.paras.length);
        this.SST = 0.0;
        for (i = 0; i < this.n; ++i) {
            this.SST += (this.y[i] - this.yBar) * (this.y[i] - this.yBar);
        }
        this.SSR = this.SST - this.SSE;
        double s = Math.sqrt(this.variance);
        this.standardisedError = 0.0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.stdResidual[i2] = this.residual[i2] / (s * Math.sqrt(1.0 - this.H_Diagonal[i2]));
            this.standardisedError += this.stdResidual[i2] * this.stdResidual[i2];
        }
        this.standardisedError /= (double)(this.n - this.paras.length);
    }

    public double[] formTestPredictions(Instances testData) {
        int i;
        int rows = testData.numInstances();
        int cols = testData.numAttributes();
        this.predicted = new double[rows];
        if (cols != this.m) {
            System.out.println("Error: Mismatch in attribute lengths in form test Train =" + this.m + " Test =" + cols);
            System.exit(0);
        }
        double[][] xt = new double[cols][rows];
        for (i = 0; i < rows; ++i) {
            xt[0][i] = 1.0;
        }
        for (i = 1; i < cols; ++i) {
            xt[i] = testData.attributeToDoubleArray(i - 1);
        }
        Matrix testX = new Matrix(xt);
        testX = testX.transpose();
        for (int i2 = 0; i2 < rows; ++i2) {
            this.predicted[i2] = this.paras[0];
            for (int j = 1; j < this.paras.length; ++j) {
                int n = i2;
                this.predicted[n] = this.predicted[n] + this.paras[j] * testX.get(i2, j);
            }
        }
        return this.predicted;
    }

    public String toString() {
        String str = "Paras : ";
        for (int i = 0; i < this.paras.length; ++i) {
            str = str + this.paras[i] + " ";
        }
        return str;
    }

    public static void main(String[] args) {
        int i;
        Instances data = null;
        try {
            FileReader r = new FileReader("C:/Research/Code/Archive Generator/src/weka/addOns/RegressionTest2.arff");
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println("Error loading file " + e);
        }
        LinearModel lm = new LinearModel(data);
        lm.fitModel();
        lm.formTrainPredictions();
        lm.findTrainStatistics();
        OutFile f = new OutFile("C:/Research/Code/Archive Generator/src/weka/addOns/TestResults.csv");
        f.writeLine("Parameters");
        for (i = 0; i < lm.paras.length; ++i) {
            f.writeString(lm.paras[i] + ",");
        }
        f.writeLine("Variance = " + lm.variance);
        f.writeLine("\nHatDiagonal, Actual, Predicted, StdResidual");
        for (i = 0; i < lm.n; ++i) {
            f.writeLine(lm.H_Diagonal[i] + "," + lm.y[i] + "," + lm.predicted[i] + "," + lm.stdResidual[i]);
        }
    }

    public double getSSE() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

