/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import transformations.Transformations;
import weka.core.Instance;
import weka.core.Instances;

public class Exponential
extends Transformations {
    double offSet = 0.0;
    static double zeroOffset = 1.0;

    public Exponential() {
        this.supervised = true;
        this.response = true;
    }

    @Override
    public Instances transform(Instances data) {
        int i;
        int responsePos = data.numAttributes() - 1;
        System.out.println(" Response Pos = " + responsePos);
        double[] response = data.attributeToDoubleArray(responsePos);
        double min = response[0];
        for (i = 0; i < response.length; ++i) {
            if (!(response[i] < min)) continue;
            min = response[i];
        }
        this.offSet = min <= zeroOffset ? -min + zeroOffset : 0.0;
        System.out.println(" Min value = " + min + " offset = " + this.offSet);
        for (i = 0; i < data.numInstances(); ++i) {
            Instance t = data.instance(i);
            double resp = t.value(responsePos);
            System.out.print(i + " " + resp);
            resp = Math.log(resp + this.offSet);
            System.out.println(" " + resp);
            t.setValue(responsePos, resp);
        }
        return data;
    }

    @Override
    public Instances invert(Instances data) {
        int responsePos = data.numAttributes() - 1;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance t = data.instance(i);
            double resp = t.value(responsePos);
            resp = Math.exp(resp);
            t.setValue(responsePos, resp -= this.offSet);
        }
        return data;
    }

    @Override
    public double[] invertPredictedResponse(double[] d) {
        int i = 0;
        while (i < d.length) {
            d[i] = Math.exp(d[i]);
            int n = i++;
            d[n] = d[n] - this.offSet;
        }
        return d;
    }

    @Override
    public Instances staticTransform(Instances data) {
        return data;
    }
}

