/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import java.io.FileReader;
import transformations.LinearModel;
import weka.core.Instance;
import weka.core.Instances;

public class BoxTidwell {
    public static Instances transformRegressor(Instances data, int pos, int resultPos, double[] powers) {
        double[] temp = data.attributeToDoubleArray(pos);
        double[] originalData = new double[temp.length];
        double[] logData = new double[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            originalData[i] = temp[i];
            logData[i] = Math.log(temp[i]);
        }
        double[] y = data.attributeToDoubleArray(data.classIndex());
        double[][] transposeFirst = new double[data.numAttributes()][data.numInstances()];
        double[][] transposeSecond = new double[data.numAttributes() + 1][data.numInstances()];
        for (int j = 0; j < data.numInstances(); ++j) {
            transposeSecond[0][j] = 1.0;
            transposeFirst[0][j] = 1.0;
        }
        for (int i = 1; i < data.numAttributes(); ++i) {
            transposeSecond[i] = data.attributeToDoubleArray(i - 1);
            transposeFirst[i] = transposeSecond[i];
        }
        ++pos;
        int workingPos = data.numAttributes();
        double alpha = 1.0;
        double min = 0.1;
        boolean finished = false;
        int count = 0;
        int MaxIterations = 10;
        while (!finished) {
            int j;
            for (j = 0; j < originalData.length; ++j) {
                double d = Math.pow(originalData[j], alpha);
                transposeFirst[pos][j] = d;
                transposeSecond[pos][j] = d;
            }
            LinearModel l1 = new LinearModel(transposeFirst, y);
            l1.fitModel();
            double b1 = l1.paras[pos];
            for (j = 0; j < originalData.length; ++j) {
                transposeSecond[workingPos][j] = transposeFirst[pos][j] * logData[j];
            }
            LinearModel l2 = new LinearModel(transposeSecond, y);
            l2.fitModel();
            double b2 = l2.paras[workingPos];
            alpha += b2 / b1;
            if (Math.abs(b2 / b1) < min || ++count >= 10) {
                finished = true;
                continue;
            }
            if (!(Math.abs(alpha) > 10.0)) continue;
            alpha = 1.0;
            finished = true;
        }
        powers[resultPos] = alpha;
        --pos;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            inst.setValue(pos, Math.pow(originalData[i], alpha));
        }
        return data;
    }

    public static double transformRegressor(double[][] data, double[] response, int pos) {
        double[] temp = data[pos];
        double[] originalData = new double[temp.length];
        double[] transformedData = new double[temp.length];
        double[] logData = new double[originalData.length];
        for (int i = 0; i < originalData.length; ++i) {
            originalData[i] = temp[i];
            logData[i] = Math.log(originalData[i]);
        }
        double[] y = response;
        double[][] transposeFirst = new double[data.length][];
        double[][] transposeSecond = new double[data.length + 1][];
        for (int j = 0; j < data.length; ++j) {
            transposeFirst[j] = transposeSecond[j] = data[j];
        }
        transposeFirst[pos] = transformedData;
        transposeSecond[pos] = transformedData;
        transposeSecond[data.length] = logData;
        int workingPos = data.length;
        double alpha = 1.0;
        double min = 0.1;
        boolean finished = false;
        int count = 0;
        int MaxIterations = 10;
        while (!finished) {
            int j;
            for (j = 0; j < originalData.length; ++j) {
                transformedData[j] = Math.pow(originalData[j], alpha);
            }
            LinearModel l1 = new LinearModel(transposeFirst, y);
            l1.fitModel();
            double b1 = l1.paras[pos];
            for (j = 0; j < originalData.length; ++j) {
                transposeSecond[workingPos][j] = originalData[j] * logData[j];
            }
            LinearModel l2 = new LinearModel(transposeSecond, y);
            l2.fitModel();
            double b2 = l2.paras[workingPos];
            alpha += b2 / b1;
            if (Math.abs(b2 / b1) < min || ++count >= 10) {
                finished = true;
                continue;
            }
            if (!(Math.abs(alpha) > 10.0)) continue;
            alpha = 1.0;
            finished = true;
        }
        return alpha;
    }

    public static void main(String[] args) {
        Instances data = null;
        try {
            FileReader r = new FileReader("C:/Research/Code/Archive Generator/src/weka/addOns/BoxTidwellTest2.arff");
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println("Error loading file " + e);
        }
        double[] powers = new double[data.numAttributes() - 1];
        System.out.println(" Final powers =");
        for (int i = 0; i < powers.length; ++i) {
            System.out.println(i + " =" + powers[i]);
        }
        OutFile r = new OutFile("C:/Research/Code/Archive Generator/src/weka/addOns/BoxTidwellResults2.arff");
        r.writeLine(data.toString());
    }
}

