/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import weka.core.Instance;
import weka.core.Instances;

public class SkippingSearch
extends ShapeletSearch {
    int[] positions;
    int[] lengths;

    protected SkippingSearch(ShapeletSearchOptions sops) {
        super(sops);
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        this.positions = new int[input.numClasses()];
        this.lengths = new int[input.numClasses()];
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        int index = (int)timeSeries.classValue();
        int start = this.positions[index];
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        for (int length = this.lengths[index] + this.minShapeletLength; length <= this.maxShapeletLength; length += this.lengthIncrement) {
            while (start <= this.seriesLength - length - 1) {
                Shapelet shapelet = checkCandidate.process(timeSeries, start, length);
                if (shapelet != null) {
                    seriesShapelets.add(shapelet);
                }
                start += this.positionIncrement;
            }
        }
        int n = index;
        int n2 = this.positions[n] + 1;
        this.positions[n] = n2;
        this.positions[index] = n2 % this.positionIncrement;
        int n3 = index;
        int n4 = this.lengths[n3] + 1;
        this.lengths[n3] = n4;
        this.lengths[index] = n4 % this.lengthIncrement;
        return seriesShapelets;
    }
}

