/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Triple;
import weka.core.Instances;

public class SkewedRandomSearch
extends ImpRandomSearch {
    int[] lengthDistribution;
    int[] cumulativeDistribution;

    protected SkewedRandomSearch(ShapeletSearchOptions sops) {
        super(sops);
        this.lengthDistribution = sops.getLengthDistribution();
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        this.cumulativeDistribution = SkewedRandomSearch.findCumulativeCounts(this.lengthDistribution);
        int i = 0;
        while ((long)i < this.numShapelets) {
            int series = this.random.nextInt(input.numInstances());
            int length = SkewedRandomSearch.sampleCounts(this.cumulativeDistribution, this.random) + this.minShapeletLength;
            int position = this.random.nextInt(this.seriesLength - length);
            int dimension = this.random.nextInt(this.numDimensions);
            ArrayList<Triple<Integer, Integer, Integer>> shapeletList = (ArrayList<Triple<Integer, Integer, Integer>>)this.shapeletsToFind.get(series);
            if (shapeletList == null) {
                shapeletList = new ArrayList<Triple<Integer, Integer, Integer>>();
            }
            shapeletList.add(new Triple<Integer, Integer, Integer>(length, position, dimension));
            this.shapeletsToFind.put(series, shapeletList);
            ++i;
        }
    }

    public static int[] findCumulativeCounts(int[] counts) {
        int[] c = new int[counts.length];
        c[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            c[i] = c[i - 1] + counts[i];
        }
        return c;
    }

    public static int sampleCounts(int[] cumulativeCounts, Random rand) {
        int c = rand.nextInt(cumulativeCounts[cumulativeCounts.length - 1]);
        int pos = 0;
        while (cumulativeCounts[pos] <= c) {
            ++pos;
        }
        return pos;
    }

    public static void main(String[] args) {
        int[] histogram = new int[]{4, 4, 0, 1};
        int[] cum = SkewedRandomSearch.findCumulativeCounts(histogram);
        Random rand = new Random(0L);
        for (int i = 0; i < 1000; ++i) {
        }
    }
}

