/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import timeseriesweka.filters.shapelet_transforms.search_functions.FastShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.GeneticSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.LocalSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.MagnifySearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.RandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.RandomTimedSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.RefinedRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import timeseriesweka.filters.shapelet_transforms.search_functions.SkewedRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.SkippingSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.SubsampleRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.TabuSearch;

public class ShapeletSearchFactory {
    private static final List<Function<ShapeletSearchOptions, ShapeletSearch>> searchConstructors = ShapeletSearchFactory.createSearchConstructors();
    ShapeletSearchOptions options;

    public ShapeletSearchFactory(ShapeletSearchOptions ops) {
        this.options = ops;
    }

    private static List<Function<ShapeletSearchOptions, ShapeletSearch>> createSearchConstructors() {
        ArrayList<Function<ShapeletSearchOptions, ShapeletSearch>> sCons = new ArrayList<Function<ShapeletSearchOptions, ShapeletSearch>>();
        sCons.add(ShapeletSearch::new);
        sCons.add(FastShapeletSearch::new);
        sCons.add(GeneticSearch::new);
        sCons.add(RandomSearch::new);
        sCons.add(LocalSearch::new);
        sCons.add(MagnifySearch::new);
        sCons.add(RandomTimedSearch::new);
        sCons.add(SkippingSearch::new);
        sCons.add(TabuSearch::new);
        sCons.add(RefinedRandomSearch::new);
        sCons.add(ImpRandomSearch::new);
        sCons.add(SubsampleRandomSearch::new);
        sCons.add(SkewedRandomSearch::new);
        return sCons;
    }

    public ShapeletSearch getShapeletSearch() {
        return searchConstructors.get(this.options.getSearchType().ordinal()).apply(this.options);
    }

    public static void main(String[] args) {
        System.out.println(new ShapeletSearchFactory(new ShapeletSearchOptions.Builder().setSearchType(ShapeletSearch.SearchType.FULL).build()).getShapeletSearch());
    }
}

