/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import weka.core.Instance;

public class RandomSearch
extends ShapeletSearch {
    protected Random random;
    protected long numShapelets;
    protected boolean[][] visited;

    protected RandomSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.numShapelets = ops.getNumShapelets();
        this.random = new Random(ops.getSeed());
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        this.visited = new boolean[numLengths][];
        int i = 0;
        while ((long)i < this.numShapelets) {
            int lengthIndex = this.random.nextInt(numLengths);
            int length = lengthIndex + this.minShapeletLength;
            int maxPositions = this.seriesLength - length;
            int start = this.random.nextInt(maxPositions);
            this.initVisitedMemory(this.seriesLength, length);
            Shapelet shape = this.visitCandidate(timeSeries, start, length, checkCandidate);
            if (shape != null) {
                seriesShapelets.add(shape);
            }
            ++i;
        }
        for (i = 0; i < this.visited.length; ++i) {
            if (this.visited[i] == null) continue;
            for (int j = 0; j < this.visited[i].length; ++j) {
                if (!this.visited[i][j]) continue;
                this.shapeletsVisited.add(this.seriesCount + "," + (i + this.minShapeletLength) + "," + j);
            }
        }
        ++this.seriesCount;
        return seriesShapelets;
    }

    protected void initVisitedMemory(int seriesLength, int length) {
        int lengthIndex = this.getLenghtIndex(length);
        if (this.visited[lengthIndex] == null) {
            int maxPositions = seriesLength - length;
            this.visited[lengthIndex] = new boolean[maxPositions];
        }
    }

    protected int getLenghtIndex(int length) {
        return length - this.minShapeletLength;
    }

    protected Shapelet visitCandidate(Instance series, int start, int length, ShapeletSearch.ProcessCandidate checkCandidate) {
        this.initVisitedMemory(series.numAttributes(), length);
        int lengthIndex = this.getLenghtIndex(length);
        Shapelet shape = null;
        if (!this.visited[lengthIndex][start]) {
            shape = checkCandidate.process(series, start, length);
            this.visited[lengthIndex][start] = true;
        }
        return shape;
    }
}

