/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.InstanceTools;
import weka.core.Instance;
import weka.core.Instances;

public class FastShapeletSearch
extends ShapeletSearch
implements Serializable {
    int R = 10;
    int sax_max_len = 15;
    double percent_mask = 0.25;
    long seed;
    Random rand;
    boolean searched = false;
    ArrayList<Pair<Integer, Double>> Score_List;
    HashMap<Integer, USAX_elm_type> USAX_Map;

    protected FastShapeletSearch(ShapeletSearchOptions ops) {
        super(ops);
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        this.searched = false;
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        int index = InstanceTools.indexOf(this.inputData, timeSeries);
        if (!this.searched) {
            this.calculateShapelets();
            this.searched = true;
        }
        Collections.sort(this.Score_List, new ScoreComparator());
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        for (Pair<Integer, Double> Score_List1 : this.Score_List) {
            int word = (Integer)Score_List1.first;
            USAX_elm_type usax = this.USAX_Map.get(word);
            for (int kk = 0; kk < Math.min(usax.sax_id.size(), 1); ++kk) {
                int id = (Integer)usax.sax_id.get((int)kk).first;
                if (id != index) continue;
                int pos = (Integer)usax.sax_id.get((int)kk).second;
                int len = (Integer)usax.sax_id.get((int)kk).third;
                Shapelet s = checkCandidate.process(this.inputData.get(id), pos, len);
                if (s == null) continue;
                seriesShapelets.add(s);
            }
        }
        return seriesShapelets;
    }

    private void calculateShapelets() {
        for (int length = this.minShapeletLength; length <= this.maxShapeletLength; length += this.lengthIncrement) {
            this.USAX_Map = new HashMap();
            this.Score_List = new ArrayList();
            int sax_len = this.sax_max_len;
            int w = (int)Math.ceil(1.0 * (double)length / (double)sax_len);
            sax_len = (int)Math.ceil(1.0 * (double)length / (double)w);
            this.createSAXList(length, sax_len, w);
            this.randomProjection(this.R, this.percent_mask, sax_len);
            this.scoreAllSAX(this.R);
        }
    }

    void createSAXList(int subseq_len, int sax_len, int w) {
        int k;
        double[] sum_segment = new double[sax_len];
        int[] elm_segment = new int[sax_len];
        int numAttributes = this.seriesLength - 1;
        for (k = 0; k < sax_len; ++k) {
            elm_segment[k] = w;
        }
        elm_segment[sax_len - 1] = subseq_len - (sax_len - 1) * w;
        for (int series = 0; series < this.inputData.size(); ++series) {
            double d;
            int j;
            double[] timeSeries = this.inputData.get(series).toDoubleArray();
            double ex2 = 0.0;
            double ex = 0.0;
            int prev_word = -1;
            for (k = 0; k < sax_len; ++k) {
                sum_segment[k] = 0.0;
            }
            for (j = 0; j < numAttributes && j < subseq_len; ++j) {
                int slot;
                d = timeSeries[j];
                ex += d;
                ex2 += d * d;
                int n = slot = (int)Math.floor(j / w);
                sum_segment[n] = sum_segment[n] + d;
            }
            while (j <= numAttributes) {
                int j_st = j - subseq_len;
                double mean = ex / (double)subseq_len;
                double std = Math.sqrt(ex2 / (double)subseq_len - mean * mean);
                int word = this.createSAXWord(sum_segment, elm_segment, mean, std, sax_len);
                if (word != prev_word) {
                    prev_word = word;
                    USAX_elm_type ptr = this.USAX_Map.get(word);
                    if (ptr == null) {
                        ptr = new USAX_elm_type();
                    }
                    ptr.obj_set.add(series);
                    ptr.sax_id.add(new Triplet<Integer, Integer, Integer>(series, j_st, subseq_len));
                    this.USAX_Map.put(word, ptr);
                }
                if (j < numAttributes) {
                    double temp = timeSeries[j_st];
                    ex -= temp;
                    ex2 -= temp * temp;
                    for (k = 0; k < sax_len - 1; ++k) {
                        int n = k;
                        sum_segment[n] = sum_segment[n] - timeSeries[j_st + k * w];
                        int n2 = k;
                        sum_segment[n2] = sum_segment[n2] + timeSeries[j_st + (k + 1) * w];
                    }
                    int n = k;
                    sum_segment[n] = sum_segment[n] - timeSeries[j_st + k * w];
                    int n3 = k;
                    sum_segment[n3] = sum_segment[n3] + timeSeries[j_st + Math.min((k + 1) * w, subseq_len)];
                    d = timeSeries[j];
                    ex += d;
                    ex2 += d * d;
                }
                ++j;
            }
        }
    }

    int createSAXWord(double[] sum_segment, int[] elm_segment, double mean, double std, int sax_len) {
        int word = 0;
        int val = 0;
        double d = 0.0;
        for (int i = 0; i < sax_len; ++i) {
            d = (sum_segment[i] / (double)elm_segment[i] - mean) / std;
            val = d < 0.0 ? (d < -0.67 ? 0 : 1) : (d < 0.67 ? 2 : 3);
            word = word << 2 | val;
        }
        return word;
    }

    void randomProjection(int R, double percent_mask, int sax_len) {
        HashMap Hash_Mark = new HashMap();
        int num_mask = (int)Math.ceil(percent_mask * (double)sax_len);
        for (int r = 0; r < R; ++r) {
            int new_word;
            HashSet obj_set;
            int word;
            int mask_word = this.createMaskWord(num_mask, sax_len);
            for (Map.Entry<Integer, USAX_elm_type> entry : this.USAX_Map.entrySet()) {
                word = entry.getKey();
                obj_set = entry.getValue().obj_set;
                new_word = word | mask_word;
                HashSet ptr = (HashSet)Hash_Mark.get(new_word);
                if (ptr == null) {
                    Hash_Mark.put(new_word, new HashSet(obj_set));
                    continue;
                }
                ptr.addAll(obj_set);
            }
            for (Map.Entry<Integer, USAX_elm_type> entry : this.USAX_Map.entrySet()) {
                word = entry.getKey();
                new_word = word | mask_word;
                obj_set = (HashSet)Hash_Mark.get(new_word);
                for (Integer o_it : obj_set) {
                    Integer count = entry.getValue().obj_count.get(o_it);
                    count = count == null ? 1 : count + 1;
                    entry.getValue().obj_count.put(o_it, count);
                }
            }
            Hash_Mark.clear();
        }
    }

    int createMaskWord(int num_mask, int word_len) {
        int a = 0;
        for (int i = 0; i < num_mask; ++i) {
            int b = 1 << word_len / 2;
            a |= b;
        }
        return a;
    }

    void scoreAllSAX(int R) {
        for (Map.Entry<Integer, USAX_elm_type> entry : this.USAX_Map.entrySet()) {
            int word = entry.getKey();
            USAX_elm_type usax = entry.getValue();
            double score = this.calcScore(usax, R);
            this.Score_List.add(new Pair<Integer, Double>(word, score));
        }
    }

    double calcScore(USAX_elm_type usax, int R) {
        double score = -1.0;
        double[] c_in = new double[this.inputData.numClasses()];
        double[] c_out = new double[this.inputData.numClasses()];
        for (Map.Entry<Integer, Integer> entry : usax.obj_count.entrySet()) {
            int cid = (int)this.inputData.get(entry.getKey()).classValue();
            int count = entry.getValue();
            int n = cid;
            c_in[n] = c_in[n] + (double)count;
            int n2 = cid;
            c_out[n2] = c_out[n2] + (double)(R - count);
        }
        score = this.calcScoreFromObjCount(c_in, c_out);
        return score;
    }

    double calcScoreFromObjCount(double[] c_in, double[] c_out) {
        double sum = 0.0;
        double max_val = Double.NEGATIVE_INFINITY;
        double min_val = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.inputData.numClasses(); ++i) {
            double diff = c_in[i] - c_out[i];
            if (diff > max_val) {
                max_val = diff;
            }
            if (diff < min_val) {
                min_val = diff;
            }
            sum += Math.abs(diff);
        }
        return sum - Math.abs(max_val) - Math.abs(min_val) + Math.abs(max_val - min_val);
    }

    private class Triplet<A, B, C>
    implements Serializable {
        public A first;
        public B second;
        public C third;

        Triplet() {
        }

        Triplet(A l, B r, C g) {
            this.first = l;
            this.second = r;
            this.third = g;
        }
    }

    private class Pair<A, B>
    implements Serializable {
        public A first;
        public B second;

        Pair() {
        }

        Pair(A l, B r) {
            this.first = l;
            this.second = r;
        }
    }

    private class USAX_elm_type
    implements Serializable {
        HashSet<Integer> obj_set = new HashSet();
        ArrayList<Triplet<Integer, Integer, Integer>> sax_id = new ArrayList();
        HashMap<Integer, Integer> obj_count = new HashMap();
    }

    private class ScoreComparator
    implements Comparator<Pair<Integer, Double>>,
    Serializable {
        private ScoreComparator() {
        }

        @Override
        public int compare(Pair<Integer, Double> t, Pair<Integer, Double> t1) {
            return Double.compare((Double)t1.second, (Double)t.second);
        }
    }
}

