/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.TreeSetClassDistribution;

public class InformationGain
implements ShapeletQualityMeasure,
Serializable {
    protected InformationGain() {
    }

    @Override
    public double calculateQuality(List<OrderLineObj> orderline, ClassDistribution classDistribution) {
        Collections.sort(orderline);
        double lastDist = -1.0;
        double thisDist = -1.0;
        double bsfGain = -1.0;
        TreeSetClassDistribution lessClasses = new TreeSetClassDistribution();
        TreeSetClassDistribution greaterClasses = new TreeSetClassDistribution();
        double parentEntropy = InformationGain.entropy(classDistribution);
        int sumOfAllClasses = 0;
        for (double j : classDistribution.keySet()) {
            ((ClassDistribution)lessClasses).put(j, 0);
            ((ClassDistribution)greaterClasses).put(j, classDistribution.get(j));
            sumOfAllClasses += classDistribution.get(j);
        }
        int sumOfLessClasses = 0;
        int sumOfGreaterClasses = sumOfAllClasses;
        for (OrderLineObj ol : orderline) {
            double entropyGreater;
            double greaterFrac;
            double entropyLess;
            double lessFrac;
            double gain;
            thisDist = ol.getDistance();
            double thisClassVal = ol.getClassVal();
            int oldCount = ((ClassDistribution)lessClasses).get(thisClassVal) + 1;
            ((ClassDistribution)lessClasses).put(thisClassVal, oldCount);
            oldCount = ((ClassDistribution)greaterClasses).get(thisClassVal) - 1;
            ((ClassDistribution)greaterClasses).put(thisClassVal, oldCount);
            ++sumOfLessClasses;
            --sumOfGreaterClasses;
            if (thisDist != lastDist && (gain = parentEntropy - (lessFrac = (double)sumOfLessClasses / (double)sumOfAllClasses) * (entropyLess = InformationGain.entropy(lessClasses)) - (greaterFrac = (double)sumOfGreaterClasses / (double)sumOfAllClasses) * (entropyGreater = InformationGain.entropy(greaterClasses))) > bsfGain) {
                bsfGain = gain;
            }
            lastDist = thisDist;
        }
        return bsfGain;
    }

    public static double entropy(ClassDistribution classDistributions) {
        if (classDistributions.size() == 1) {
            return 0.0;
        }
        int total = 0;
        Collection<Integer> values = classDistributions.values();
        for (Integer d : values) {
            total += d.intValue();
        }
        double entropy = 0.0;
        for (Integer d : values) {
            double thisPart = (double)d.intValue() / (double)total;
            double toAdd = -thisPart * Math.log10(thisPart) / Math.log10(2.0);
            if (Double.isNaN(toAdd)) continue;
            entropy += toAdd;
        }
        return entropy;
    }

    @Override
    public double calculateSeperationGap(List<OrderLineObj> orderline) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

