/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import java.io.Serializable;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletCandidate;
import weka.core.Instance;
import weka.core.Instances;

public class SubSeqDistance
implements Serializable {
    public static final double ROUNDING_ERROR_CORRECTION = 1.0E-15;
    protected Instance candidateInst;
    protected double[] candidateArray;
    protected Shapelet shapelet;
    protected ShapeletCandidate cand;
    protected int seriesId;
    protected int startPos;
    protected int length;
    protected int dimension;
    protected long count;

    public void init(Instances data) {
        this.count = 0L;
    }

    protected void incrementCount() {
        ++this.count;
    }

    public long getCount() {
        return this.count;
    }

    public ShapeletCandidate getCandidate() {
        return this.cand;
    }

    public void setShapelet(Shapelet shp) {
        this.shapelet = shp;
        this.startPos = shp.startPos;
        this.cand = shp.getContent();
        this.length = shp.getLength();
        this.dimension = shp.getDimension();
    }

    public void setCandidate(Instance inst, int start, int len, int dim) {
        this.cand = new ShapeletCandidate();
        this.startPos = start;
        this.length = len;
        this.dimension = dim;
        if (this.candidateInst == null || this.candidateInst != inst) {
            this.candidateArray = inst.toDoubleArray();
            this.candidateInst = inst;
        }
        double[] temp = new double[this.length];
        System.arraycopy(this.candidateArray, start, temp, 0, this.length);
        this.cand.setShapeletContent(temp);
        this.cand.setShapeletContent(this.zNormalise(this.cand.getShapeletContent(), false));
    }

    public void setSeries(int srsId) {
        this.seriesId = srsId;
    }

    public double calculate(Instance timeSeries, int timeSeriesId) {
        return this.calculate(timeSeries.toDoubleArray(), timeSeriesId);
    }

    public double calculate(double[] timeSeries, int timeSeriesId) {
        double bestSum = Double.MAX_VALUE;
        for (int i = 0; i < timeSeries.length - this.length; ++i) {
            double sum = 0.0;
            double[] subseq = new double[this.length];
            System.arraycopy(timeSeries, i, subseq, 0, this.length);
            subseq = this.zNormalise(subseq, false);
            for (int j = 0; j < this.length; ++j) {
                this.incrementCount();
                double temp = this.cand.getShapeletContent()[j] - subseq[j];
                sum += temp * temp;
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        double dist = bestSum == 0.0 ? 0.0 : 1.0 / (double)this.length * bestSum;
        return dist;
    }

    public double[] zNormalise(double[] input, boolean classValOn) {
        int i;
        int classValPenalty = classValOn ? 1 : 0;
        int inputLength = input.length - classValPenalty;
        double[] output = new double[input.length];
        double seriesTotal = 0.0;
        for (int i2 = 0; i2 < inputLength; ++i2) {
            seriesTotal += input[i2];
        }
        double mean = seriesTotal / (double)inputLength;
        double stdv = 0.0;
        for (i = 0; i < inputLength; ++i) {
            double temp = input[i] - mean;
            stdv += temp * temp;
        }
        stdv = (stdv /= (double)inputLength) < 1.0E-15 ? 0.0 : Math.sqrt(stdv);
        for (i = 0; i < inputLength; ++i) {
            output[i] = stdv == 0.0 ? 0.0 : (input[i] - mean) / stdv;
        }
        if (classValOn) {
            output[output.length - 1] = input[input.length - 1];
        }
        return output;
    }

    public static enum DistanceType {
        NORMAL,
        ONLINE,
        IMP_ONLINE,
        CACHED,
        ONLINE_CACHED,
        DEPENDENT,
        INDEPENDENT,
        DIMENSION;

    }
}

