/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import java.io.Serializable;
import timeseriesweka.filters.shapelet_transforms.ShapeletCandidate;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import utilities.multivariate_tools.MultivariateInstanceTools;
import weka.core.Instance;
import weka.core.Instances;

public class MultivariateDistance
extends SubSeqDistance
implements Serializable {
    protected int numChannels;
    protected int seriesLength;
    protected double[][] candidateArray2;

    @Override
    public void init(Instances data) {
        this.count = 0L;
        this.numChannels = MultivariateInstanceTools.numChannels(data);
        this.seriesLength = MultivariateInstanceTools.channelLength(data);
    }

    @Override
    public void setCandidate(Instance inst, int start, int len, int dim) {
        this.cand = new ShapeletCandidate(this.numChannels);
        this.startPos = start;
        this.length = len;
        if (this.candidateInst == null || this.candidateInst != inst) {
            this.candidateArray2 = MultivariateInstanceTools.convertMultiInstanceToArrays(MultivariateInstanceTools.splitMultivariateInstance(inst));
            this.candidateInst = inst;
        }
        for (int i = 0; i < this.numChannels; ++i) {
            double[] temp = new double[this.length];
            System.arraycopy(this.candidateArray2[i], start, temp, 0, this.length);
            temp = this.zNormalise(temp, false);
            this.cand.setShapeletContent(i, temp);
        }
    }
}

