/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.class_value;

import timeseriesweka.filters.shapelet_transforms.class_value.NormalClassValue;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.TreeSetClassDistribution;
import weka.core.Instance;
import weka.core.Instances;

public class BinaryClassValue
extends NormalClassValue {
    ClassDistribution[] binaryClassDistribution;

    @Override
    public void init(Instances inst) {
        super.init(inst);
        this.binaryClassDistribution = this.createBinaryDistributions();
    }

    @Override
    public ClassDistribution getClassDistributions() {
        return this.binaryClassDistribution[(int)this.shapeletValue];
    }

    @Override
    public double getClassValue(Instance in) {
        return in.classValue() == this.shapeletValue ? 0.0 : 1.0;
    }

    private ClassDistribution[] createBinaryDistributions() {
        ClassDistribution[] binaryMapping = new ClassDistribution[this.classDistributions.size()];
        int i = 0;
        for (double key : this.classDistributions.keySet()) {
            binaryMapping[i++] = this.binariseDistributions(key);
        }
        return binaryMapping;
    }

    private ClassDistribution binariseDistributions(double shapeletClassVal) {
        TreeSetClassDistribution binaryDistribution = new TreeSetClassDistribution();
        Integer shapeletClassCount = this.classDistributions.get(shapeletClassVal);
        ((ClassDistribution)binaryDistribution).put(0.0, shapeletClassCount);
        int sum = 0;
        for (double i : this.classDistributions.keySet()) {
            sum += this.classDistributions.get(i);
        }
        ((ClassDistribution)binaryDistribution).put(1.0, sum -= shapeletClassCount.intValue());
        return binaryDistribution;
    }
}

