/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import timeseriesweka.filters.shapelet_transforms.BalancedClassShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.class_value.BinaryClassValue;
import timeseriesweka.filters.shapelet_transforms.class_value.NormalClassValue;
import timeseriesweka.filters.shapelet_transforms.distance_functions.CachedSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.OnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchFactory;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.InstanceTools;
import utilities.StatisticalUtilities;
import utilities.generic_storage.Pair;
import weka.core.Instances;

public class ShapeletTransformTimingUtilities {
    public static final long opCountThreshold = 1000000000000000L;
    public static final long dayNano = 86400000000000L;
    public static final long nanoToOp = 10L;
    public static final Map<String, Pair<Integer, Integer>> shapeletParams = new HashMap<String, Pair<Integer, Integer>>();
    public static final double MEM_CUTOFF = 0.5;
    public static final int MAX_NOS_SHAPELETS = 1000;

    public static ShapeletTransform createCachedTransform() {
        ShapeletTransform st = new ShapeletTransform();
        st.setSubSeqDistance(new CachedSubSeqDistance());
        return st;
    }

    public static ShapeletTransform createOnlineTransform() {
        ShapeletTransform st = new ShapeletTransform();
        st.setSubSeqDistance(new OnlineSubSeqDistance());
        return st;
    }

    public static ShapeletTransform createBasicTransform(int n, int m) {
        ShapeletTransform fst = new ShapeletTransform();
        fst.setNumberOfShapelets(n);
        fst.setShapeletMinAndMax(3, m);
        fst.supressOutput();
        return fst;
    }

    public static ShapeletTransform createTransform(Instances train) {
        ShapeletTransform transform;
        int numClasses = train.numClasses();
        int numInstances = train.numInstances() <= 2000 ? train.numInstances() : 2000;
        int numAttributes = train.numAttributes() - 1;
        if (numClasses == 2) {
            transform = new ShapeletTransform();
            System.out.println("2 class");
        } else {
            transform = new BalancedClassShapeletTransform();
            transform.setClassValue(new BinaryClassValue());
        }
        transform.setShapeletMinAndMax(3, numAttributes);
        transform.setNumberOfShapelets(numInstances);
        transform.useCandidatePruning();
        transform.turnOffLog();
        transform.setRoundRobin(true);
        transform.supressOutput();
        return transform;
    }

    long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long availableMemory = maxMemory - usedMemory;
        return availableMemory;
    }

    public static int[] estimateMinAndMax(Instances data, ShapeletTransform st) {
        ShapeletTransform st1 = null;
        try {
            st1 = (ShapeletTransform)st.getClass().newInstance();
            st1.setClassValue((NormalClassValue)st.classValue.getClass().newInstance());
            st1.setSubSeqDistance((SubSeqDistance)st.subseqDistance.getClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            System.out.println("Exception: ");
        }
        if (st1 == null) {
            st1 = new ShapeletTransform();
        }
        st1.supressOutput();
        ArrayList<Shapelet> shapelets = new ArrayList<Shapelet>();
        st.supressOutput();
        st.turnOffLog();
        Instances randData = new Instances(data);
        for (int i = 0; i < 10; ++i) {
            randData.randomize(new Random());
            Instances randSubset = new Instances(randData, 0, 10);
            shapelets.addAll(st1.findBestKShapeletsCache(10, randSubset, 3, randSubset.numAttributes() - 1));
        }
        Collections.sort(shapelets, new ShapeletLengthComparator());
        int min = ((Shapelet)shapelets.get(24)).getLength();
        int max = ((Shapelet)shapelets.get(74)).getLength();
        return new int[]{min, max};
    }

    public static int[] estimateMinAndMax(Instances data) {
        return ShapeletTransformTimingUtilities.estimateMinAndMax(data, new ShapeletTransform());
    }

    public static long calculateNumberOfShapelets(Instances train, int minShapeletLength, int maxShapeletLength) {
        return ShapeletTransformTimingUtilities.calculateNumberOfShapelets(train.numInstances(), train.numAttributes() - 1, minShapeletLength, maxShapeletLength);
    }

    public static long calculateNumberOfShapelets(int numInstances, int numAttributes, int minShapeletLength, int maxShapeletLength) {
        long numShapelets = 0L;
        for (int length = minShapeletLength; length <= maxShapeletLength; ++length) {
            numShapelets += (long)(numAttributes - length + 1);
        }
        return numShapelets *= (long)numInstances;
    }

    public static long calculateShapeletsFromOpCount(int numInstances, int numAttributes, long opCount) {
        return (long)(6.0 * (double)opCount / (double)(numAttributes * (numAttributes * numAttributes + 3 * numAttributes + 2) * (numInstances - 1)));
    }

    public static long calculateOperations(Instances train, int minShapeletLength, int maxShapeletLength) {
        return ShapeletTransformTimingUtilities.calculateOperations(train.numInstances(), train.numAttributes() - 1, minShapeletLength, maxShapeletLength);
    }

    public static long calculateOperations(int numInstances, int numAttributes, int minShapeletLength, int maxShapeletLength) {
        return ShapeletTransformTimingUtilities.calculateOperationsWithSkipping(numInstances, numAttributes, minShapeletLength, maxShapeletLength, 1, 1, 1.0f);
    }

    public static long calculateOperationsWithProportion(Instances train, int minShapeletLength, int maxShapeletLength, float proportion) {
        return ShapeletTransformTimingUtilities.calculateOperationsWithSkipping(train.numInstances(), train.numAttributes() - 1, minShapeletLength, maxShapeletLength, 1, 1, proportion);
    }

    public static long calculateOperationsWithSkipping(int numInstances, int numAttributes, int minShapeletLength, int maxShapeletLength, int posSkip, int lengthSkip, float Shapeletproportion) {
        long numOps = 0L;
        int shapelets = 0;
        for (int length = minShapeletLength; length <= maxShapeletLength; length += lengthSkip) {
            long shapeletsLength = (long)((float)((numAttributes - length + 1) / posSkip) * Shapeletproportion);
            shapelets = (int)((long)shapelets + shapeletsLength);
            long shapeletsCompared = numAttributes - length + 1;
            long comparisonPerSeries = shapeletsLength * shapeletsCompared * (long)length * (long)(numInstances - 1);
            numOps += comparisonPerSeries;
        }
        return numOps *= (long)numInstances;
    }

    public static double calc(int n, int m, int min, int max, int pos, int len) {
        double numOps = 0.0;
        for (int length = 0; length <= (max - min) / len; ++length) {
            int currentLength = len * length + min;
            double shapeletsLength = Math.ceil((double)(m - currentLength + 1) / (double)pos);
            double shapeletsCompared = m - currentLength + 1;
            numOps += shapeletsLength * shapeletsCompared * (double)currentLength;
        }
        return numOps *= (double)(n * (n - 1));
    }

    public static long calcShapelets(int n, int m, int min, int max, int pos, int len) {
        long numOps = 0L;
        for (int length = 0; length <= (max - min) / len; ++length) {
            int currentLength = len * length + min;
            long shapeletsLength = (long)Math.ceil((double)(m - currentLength + 1) / (double)pos);
            numOps += shapeletsLength;
        }
        return numOps *= (long)n;
    }

    public static BigInteger calculateOps(int n, int m, int posS, int lenS) {
        BigInteger nSqd = new BigInteger(Long.toString(n));
        nSqd = nSqd.pow(2);
        long lenSqd = lenS * lenS;
        BigInteger mSqd = new BigInteger(Long.toString(m));
        BigInteger temp1 = mSqd = mSqd.pow(2);
        temp1 = mSqd.multiply(new BigInteger(Long.toString(m)));
        BigInteger temp2 = mSqd.multiply(new BigInteger("7"));
        BigInteger temp3 = new BigInteger(Long.toString((long)m * (lenSqd - (long)(18 * lenS) + 27L)));
        BigInteger temp4 = new BigInteger(Long.toString(lenS * (5 * lenS - 24) + 27));
        BigInteger bg = new BigInteger("0");
        bg = bg.add(temp1);
        bg = bg.add(temp2);
        bg = bg.subtract(temp3);
        bg = bg.add(temp4);
        bg = bg.multiply(nSqd.subtract(new BigInteger(Long.toString(n))));
        bg = bg.multiply(new BigInteger(Long.toString(m - 3)));
        bg = bg.divide(new BigInteger(Long.toString(12 * posS * lenS)));
        return bg;
    }

    public static double calculateN(int n, int m, long time) {
        long opCount = time / 10L;
        BigDecimal numerator = new BigDecimal(Long.toString(12L * opCount));
        BigInteger temp1 = new BigInteger(Long.toString(m * m));
        temp1 = temp1.multiply(new BigInteger(Long.toString(m)));
        BigInteger temp2 = new BigInteger(Long.toString(7 * m * m));
        BigInteger temp3 = new BigInteger(Long.toString(10 * m));
        BigInteger temp4 = new BigInteger(Long.toString(8L));
        temp1 = temp1.add(temp2);
        temp1 = temp1.subtract(temp3);
        temp1 = temp1.add(temp4);
        temp1 = temp1.multiply(new BigInteger(Long.toString(m - 3)));
        BigDecimal denominator = new BigDecimal(temp1);
        BigDecimal result = StatisticalUtilities.sqrt(numerator.divide(denominator, MathContext.DECIMAL32), MathContext.DECIMAL32);
        result = result.divide(new BigDecimal(n), MathContext.DECIMAL32);
        return Math.min(result.doubleValue(), 1.0);
    }

    public static ShapeletTransform createTransformWithTimeLimit(Instances train, double hours) {
        return ShapeletTransformTimingUtilities.createTransformWithTimeLimit(train, hours, 0);
    }

    public static ShapeletTransform createTransformWithTimeLimit(Instances train, double hours, int seed) {
        int minimumRepresentation = 25;
        long nanoPerHour = 3600000000000L;
        long time = (long)((double)nanoPerHour * hours);
        int n = train.numInstances();
        int m = train.numAttributes() - 1;
        ShapeletTransform transform = ShapeletTransformTimingUtilities.createTransform(train);
        transform.supressOutput();
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            double recommendedProportion = ShapeletTransformTimingUtilities.calculateN(n, m, time);
            int small_sf = InstanceTools.findSmallestClassAmount(train);
            double proportion = 1.0;
            if (small_sf > minimumRepresentation) {
                proportion = (double)minimumRepresentation / (double)small_sf;
            }
            if (recommendedProportion < proportion) {
                recommendedProportion = proportion;
            }
            Instances subsample = InstanceTools.subSampleFixedProportion(train, recommendedProportion, seed);
            int i = 1;
            while (ShapeletTransformTimingUtilities.calculateOps(subsample.numInstances(), m, i, i).compareTo(opCountTarget) == 1) {
                ++i;
            }
            double percentageOfSeries = (double)i / (double)m * 100.0;
            transform.setNumberOfShapelets(subsample.numInstances());
            ShapeletSearchOptions sOptions = new ShapeletSearchOptions.Builder().setMin(3).setMax(m).setLengthInc(i).setPosInc(i).build();
            transform.setSearchFunction(new ShapeletSearchFactory(sOptions).getShapeletSearch());
            transform.process(subsample);
        }
        return transform;
    }

    public static void main(String[] args) throws IOException {
    }

    static {
        shapeletParams.put("Adiac", new Pair<Integer, Integer>(3, 10));
        shapeletParams.put("ArrowHead", new Pair<Integer, Integer>(17, 90));
        shapeletParams.put("Beef", new Pair<Integer, Integer>(8, 30));
        shapeletParams.put("BeetleFly", new Pair<Integer, Integer>(30, 101));
        shapeletParams.put("BirdChicken", new Pair<Integer, Integer>(30, 101));
        shapeletParams.put("Car", new Pair<Integer, Integer>(16, 57));
        shapeletParams.put("CBF", new Pair<Integer, Integer>(46, 90));
        shapeletParams.put("ChlorineConcentration", new Pair<Integer, Integer>(7, 20));
        shapeletParams.put("CinCECGtorso", new Pair<Integer, Integer>(697, 814));
        shapeletParams.put("Coffee", new Pair<Integer, Integer>(18, 30));
        shapeletParams.put("Computers", new Pair<Integer, Integer>(15, 267));
        shapeletParams.put("CricketX", new Pair<Integer, Integer>(120, 255));
        shapeletParams.put("CricketY", new Pair<Integer, Integer>(132, 262));
        shapeletParams.put("CricketZ", new Pair<Integer, Integer>(118, 257));
        shapeletParams.put("DiatomSizeReduction", new Pair<Integer, Integer>(7, 16));
        shapeletParams.put("DistalPhalanxOutlineAgeGroup", new Pair<Integer, Integer>(7, 31));
        shapeletParams.put("DistalPhalanxOutlineCorrect", new Pair<Integer, Integer>(6, 16));
        shapeletParams.put("DistalPhalanxTW", new Pair<Integer, Integer>(17, 31));
        shapeletParams.put("Earthquakes", new Pair<Integer, Integer>(24, 112));
        shapeletParams.put("ECGFiveDays", new Pair<Integer, Integer>(24, 76));
        shapeletParams.put("FaceAll", new Pair<Integer, Integer>(70, 128));
        shapeletParams.put("FaceFour", new Pair<Integer, Integer>(20, 120));
        shapeletParams.put("FacesUCR", new Pair<Integer, Integer>(47, 128));
        shapeletParams.put("Fiftywords", new Pair<Integer, Integer>(170, 247));
        shapeletParams.put("Fish", new Pair<Integer, Integer>(22, 60));
        shapeletParams.put("FordA", new Pair<Integer, Integer>(50, 298));
        shapeletParams.put("FordB", new Pair<Integer, Integer>(38, 212));
        shapeletParams.put("GunPoint", new Pair<Integer, Integer>(24, 55));
        shapeletParams.put("Haptics", new Pair<Integer, Integer>(21, 103));
        shapeletParams.put("Herrings", new Pair<Integer, Integer>(30, 101));
        shapeletParams.put("InlineSkate", new Pair<Integer, Integer>(750, 896));
        shapeletParams.put("ItalyPowerDemand", new Pair<Integer, Integer>(7, 14));
        shapeletParams.put("LargeKitchenAppliances", new Pair<Integer, Integer>(13, 374));
        shapeletParams.put("Lightning2", new Pair<Integer, Integer>(47, 160));
        shapeletParams.put("Lightning7", new Pair<Integer, Integer>(20, 80));
        shapeletParams.put("Mallat", new Pair<Integer, Integer>(52, 154));
        shapeletParams.put("MedicalImages", new Pair<Integer, Integer>(9, 35));
        shapeletParams.put("MiddlePhalanxOutlineAgeGroup", new Pair<Integer, Integer>(8, 31));
        shapeletParams.put("MiddlePhalanxOutlineCorrect", new Pair<Integer, Integer>(5, 12));
        shapeletParams.put("MiddlePhalanxTW", new Pair<Integer, Integer>(7, 31));
        shapeletParams.put("MoteStrain", new Pair<Integer, Integer>(16, 31));
        shapeletParams.put("NonInvasiveFatalECGThorax1", new Pair<Integer, Integer>(5, 61));
        shapeletParams.put("NonInvasiveFatalECGThorax2", new Pair<Integer, Integer>(12, 58));
        shapeletParams.put("OliveOil", new Pair<Integer, Integer>(8, 27));
        shapeletParams.put("OSULeaf", new Pair<Integer, Integer>(141, 330));
        shapeletParams.put("PhalangesOutlinesCorrect", new Pair<Integer, Integer>(5, 14));
        shapeletParams.put("Plane", new Pair<Integer, Integer>(18, 109));
        shapeletParams.put("ProximalPhalanxOutlineAgeGroup", new Pair<Integer, Integer>(7, 31));
        shapeletParams.put("ProximalPhalanxOutlineCorrect", new Pair<Integer, Integer>(5, 12));
        shapeletParams.put("ProximalPhalanxTW", new Pair<Integer, Integer>(9, 31));
        shapeletParams.put("PtNDeviceGroups", new Pair<Integer, Integer>(51, 261));
        shapeletParams.put("PtNDevices", new Pair<Integer, Integer>(100, 310));
        shapeletParams.put("RefrigerationDevices", new Pair<Integer, Integer>(13, 65));
        shapeletParams.put("ScreenType", new Pair<Integer, Integer>(11, 131));
        shapeletParams.put("ShapeletSim", new Pair<Integer, Integer>(25, 35));
        shapeletParams.put("SmallKitchenAppliances", new Pair<Integer, Integer>(31, 443));
        shapeletParams.put("SonyAIBORobotSurface1", new Pair<Integer, Integer>(15, 36));
        shapeletParams.put("SonyAIBORobotSurface2", new Pair<Integer, Integer>(22, 57));
        shapeletParams.put("StarlightCurves", new Pair<Integer, Integer>(68, 650));
        shapeletParams.put("SwedishLeaf", new Pair<Integer, Integer>(11, 45));
        shapeletParams.put("Symbols", new Pair<Integer, Integer>(52, 155));
        shapeletParams.put("SyntheticControl", new Pair<Integer, Integer>(20, 56));
        shapeletParams.put("ToeSegmentation1", new Pair<Integer, Integer>(39, 153));
        shapeletParams.put("ToeSegmentation2", new Pair<Integer, Integer>(100, 248));
        shapeletParams.put("Trace", new Pair<Integer, Integer>(62, 232));
        shapeletParams.put("TwoLeadECG", new Pair<Integer, Integer>(7, 13));
        shapeletParams.put("TwoPatterns", new Pair<Integer, Integer>(20, 71));
        shapeletParams.put("UWaveGestureLibraryX", new Pair<Integer, Integer>(113, 263));
        shapeletParams.put("UWaveGestureLibraryY", new Pair<Integer, Integer>(122, 273));
        shapeletParams.put("UWaveGestureLibraryZ", new Pair<Integer, Integer>(135, 238));
        shapeletParams.put("Wafer", new Pair<Integer, Integer>(29, 152));
        shapeletParams.put("WordSynonyms", new Pair<Integer, Integer>(137, 238));
        shapeletParams.put("Worms", new Pair<Integer, Integer>(93, 382));
        shapeletParams.put("WormsTwoClass", new Pair<Integer, Integer>(46, 377));
        shapeletParams.put("Yoga", new Pair<Integer, Integer>(12, 132));
        Collections.unmodifiableMap(shapeletParams);
    }

    public static class ShapeletLengthComparator
    implements Comparator<Shapelet> {
        @Override
        public int compare(Shapelet shapelet1, Shapelet shapelet2) {
            int shapelet1Length = shapelet1.getLength();
            int shapelet2Length = shapelet2.getLength();
            return Integer.compare(shapelet1Length, shapelet2Length);
        }
    }
}

