/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;

public class ShapeletTransformFactoryOptions {
    private final int minLength;
    private final int maxLength;
    private final int kShapelets;
    private final boolean balanceClasses;
    private final boolean binaryClassValue;
    private final boolean roundRobin;
    private final boolean candidatePruning;
    private final SubSeqDistance.DistanceType distance;
    private final ShapeletQuality.ShapeletQualityChoice qualityChoice;
    private final ShapeletSearchOptions searchOptions;

    private ShapeletTransformFactoryOptions(Builder options) {
        this.minLength = options.minLength;
        this.maxLength = options.maxLength;
        this.kShapelets = options.kShapelets;
        this.balanceClasses = options.balanceClasses;
        this.binaryClassValue = options.binaryClassValue;
        this.distance = options.dist;
        this.qualityChoice = options.qualityChoice;
        this.searchOptions = options.searchOptions;
        this.roundRobin = options.roundRobin;
        this.candidatePruning = options.candidatePruning;
    }

    public boolean isBalanceClasses() {
        return this.balanceClasses;
    }

    public boolean isBinaryClassValue() {
        return this.binaryClassValue;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getkShapelets() {
        return this.kShapelets;
    }

    public SubSeqDistance.DistanceType getDistance() {
        return this.distance;
    }

    public boolean useRoundRobin() {
        return this.roundRobin;
    }

    public boolean useCandidatePruning() {
        return this.candidatePruning;
    }

    public ShapeletSearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public ShapeletQuality.ShapeletQualityChoice getQualityChoice() {
        return this.qualityChoice;
    }

    public String toString() {
        return this.minLength + " " + this.maxLength + " " + this.kShapelets + " " + this.balanceClasses;
    }

    public static class Builder {
        private int minLength;
        private int maxLength;
        private int kShapelets;
        private boolean balanceClasses;
        private boolean binaryClassValue;
        private boolean roundRobin;
        private boolean candidatePruning;
        private SubSeqDistance.DistanceType dist;
        private ShapeletQuality.ShapeletQualityChoice qualityChoice;
        private ShapeletSearchOptions searchOptions;

        public Builder useRoundRobin() {
            this.roundRobin = true;
            return this;
        }

        public Builder useCandidatePruning() {
            this.candidatePruning = true;
            return this;
        }

        public Builder setSearchOptions(ShapeletSearchOptions sOp) {
            this.searchOptions = sOp;
            return this;
        }

        public Builder setQualityMeasure(ShapeletQuality.ShapeletQualityChoice qm) {
            this.qualityChoice = qm;
            return this;
        }

        public Builder setMinLength(int min) {
            this.minLength = min;
            return this;
        }

        public Builder setMaxLength(int max) {
            this.maxLength = max;
            return this;
        }

        public Builder setKShapelets(int k) {
            this.kShapelets = k;
            return this;
        }

        public Builder useClassBalancing() {
            this.balanceClasses = true;
            return this;
        }

        public Builder useBinaryClassValue() {
            this.balanceClasses = true;
            return this;
        }

        public Builder setDistanceType(SubSeqDistance.DistanceType dis) {
            this.dist = dis;
            return this;
        }

        public ShapeletTransformFactoryOptions build() {
            this.setDefaults();
            return new ShapeletTransformFactoryOptions(this);
        }

        private void setDefaults() {
            if (this.searchOptions == null) {
                this.searchOptions = new ShapeletSearchOptions.Builder().setMin(this.minLength).setMax(this.maxLength).setSearchType(ShapeletSearch.SearchType.FULL).build();
            }
            if (this.qualityChoice == null) {
                this.qualityChoice = ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN;
            }
            if (this.dist == null) {
                this.dist = SubSeqDistance.DistanceType.NORMAL;
            }
        }
    }
}

