/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import timeseriesweka.filters.shapelet_transforms.BalancedClassShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformFactoryOptions;
import timeseriesweka.filters.shapelet_transforms.class_value.BinaryClassValue;
import timeseriesweka.filters.shapelet_transforms.class_value.NormalClassValue;
import timeseriesweka.filters.shapelet_transforms.distance_functions.CachedSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.DimensionDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.ImprovedOnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.MultivariateDependentDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.MultivariateIndependentDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.OnlineCachedSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.OnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchFactory;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;

public class ShapeletTransformFactory {
    private static final Map<SubSeqDistance.DistanceType, Supplier<SubSeqDistance>> distanceFunctions = ShapeletTransformFactory.createDistanceTable();
    ShapeletTransformFactoryOptions options;

    private static Map<SubSeqDistance.DistanceType, Supplier<SubSeqDistance>> createDistanceTable() {
        HashMap<SubSeqDistance.DistanceType, Supplier<SubSeqDistance>> dCons = new HashMap<SubSeqDistance.DistanceType, Supplier<SubSeqDistance>>();
        dCons.put(SubSeqDistance.DistanceType.NORMAL, SubSeqDistance::new);
        dCons.put(SubSeqDistance.DistanceType.ONLINE, OnlineSubSeqDistance::new);
        dCons.put(SubSeqDistance.DistanceType.IMP_ONLINE, ImprovedOnlineSubSeqDistance::new);
        dCons.put(SubSeqDistance.DistanceType.CACHED, CachedSubSeqDistance::new);
        dCons.put(SubSeqDistance.DistanceType.ONLINE_CACHED, OnlineCachedSubSeqDistance::new);
        dCons.put(SubSeqDistance.DistanceType.DEPENDENT, MultivariateDependentDistance::new);
        dCons.put(SubSeqDistance.DistanceType.INDEPENDENT, MultivariateIndependentDistance::new);
        dCons.put(SubSeqDistance.DistanceType.DIMENSION, DimensionDistance::new);
        return dCons;
    }

    public ShapeletTransformFactory(ShapeletTransformFactoryOptions op) {
        this.options = op;
    }

    public ShapeletTransform getTransform() {
        ShapeletTransform st = this.createTransform(this.options.isBalanceClasses());
        st.setClassValue(this.createClassValue(this.options.isBinaryClassValue()));
        st.setShapeletMinAndMax(this.options.getMinLength(), this.options.getMaxLength());
        st.setNumberOfShapelets(this.options.getkShapelets());
        st.setSubSeqDistance(this.createDistance(this.options.getDistance()));
        st.setSearchFunction(this.createSearch(this.options.getSearchOptions()));
        st.setQualityMeasure(this.options.getQualityChoice());
        st.setRoundRobin(this.options.useRoundRobin());
        st.setCandidatePruning(this.options.useCandidatePruning());
        return st;
    }

    public static ShapeletTransform createDefaultTimedTransform(long numShapeletsToEvaluate, int n, int m, long seed) {
        ShapeletSearchOptions sOp = new ShapeletSearchOptions.Builder().setMin(3).setMax(m).setSearchType(ShapeletSearch.SearchType.IMP_RANDOM).setNumShapelets(numShapeletsToEvaluate).setSeed(seed).build();
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().useClassBalancing().useBinaryClassValue().useCandidatePruning().setKShapelets(Math.min(2000, n)).setDistanceType(SubSeqDistance.DistanceType.IMP_ONLINE).setSearchOptions(sOp).build();
        return new ShapeletTransformFactory(options).getTransform();
    }

    private ShapeletSearch createSearch(ShapeletSearchOptions sOp) {
        return new ShapeletSearchFactory(sOp).getShapeletSearch();
    }

    private NormalClassValue createClassValue(boolean classValue) {
        return classValue ? new BinaryClassValue() : new NormalClassValue();
    }

    private ShapeletTransform createTransform(boolean balance) {
        return balance ? new BalancedClassShapeletTransform() : new ShapeletTransform();
    }

    private SubSeqDistance createDistance(SubSeqDistance.DistanceType dist) {
        return distanceFunctions.get((Object)dist).get();
    }

    public static void main(String[] args) {
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().useClassBalancing().setKShapelets(1000).setDistanceType(SubSeqDistance.DistanceType.NORMAL).setMinLength(3).setMaxLength(100).build();
        ShapeletTransformFactory factory = new ShapeletTransformFactory(options);
        ShapeletTransform st = factory.getTransform();
    }
}

