/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.ShapeletCandidate;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;

public class Shapelet
implements Comparable<Shapelet>,
Serializable {
    public double separationGap;
    public ShapeletCandidate content;
    public int numDimensions = 1;
    public int dimension = 0;
    public int length;
    public int seriesId;
    public int startPos;
    public ShapeletQualityMeasure qualityType;
    public double qualityValue;
    public boolean hasContent = true;
    boolean useSeparationGap = false;
    public double classValue;

    public void setUseSeparationGap(boolean b) {
        this.useSeparationGap = true;
    }

    public ShapeletCandidate getContent() {
        return this.content;
    }

    public int getLength() {
        return this.length;
    }

    public int getNumDimensions() {
        if (this.content != null) {
            this.numDimensions = this.content.getNumChannels();
        }
        return this.numDimensions;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getQualityValue() {
        return this.qualityValue;
    }

    public int getSeriesId() {
        return this.seriesId;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setSeriesID(int a) {
        this.seriesId = a;
    }

    public Shapelet(ShapeletCandidate content) {
        this.content = content;
        this.numDimensions = content.getNumChannels();
        this.length = content.getLength();
    }

    public Shapelet(int seriesId, int startPos, ShapeletQualityMeasure qualityChoice) {
        this.seriesId = seriesId;
        this.startPos = startPos;
        this.qualityType = qualityChoice;
        this.content = null;
        this.length = 0;
        this.hasContent = false;
    }

    public Shapelet(ShapeletCandidate content, double qualValue, int seriesId, int startPos) {
        this.content = content;
        this.numDimensions = content.getNumChannels();
        this.length = content.getLength();
        this.seriesId = seriesId;
        this.startPos = startPos;
        this.qualityValue = qualValue;
    }

    public Shapelet(ShapeletCandidate content, double qualValue, int seriesId, int startPos, double sepGap) {
        this.content = content;
        this.numDimensions = content.getNumChannels();
        this.length = content.getLength();
        this.seriesId = seriesId;
        this.startPos = startPos;
        this.qualityValue = qualValue;
        this.separationGap = sepGap;
    }

    public Shapelet(ShapeletCandidate content, int seriesId, int startPos, ShapeletQualityMeasure qualityChoice) {
        this.content = content;
        this.length = content.getLength();
        this.numDimensions = content.getNumChannels();
        this.seriesId = seriesId;
        this.startPos = startPos;
        this.qualityType = qualityChoice;
    }

    public double[] getUniveriateShapeletContent() {
        return this.content.getShapeletContent(0);
    }

    public void clearContent() {
        this.length = this.content.getLength();
        this.content = null;
        this.hasContent = false;
    }

    public void calculateQuality(List<OrderLineObj> orderline, ClassDistribution classDistribution) {
        this.qualityValue = this.qualityType.calculateQuality(orderline, classDistribution);
        this.qualityValue = this.qualityType.calculateQuality(orderline, classDistribution);
    }

    public void calculateSeperationGap(List<OrderLineObj> orderline) {
        this.separationGap = this.qualityType.calculateSeperationGap(orderline);
    }

    @Override
    public int compareTo(Shapelet shapelet) {
        int compare1 = Double.compare(this.qualityValue, shapelet.qualityValue);
        int compare2 = Double.compare(this.content.getLength(), shapelet.getLength());
        return compare1 != 0 ? compare1 : compare2;
    }

    public String toString() {
        String str = this.seriesId + "," + this.startPos + "," + this.length + "," + this.dimension + "," + this.qualityValue;
        return str;
    }

    public static class SeparationGap
    implements Comparator<Shapelet>,
    Serializable {
        @Override
        public int compare(Shapelet s1, Shapelet s2) {
            int compare1 = Double.compare(s1.qualityValue, s2.qualityValue);
            if (compare1 != 0) {
                return compare1;
            }
            int compare2 = Double.compare(s1.separationGap, s2.separationGap);
            if (compare2 != 0) {
                return compare2;
            }
            int compare3 = Double.compare(s1.getLength(), s2.getLength());
            return compare3;
        }
    }

    public static class ReverseSeparationGap
    implements Comparator<Shapelet>,
    Serializable {
        @Override
        public int compare(Shapelet s1, Shapelet s2) {
            return -new SeparationGap().compare(s1, s2);
        }
    }

    public static class LongOrder
    implements Comparator<Shapelet>,
    Serializable {
        @Override
        public int compare(Shapelet s1, Shapelet s2) {
            int compare1 = Double.compare(s2.qualityValue, s1.qualityValue);
            int compare2 = s1.getLength() - s2.getLength();
            return compare1 != 0 ? compare1 : compare2;
        }
    }

    public static class ShortOrder
    implements Comparator<Shapelet>,
    Serializable {
        @Override
        public int compare(Shapelet s1, Shapelet s2) {
            int compare1 = Double.compare(s2.qualityValue, s1.qualityValue);
            int compare2 = s2.getLength() - s1.getLength();
            return compare1 != 0 ? compare1 : compare2;
        }
    }
}

