/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformFactoryOptions;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformTimingUtilities;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.TriFunction;
import utilities.multivariate_tools.MultivariateInstanceTools;
import weka.core.Instances;

public class DefaultShapeletOptions {
    public static final Map<String, Function<Instances, ShapeletTransformFactoryOptions>> FACTORY_OPTIONS;
    public static final Map<String, TriFunction<Instances, Long, Long, ShapeletTransformFactoryOptions>> TIMED_FACTORY_OPTIONS;

    public static ShapeletTransformFactoryOptions createIndependentShapeletSearch_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        searchBuilder.setSearchType(ShapeletSearch.SearchType.FULL);
        searchBuilder.setNumDimensions(MultivariateInstanceTools.numChannels(train));
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            System.out.println("initiate timed");
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.DIMENSION).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_I_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        opCount = opCount.multiply(BigInteger.valueOf(MultivariateInstanceTools.numChannels(train)));
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.INDEPENDENT).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_D_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        opCount = opCount.multiply(BigInteger.valueOf(MultivariateInstanceTools.numChannels(train)));
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.DEPENDENT).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSKIPPING_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = train.numAttributes() - 1;
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.FULL);
            int i = 1;
            while (ShapeletTransformTimingUtilities.calc(n, m, 3, m, i, i) > opCountTarget.doubleValue()) {
                ++i;
            }
            System.out.println(i);
            searchBuilder.setPosInc(i);
            searchBuilder.setLengthInc(i);
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.CACHED).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createTABU_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = train.numAttributes() - 1;
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.TABU);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.CACHED).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createRANDOM_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = train.numAttributes() - 1;
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.CACHED).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createMAGNIFY_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = train.numAttributes() - 1;
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.MAGNIFY);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.CACHED).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createIndependentShapeletSearch(Instances train) {
        ShapeletSearchOptions sOps = new ShapeletSearchOptions.Builder().setMin(3).setMax(MultivariateInstanceTools.channelLength(train)).setSearchType(ShapeletSearch.SearchType.FULL).setNumDimensions(MultivariateInstanceTools.numChannels(train)).build();
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setSearchOptions(sOps).setDistanceType(SubSeqDistance.DistanceType.DIMENSION).setKShapelets(Math.min(2000, train.numInstances())).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_I(Instances train) {
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setMinLength(3).setMaxLength(MultivariateInstanceTools.channelLength(train)).setDistanceType(SubSeqDistance.DistanceType.INDEPENDENT).setKShapelets(Math.min(2000, train.numInstances())).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_D(Instances train) {
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setMinLength(3).setMaxLength(MultivariateInstanceTools.channelLength(train)).setDistanceType(SubSeqDistance.DistanceType.DEPENDENT).setKShapelets(Math.min(2000, train.numInstances())).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("INDEPENDENT", DefaultShapeletOptions::createIndependentShapeletSearch);
        map.put("SHAPELET_I", DefaultShapeletOptions::createSHAPELET_I);
        map.put("SHAPELET_D", DefaultShapeletOptions::createSHAPELET_D);
        FACTORY_OPTIONS = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("INDEPENDENT", DefaultShapeletOptions::createIndependentShapeletSearch_TIMED);
        map.put("SHAPELET_I", DefaultShapeletOptions::createSHAPELET_I_TIMED);
        map.put("SHAPELET_D", DefaultShapeletOptions::createSHAPELET_D_TIMED);
        map.put("SKIPPING", DefaultShapeletOptions::createSKIPPING_TIMED);
        map.put("TABU", DefaultShapeletOptions::createTABU_TIMED);
        map.put("RANDOM", DefaultShapeletOptions::createRANDOM_TIMED);
        map.put("MAGNIFY", DefaultShapeletOptions::createMAGNIFY_TIMED);
        TIMED_FACTORY_OPTIONS = Collections.unmodifiableMap(map);
    }
}

