/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.instance.Resample;

@Deprecated
public class ApproximateShapeletTransform
extends ShapeletTransform {
    protected int seriesSampleLevel = 50;
    protected int dataPointsSize = 50;
    private ArrayList<Integer> sampledIDs;

    public ApproximateShapeletTransform() {
    }

    public ApproximateShapeletTransform(int k) {
        super(k);
    }

    public ApproximateShapeletTransform(int k, int minShapeletLength, int maxShapeletLength) {
        super(k, minShapeletLength, maxShapeletLength);
    }

    public ApproximateShapeletTransform(int k, int minShapeletLength, int maxShapeletLength, ShapeletQuality.ShapeletQualityChoice qualityChoice) {
        super(k, minShapeletLength, maxShapeletLength, qualityChoice);
    }

    public void setSampleLevels(int series, int dataPoints) throws IOException {
        if (series < 1 || series > 100) {
            throw new IOException("Series sample level must be in range [1, 100]");
        }
        if (dataPoints < 1 || dataPoints > 100) {
            throw new IOException("Piece aggregate approximation must be in range [1, 100]");
        }
        this.seriesSampleLevel = series;
        this.dataPointsSize = dataPoints;
    }

    @Override
    public Instances process(Instances dataInst) throws IllegalArgumentException {
        this.inputCheck(dataInst);
        Instances orderedInst = null;
        if (!this.m_FirstBatchDone) {
            this.sampledIDs = new ArrayList();
            dataInst = this.approximateInstanes(dataInst);
            this.dataSourceIDs = new int[dataInst.numInstances()];
            int[] roundRobidIDs = new int[dataInst.numInstances()];
            orderedInst = ApproximateShapeletTransform.roundRobinData(dataInst, roundRobidIDs);
            this.dataSourceIDs = new int[dataInst.numInstances()];
            for (int i = 0; i < this.dataSourceIDs.length; ++i) {
                this.dataSourceIDs[i] = this.sampledIDs.get(roundRobidIDs[i]);
            }
        } else {
            dataInst = this.performPAA(dataInst);
        }
        if (!this.m_FirstBatchDone) {
            this.shapelets = this.findBestKShapeletsCache(orderedInst);
            this.m_FirstBatchDone = true;
            if (!this.supressOutput) {
                System.out.println(this.shapelets.size() + " Shapelets have been generated");
            }
        }
        return this.buildTansformedDataset(dataInst);
    }

    private Instances approximateInstanes(Instances data) {
        Instances output = this.sampleInstances(data);
        output = this.performPAA(output);
        return output;
    }

    private Instances sampleInstances(Instances data) {
        if (this.seriesSampleLevel == 100) {
            return data;
        }
        Resample sampler = new Resample();
        try {
            sampler.setInputFormat(data);
        }
        catch (Exception ex) {
            Logger.getLogger(ApproximateShapeletTransform.class.getName()).log(Level.SEVERE, null, ex);
        }
        sampler.setNoReplacement(true);
        sampler.setSampleSizePercent(this.seriesSampleLevel);
        for (int i = 0; i < data.numInstances(); ++i) {
            sampler.input(data.instance(i));
        }
        sampler.batchFinished();
        Instances sampledData = new Instances(data, data.numInstances() * this.seriesSampleLevel / 100);
        boolean isFinished = false;
        while (!isFinished) {
            Instance toAdd = sampler.output();
            if (toAdd == null) {
                isFinished = true;
                continue;
            }
            sampledData.add(toAdd);
            for (int sIndex = 0; sIndex < data.numInstances(); ++sIndex) {
                for (int attIndex = 0; attIndex < data.numAttributes() && data.instance(sIndex).value(attIndex) == toAdd.value(attIndex); ++attIndex) {
                    if (attIndex != data.numAttributes() - 1) continue;
                    this.sampledIDs.add(sIndex);
                }
            }
        }
        return sampledData;
    }

    private Instances performPAA(Instances data) {
        if (this.dataPointsSize == 100) {
            return data;
        }
        int paaSize = (data.numAttributes() - 1) * this.dataPointsSize / 100;
        Instances output = null;
        try {
            output = this.determinePAAOutputFormat(data, paaSize);
        }
        catch (Exception ex) {
            Logger.getLogger(ApproximateShapeletTransform.class.getName()).log(Level.SEVERE, null, ex);
        }
        double portionLength = (double)(data.numAttributes() - 1) / (double)paaSize;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance currentInstance = data.instance(i);
            DenseInstance toAdd = new DenseInstance(paaSize + 1);
            double[] series = currentInstance.toDoubleArray();
            series = this.subseqDistance.zNormalise(series, true);
            double[] paaSublists = new double[paaSize];
            int[] paaSublistsSizes = new int[paaSize];
            double currentPortion = portionLength;
            int seriesIndex = 0;
            int subListIndex = 0;
            boolean advance = false;
            while (!advance) {
                if (currentPortion >= 0.999999999999) {
                    int n = subListIndex;
                    paaSublistsSizes[n] = paaSublistsSizes[n] + 1;
                    int n2 = subListIndex;
                    paaSublists[n2] = paaSublists[n2] + series[seriesIndex++];
                    if (!((currentPortion -= 1.0) < 0.0)) continue;
                    currentPortion = 0.0;
                    continue;
                }
                if (seriesIndex < series.length - 1) {
                    int n = subListIndex;
                    paaSublistsSizes[n] = paaSublistsSizes[n] + 1;
                    int n3 = subListIndex++;
                    paaSublists[n3] = paaSublists[n3] + currentPortion * series[seriesIndex];
                    currentPortion = 1.0 - currentPortion;
                    int n4 = subListIndex;
                    paaSublistsSizes[n4] = paaSublistsSizes[n4] + 1;
                    int n5 = subListIndex;
                    paaSublists[n5] = paaSublists[n5] + currentPortion * series[seriesIndex];
                    currentPortion = portionLength - currentPortion;
                } else {
                    advance = true;
                }
                ++seriesIndex;
            }
            for (int j = 0; j < paaSublists.length; ++j) {
                toAdd.setValue(j, paaSublists[j] / (double)paaSublistsSizes[j]);
            }
            toAdd.setValue(paaSize, currentInstance.classValue());
            output.add(toAdd);
        }
        return output;
    }

    private Instances determinePAAOutputFormat(Instances inputFormat, int length) throws Exception {
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < length; ++i) {
            String name = "PAA" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("PAA" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    private void printTreeMap(TreeMap<Double, Integer> dist) {
        System.out.println("\nTREEMAP");
        for (Double d : dist.keySet()) {
            System.out.println(d + ": " + dist.get(d));
        }
    }

    private double[] testPAA(double[] data) throws IOException {
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < data.length - 1; ++i) {
            String name = "Attribute" + i;
            atts.addElement(new Attribute(name));
        }
        FastVector<String> classValues = new FastVector<String>();
        classValues.addElement("0");
        classValues.addElement("1");
        Attribute classAtt = new Attribute("Binary", classValues);
        atts.addElement(classAtt);
        Instances instances = new Instances("Test", atts, 1);
        instances.setClassIndex(data.length - 1);
        DenseInstance inst = new DenseInstance(1.0, data);
        instances.add(inst);
        Instances output = this.performPAA(instances);
        return output.instance(0).toDoubleArray();
    }

    public static void main(String[] args) {
        System.out.println("\n1.) Create series for testing: ");
        int seriesLength = 11;
        double[] dataEven = new double[seriesLength];
        int min = -5;
        int max = 5;
        for (int j = 0; j < seriesLength; ++j) {
            dataEven[j] = j == seriesLength - 1 ? 0.0 : (double)(min + (int)(Math.random() * (double)(max - min + 1)));
        }
        seriesLength = 10;
        double[] dataUneven = new double[seriesLength];
        for (int j = 0; j < seriesLength; ++j) {
            dataUneven[j] = j == seriesLength - 1 ? 0.0 : (double)(min + (int)(Math.random() * (double)(max - min + 1)));
        }
        ApproximateShapeletTransform ast = new ApproximateShapeletTransform();
        double[] out = null;
        try {
            ast.setSampleLevels(100, 50);
            out = ast.testPAA(dataEven);
        }
        catch (IOException ex) {
            Logger.getLogger(ApproximateShapeletTransform.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Even Test: ");
    }
}

