/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.io.FileReader;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class RunLength
extends SimpleBatchFilter {
    private int maxRunLength = 50;
    private boolean useGlobalMean = true;
    private double globalMean = 5.5;

    public RunLength() {
    }

    public RunLength(int maxRL) {
        this.maxRunLength = maxRL;
    }

    public void setMaxRL(int m) {
        this.maxRunLength = m;
    }

    public void setGlobalMean(double d) {
        this.useGlobalMean = true;
        this.globalMean = d;
    }

    public void noGlobalMean() {
        this.useGlobalMean = false;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < this.maxRunLength; ++i) {
            Attribute a = new Attribute("RunLengthCount" + (i + 1));
            atts.addElement(a);
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("RunLengths" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances rl = this.determineOutputFormat(instances);
        if (instances.classIndex() >= 0) {
            rl.setClassIndex(rl.numAttributes() - 1);
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            boolean under;
            DenseInstance newInst = new DenseInstance(rl.numAttributes());
            double[] d = instances.instance(i).toDoubleArray();
            if (instances.classIndex() >= 0) {
                double cVal = instances.instance(i).classValue();
                double[] temp = new double[d.length - 1];
                System.arraycopy(d, 0, temp, 0, instances.instance(i).classIndex());
                if (instances.instance(i).classIndex() < d.length - 1) {
                    System.arraycopy(d, instances.instance(i).classIndex() + 1, temp, instances.instance(i).classIndex(), d.length - instances.instance(i).classIndex() - 1);
                }
                d = temp;
            }
            double[] histogram = new double[newInst.numAttributes()];
            double t = 0.0;
            if (this.useGlobalMean) {
                t = this.globalMean;
            } else {
                int count = 0;
                for (int j = 0; j < d.length; ++j) {
                    if (instances.instance(i).isMissing(j)) continue;
                    t += d[j];
                    ++count;
                }
                t /= (double)count;
            }
            int length = 0;
            boolean u2 = false;
            boolean bl = under = d[0] < t;
            for (int pos = 1; pos < d.length; ++pos) {
                boolean bl2 = u2 = d[pos] < t;
                if (instances.instance(i).isMissing(pos) || under == u2) {
                    ++length;
                    continue;
                }
                if (length < this.maxRunLength - 1) {
                    int n = length;
                    histogram[n] = histogram[n] + 1.0;
                } else {
                    int n = this.maxRunLength - 1;
                    histogram[n] = histogram[n] + 1.0;
                }
                under = u2;
                length = 0;
            }
            if (length < this.maxRunLength - 1) {
                int n = length;
                histogram[n] = histogram[n] + 1.0;
            } else {
                int n = this.maxRunLength - 1;
                histogram[n] = histogram[n] + 1.0;
            }
            for (int j = 0; j < histogram.length; ++j) {
                newInst.setValue(j, histogram[j]);
            }
            if (instances.classIndex() >= 0) {
                newInst.setValue(rl.numAttributes() - 1, instances.instance(i).classValue());
            }
            rl.add(newInst);
        }
        return rl;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public int[] processSingleSeries(double[] d, int mrl) {
        boolean under;
        double mean = 0.0;
        int length = 0;
        boolean u2 = false;
        int[] histogram = new int[mrl];
        boolean bl = under = d[0] < mean;
        for (int pos = 1; pos < d.length; ++pos) {
            boolean bl2 = u2 = d[pos] < mean;
            if (under == u2) {
                ++length;
                continue;
            }
            if (length < mrl - 1) {
                int n = length;
                histogram[n] = histogram[n] + 1;
            } else {
                int n = mrl - 1;
                histogram[n] = histogram[n] + 1;
            }
            under = u2;
            length = 0;
        }
        if (length < mrl - 1) {
            int n = length;
            histogram[n] = histogram[n] + 1;
        } else {
            int n = mrl - 1;
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }

    public static void main(String[] args) {
        RunLength cp = new RunLength();
        cp.noGlobalMean();
        Instances data = null;
        String fileName = "C:\\Research\\Data\\Time Series Data\\Time Series Classification\\TestData\\TimeSeries_Train.arff";
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
            System.out.println(data);
            Instances newInst = cp.process(data);
            System.out.println("\n" + newInst);
        }
        catch (Exception e) {
            System.out.println(" Error =" + e);
            StackTraceElement[] st = e.getStackTrace();
            for (int i = st.length - 1; i >= 0; --i) {
                System.out.println(st[i]);
            }
        }
    }
}

