/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class PAA
extends SimpleBatchFilter {
    private int numIntervals = 8;
    private static final long serialVersionUID = 1L;

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public void setNumIntervals(int intervals) {
        this.numIntervals = intervals;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed for PAA");
        }
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = 0; i < this.numIntervals; ++i) {
            attributes.addElement(new Attribute("PAAInterval_" + i));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            attributes.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("PAA" + inputFormat.relationName(), attributes, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Instances process(Instances input) throws Exception {
        Instances output = this.determineOutputFormat(input);
        for (int i = 0; i < input.numInstances(); ++i) {
            double[] data = input.instance(i).toDoubleArray();
            int c = input.classIndex();
            if (c >= 0) {
                double[] temp = new double[data.length - 1];
                System.arraycopy(data, 0, temp, 0, c);
                data = temp;
            }
            double[] intervals = this.convertInstance(data);
            DenseInstance newInstance = input.classIndex() >= 0 ? new DenseInstance(this.numIntervals + 1) : new DenseInstance(this.numIntervals);
            for (int j = 0; j < this.numIntervals; ++j) {
                newInstance.setValue(j, intervals[j]);
            }
            if (input.classIndex() >= 0) {
                newInstance.setValue(output.classIndex(), input.instance(i).classValue());
            }
            output.add(newInstance);
        }
        return output;
    }

    private double[] convertInstance(double[] data) throws Exception {
        if (this.numIntervals > data.length) {
            throw new Exception("Error converting to PAA, number of intervals (" + this.numIntervals + ") greater than series length (" + data.length + ")");
        }
        double[] intervals = new double[this.numIntervals];
        int currentFrame = 0;
        double realFrameLength = (double)data.length / (double)this.numIntervals;
        double frameSum = 0.0;
        double currentFrameSize = 0.0;
        double remaining = 0.0;
        for (int i = 0; i < data.length; ++i) {
            remaining = realFrameLength - currentFrameSize;
            if (remaining > 1.0) {
                frameSum += data[i];
                currentFrameSize += 1.0;
            } else {
                frameSum += remaining * data[i];
                currentFrameSize += remaining;
            }
            if (currentFrameSize != realFrameLength) continue;
            intervals[currentFrame++] = frameSum / realFrameLength;
            frameSum = (1.0 - remaining) * data[i];
            currentFrameSize = 1.0 - remaining;
        }
        if (currentFrame == this.numIntervals - 1) {
            intervals[currentFrame++] = frameSum / realFrameLength;
        }
        return intervals;
    }

    public static double[] convertInstance(double[] data, int numIntervals) throws Exception {
        PAA paa = new PAA();
        paa.setNumIntervals(numIntervals);
        return paa.convertInstance(data);
    }

    @Override
    public String getRevision() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        try {
            double[] wavey = new double[]{0.841470985, 0.948984619, 0.997494987, 0.983985947, 0.909297427, 0.778073197, 0.598472144, 0.381660992, 0.141120008, -0.108195135, -0.350783228, -0.571561319, -0.756802495, -0.894989358, -0.977530118, -0.999292789, -0.958924275, -0.858934493, -0.705540326, -0.508279077, -0.279415498};
            PAA paa = new PAA();
            paa.setNumIntervals(10);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            DenseInstance ins = new DenseInstance(wavey.length + 1);
            for (int i = 0; i < wavey.length; ++i) {
                ins.setValue(i, wavey[i]);
                atts.add(new Attribute("att" + i));
            }
            atts.add(new Attribute("classVal"));
            ins.setValue(wavey.length, 1.0);
            Instances instances = new Instances("blah", atts, 1);
            instances.setClassIndex(instances.numAttributes() - 1);
            instances.add(ins);
            Instances out = paa.process(instances);
            for (int i = 0; i < out.numAttributes() - 1; ++i) {
                System.out.print(out.instance(0).value(i) + ",");
            }
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

