/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import timeseriesweka.filters.FFT;
import weka.core.DenseInstance;
import weka.core.Instances;

public class FFTSmoothing
extends FFT {
    private double truncProp = 1.0;

    public double getTruncateProportion() {
        return this.truncProp;
    }

    public void setTruncateProportion(double prop) {
        this.truncProp = prop;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in FFT");
        }
        return new Instances(inputFormat, 0);
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances output = this.determineOutputFormat(instances);
        int originalLength = instances.numAttributes();
        if (instances.classIndex() >= 0) {
            --originalLength;
        }
        int fullLength = this.findLength(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            FFT.Complex[] c = new FFT.Complex[fullLength];
            int count = 0;
            double seriesTotal = 0.0;
            for (int j = 0; j < originalLength && count < c.length; ++j) {
                if (instances.classIndex() == j) continue;
                c[count] = new FFT.Complex(instances.instance(i).value(j), 0.0);
                seriesTotal += instances.instance(i).value(j);
                ++count;
            }
            double mean = seriesTotal / (double)count;
            while (count < c.length) {
                c[count++] = new FFT.Complex(mean, 0.0);
            }
            if (this.algo == FFT.AlgorithmType.FFT) {
                this.fft(c, c.length);
            } else {
                c = this.dft(c);
            }
            int numCoeffsToKeep = (int)(this.truncProp * (double)c.length);
            double[] smoothedSignal = new double[c.length + 1];
            for (int a = 0; a < originalLength; ++a) {
                smoothedSignal[a] = 0.0;
                for (int j = 0; j < numCoeffsToKeep; ++j) {
                    int n = a;
                    smoothedSignal[n] = smoothedSignal[n] + (double)c[j].real * Math.sin(a);
                    int n2 = a;
                    smoothedSignal[n2] = smoothedSignal[n2] + (double)c[j].imag * Math.cos(a);
                }
            }
            smoothedSignal[c.length] = instances.instance(i).classValue();
            DenseInstance inst = new DenseInstance(1.0, smoothedSignal);
            output.add(inst);
        }
        return output;
    }
}

