/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class FFT
extends SimpleBatchFilter {
    AlgorithmType algo = AlgorithmType.DFT;
    private static final long serialVersionUID = 1L;
    private boolean pad = true;
    private static final double TWOPI = Math.PI * 2;

    public void padSeries(boolean b) {
        this.pad = b;
    }

    public void useDFT() {
        this.algo = AlgorithmType.DFT;
    }

    public void useFFT() {
        this.algo = AlgorithmType.FFT;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in FFT");
        }
        int length = this.findLength(inputFormat);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < length; ++i) {
            String name = i % 2 == 0 ? "FFT_" + i / 2 + "_Real" : "FFT_" + i / 2 + "_Imag";
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("FFT_" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected int findLength(Instances inputFormat) {
        if (this.algo == AlgorithmType.FFT) {
            return this.findPowerOfTwoLength(inputFormat);
        }
        if (this.algo == AlgorithmType.DFT) {
            if (inputFormat.classIndex() >= 0) {
                return inputFormat.numAttributes() - 1;
            }
            return inputFormat.numAttributes();
        }
        throw new RuntimeException("Aglorithm Type+ " + (Object)((Object)this.algo) + " has not been implemented for FFT Class");
    }

    protected int findPowerOfTwoLength(Instances inputFormat) {
        int oldLength = 0;
        int length = 0;
        oldLength = inputFormat.classIndex() >= 0 ? inputFormat.numAttributes() - 1 : inputFormat.numAttributes();
        if (!MathsPower2.isPow2(oldLength)) {
            length = (int)MathsPower2.roundPow2(oldLength);
            if (this.pad) {
                if (length < oldLength) {
                    length *= 2;
                }
            } else if (length > oldLength) {
                length /= 2;
            }
        } else {
            length = oldLength;
        }
        return length;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances output = this.determineOutputFormat(instances);
        int originalLength = instances.numAttributes();
        if (instances.classIndex() >= 0) {
            --originalLength;
        }
        int fullLength = this.findLength(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Complex[] c = new Complex[fullLength];
            int count = 0;
            double seriesTotal = 0.0;
            for (int j = 0; j < originalLength && count < c.length; ++j) {
                if (instances.classIndex() == j) continue;
                c[count] = new Complex(instances.instance(i).value(j), 0.0);
                seriesTotal += instances.instance(i).value(j);
                ++count;
            }
            double mean = seriesTotal / (double)count;
            while (count < c.length) {
                c[count++] = new Complex(mean, 0.0);
            }
            if (this.algo == AlgorithmType.FFT) {
                this.fft(c, c.length);
            } else {
                c = this.dft(c);
            }
            DenseInstance inst = new DenseInstance(c.length + 1);
            for (int j = 0; j < c.length / 2; ++j) {
                inst.setValue(2 * j, (double)c[j].real);
                inst.setValue(2 * j + 1, (double)c[j].imag);
            }
            if (instances.classIndex() >= 0) {
                inst.setValue(output.classIndex(), instances.instance(i).classValue());
            }
            output.add(inst);
        }
        return output;
    }

    public Complex[] dft(double[] series) {
        int n = series.length;
        Complex[] dft = new Complex[n];
        for (int k = 0; k < n; ++k) {
            float sumreal = 0.0f;
            float sumimag = 0.0f;
            for (int t = 0; t < series.length; ++t) {
                sumreal = (float)((double)sumreal + series[t] * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n));
                sumimag = (float)((double)sumimag + -series[t] * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n));
            }
            dft[k] = new Complex(sumreal, sumimag);
        }
        return dft;
    }

    public Complex[] dft(Complex[] complex) {
        int n = complex.length;
        Complex[] dft = new Complex[n];
        for (int k = 0; k < n; ++k) {
            float sumreal = 0.0f;
            float sumimag = 0.0f;
            for (int t = 0; t < complex.length; ++t) {
                sumreal = (float)((double)sumreal + ((double)complex[t].real * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n) + (double)complex[t].imag * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n)));
                sumimag = (float)((double)sumimag + ((double)(-complex[t].real) * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n) + (double)complex[t].imag * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n)));
            }
            dft[k] = new Complex(sumreal, sumimag);
        }
        return dft;
    }

    public void fft(Complex[] complex, int n) {
        this.fft(1, complex, n);
    }

    public static void bitReverse(Complex[] complex, int n) {
        Complex temp;
        int halfN = n / 2;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            int m;
            if (j >= i) {
                temp = complex[j];
                complex[j] = complex[i];
                complex[i] = temp;
            }
            for (m = halfN; m >= 1 && j >= m; j -= m, m /= 2) {
            }
            j += m;
        }
        temp = null;
    }

    public void inverseFFT(Complex[] complex, int n) {
        this.fft(-1, complex, n);
    }

    private void fft(int sign, Complex[] complex, int n) {
        n = (int)MathsPower2.roundPow2(n);
        FFT.bitReverse(complex, n);
        if (n == 2) {
            FFT.radix2FFT(sign, complex, n, 0);
        } else if ((float)Math.log(n) % (float)Math.log(4.0) == 0.0f) {
            FFT.radix4FFT(sign, complex, n, 0);
        } else {
            int halfN = n / 2;
            FFT.radix4FFT(sign, complex, halfN, 0);
            FFT.radix4FFT(sign, complex, halfN, halfN);
            Complex[] radix2x2 = new Complex[2];
            Complex twiddle = new Complex();
            double delta = (double)(-sign) * (Math.PI * 2) / (double)n;
            double w = 0.0;
            int g = 0;
            int h = halfN;
            while (g < halfN) {
                twiddle.setRealImag((float)Math.cos(w), (float)Math.sin(w));
                complex[h].multiply(twiddle);
                radix2x2[0] = complex[g];
                radix2x2[1] = complex[h];
                FFT.radix2FFT(sign, radix2x2, 2, 0);
                complex[g] = radix2x2[0];
                complex[h] = radix2x2[1];
                w += delta;
                ++g;
                ++h;
            }
            radix2x2 = null;
            twiddle = null;
        }
        if (sign == -1) {
            for (int g = 0; g < n; ++g) {
                complex[g].divide(n);
            }
        }
    }

    private static void radix4FFT(int sign, Complex[] complex, int n, int lower) {
        int upper = n + lower;
        Complex ijAdd = new Complex();
        Complex klAdd = new Complex();
        Complex ijSub = new Complex();
        Complex klSub = new Complex();
        Complex twiddle = new Complex();
        double deltaLower = (double)(-sign) * (Math.PI * 2);
        int intraGap = 1;
        int interGap = 4 * intraGap;
        while (intraGap < n) {
            double delta = deltaLower / (double)interGap;
            double w3 = 0.0;
            double w2 = 0.0;
            double w = 0.0;
            for (int but = 0; but < intraGap; ++but) {
                int i = but + lower;
                int j = i + intraGap;
                int k = j + intraGap;
                int l = k + intraGap;
                while (i < upper) {
                    twiddle.setRealImag(1.0f, 0.0f);
                    complex[i].multiply(twiddle);
                    twiddle.setRealImag((float)Math.cos(w2), (float)Math.sin(w2));
                    complex[j].multiply(twiddle);
                    twiddle.setRealImag((float)Math.cos(w), (float)Math.sin(w));
                    complex[k].multiply(twiddle);
                    twiddle.setRealImag((float)Math.cos(w3), (float)Math.sin(w3));
                    complex[l].multiply(twiddle);
                    Complex.add(complex[i], complex[j], ijAdd);
                    Complex.subtract(complex[i], complex[j], ijSub);
                    Complex.add(complex[k], complex[l], klAdd);
                    Complex.subtract(complex[k], complex[l], klSub);
                    Complex.add(ijAdd, klAdd, complex[i]);
                    klSub.multiply(sign);
                    complex[j].setRealImag(ijSub.getReal() + klSub.getImag(), ijSub.getImag() - klSub.getReal());
                    Complex.subtract(ijAdd, klAdd, complex[k]);
                    complex[l].setRealImag(ijSub.getReal() - klSub.getImag(), ijSub.getImag() + klSub.getReal());
                    i += interGap;
                    j += interGap;
                    k += interGap;
                    l += interGap;
                }
                w2 = (w += delta) + w;
                w3 = w2 + w;
            }
            intraGap = interGap;
            intraGap = interGap;
            interGap = 4 * intraGap;
        }
        twiddle = null;
        klSub = null;
        ijSub = null;
        klAdd = null;
        ijAdd = null;
    }

    private static void radix2FFT(int sign, Complex[] complex, int n, int lower) {
        int upper = n + lower;
        Complex twiddle = new Complex();
        float deltaLower = -((float)((double)sign * Math.PI));
        Complex twiddledInput = new Complex();
        int intraGap = 1;
        int interGap = intraGap + intraGap;
        while (intraGap < n) {
            float delta = deltaLower / (float)intraGap;
            float w = 0.0f;
            for (int butterfly = 0; butterfly < intraGap; ++butterfly) {
                twiddle.setRealImag((float)Math.cos(w), (float)Math.sin(w));
                int i = butterfly + lower;
                int j = i + intraGap;
                while (i < upper) {
                    Complex.multiply(complex[j], twiddle, twiddledInput);
                    Complex.subtract(complex[i], twiddledInput, complex[j]);
                    complex[i].add(twiddledInput);
                    i += interGap;
                    j += interGap;
                }
                w += delta;
            }
            intraGap = interGap;
            intraGap = interGap;
            interGap = intraGap + intraGap;
        }
        twiddledInput = null;
        twiddle = null;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public void truncate(Instances d, int n) {
        int att = n;
        if (att < d.numAttributes() - 1) {
            d.deleteAttributeAt(0);
            d.deleteAttributeAt(0);
        }
        while (att < d.numAttributes()) {
            if (att == d.classIndex()) {
                ++att;
                continue;
            }
            d.deleteAttributeAt(att);
        }
    }

    public static void computeDft(double[] inreal, double[] inimag, double[] outreal, double[] outimag) {
        int n = inreal.length;
        for (int k = 0; k < n; ++k) {
            double sumreal = 0.0;
            double sumimag = 0.0;
            for (int t = 0; t < n; ++t) {
                sumreal += inreal[t] * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n) + inimag[t] * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n);
                sumimag += -inreal[t] * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n) + inimag[t] * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n);
            }
            outreal[k] = sumreal;
            outimag[k] = sumimag;
        }
    }

    public int[] processSingleSeries(double[] d, int mrl) {
        return null;
    }

    public static void basicTest() {
        int i;
        System.out.println("Basic test of FFT");
        System.out.println("Series: 30,-1,2,3,3,2,-1,-4");
        System.out.println("\t/*FFT Desired  \t34\n19.9289321881345-5.82842712474618i\n32-2i\n34.0710678118655+0.171572875253798i\n34\n34.0710678118655-0.171572875253815i\n32+2i\n19.9289321881345+5.8284271247462i\nFFT Achieved\n34\t0\n19.928932\t-5.8284273\n32\t-2\n34.071068\t0.17157269\n34\t0\n34.071068\t-0.17157269\n32\t2\n19.928932\t5.8284273");
        double[] d = new double[]{30.0, -1.0, 2.0, 3.0, 3.0, 2.0, -1.0, -4.0};
        int n = 8;
        Complex[] x = new Complex[n];
        for (i = 0; i < n; ++i) {
            x[i] = new Complex(d[i], 0.0);
        }
        for (i = 0; i < n; ++i) {
            System.out.println(x[i].getReal() + "," + x[i].getImag());
        }
        System.out.println("Transformed");
        FFT fft = new FFT();
        fft.fft(x, x.length);
        for (int i2 = 0; i2 < n; ++i2) {
            System.out.println(x[i2].getReal() + "," + x[i2].getImag());
        }
        fft.fft(x, x.length);
    }

    public static void paddingTest() {
    }

    public static void main(String[] args) {
        FFT fft = new FFT();
        int size = 8;
        double[] testSeries = new double[size];
        for (int i = 0; i < size; ++i) {
            testSeries[i] = Math.random();
        }
        Complex[] dft = fft.dft(testSeries);
        Complex[] dft2 = new Complex[size];
        for (int i = 0; i < size; ++i) {
            dft2[i] = new Complex(testSeries[i], 0.0);
        }
        Complex[] dft3 = fft.dft(dft2);
        for (int i = 0; i < size; ++i) {
            System.out.println(dft[i] + "   :::   " + dft3[i]);
        }
        System.exit(0);
        FFT.matlabComparison();
    }

    public static void matlabComparison() {
    }

    public static class Complex
    implements Cloneable {
        protected static final float LOG10 = (float)Math.log(10.0);
        protected static final float DBLOG = 20.0f / LOG10;
        protected float real;
        protected float imag;

        public Complex() {
            this.imag = 0.0f;
            this.real = 0.0f;
        }

        public Complex(float real, float imag) {
            this.real = real;
            this.imag = imag;
        }

        public String toString() {
            return this.real + "+" + this.imag + "*i";
        }

        public Complex(double real, double imag) {
            this.real = (float)real;
            this.imag = (float)imag;
        }

        public void setRealImag(float real, float imag) {
            this.real = real;
            this.imag = imag;
        }

        public float getReal() {
            return this.real;
        }

        public void setReal(float real) {
            this.real = real;
        }

        public float getImag() {
            return this.imag;
        }

        public void setImag(float imag) {
            this.imag = imag;
        }

        public void add(Complex complex) {
            this.real += complex.real;
            this.imag += complex.imag;
        }

        public void subtract(Complex complex) {
            this.real -= complex.real;
            this.imag -= complex.imag;
        }

        public void multiply(float factor) {
            this.real *= factor;
            this.imag *= factor;
        }

        public void divide(float factor) {
            this.real /= factor;
            this.imag /= factor;
        }

        public void multiply(Complex complex) {
            float nuReal = this.real * complex.real - this.imag * complex.imag;
            float nuImag = this.real * complex.imag + this.imag * complex.real;
            this.real = nuReal;
            this.imag = nuImag;
        }

        public void conjugate() {
            this.imag = -this.imag;
        }

        public float addConjugate() {
            return this.real + this.real;
        }

        public float subtractConjugate() {
            return this.imag + this.imag;
        }

        public float getMagnitude() {
            return Complex.magnitude(this.real, this.imag);
        }

        public float getPhase() {
            return Complex.phase(this.real, this.imag);
        }

        public float getPower() {
            return Complex.power(this.real, this.imag);
        }

        public static void add(Complex a, Complex b, Complex c) {
            c.real = a.real + b.real;
            c.imag = a.imag + b.imag;
        }

        public static void subtract(Complex a, Complex b, Complex c) {
            c.real = a.real - b.real;
            c.imag = a.imag - b.imag;
        }

        public static void multiply(Complex a, float factor, Complex b) {
            b.real = a.real * factor;
            b.imag = a.imag * factor;
        }

        public static void divide(Complex a, float factor, Complex b) {
            b.real = a.real / factor;
            b.imag = a.imag / factor;
        }

        public static void multiply(Complex a, Complex b, Complex c) {
            c.real = a.real * b.real - a.imag * b.imag;
            c.imag = a.real * b.imag + a.imag * b.real;
        }

        public static void conjugate(Complex a, Complex b) {
            b.real = a.real;
            b.imag = -a.imag;
        }

        public static float magnitude(float real, float imag) {
            return (float)Math.sqrt(real * real + imag * imag);
        }

        public static float phase(float real, float imag) {
            return (float)Math.atan2(imag, real);
        }

        public static float power(float real, float imag) {
            return DBLOG * (float)Math.log(Complex.magnitude(real, imag));
        }

        public static void reals(int n, Complex[] complex, float[] reals) {
            for (int i = 0; i < n; ++i) {
                reals[i] = complex[i].real;
            }
        }

        public static void imaginaries(int n, Complex[] complex, float[] imags) {
            for (int i = 0; i < n; ++i) {
                imags[i] = complex[i].imag;
            }
        }

        public static void magnitudes(int n, Complex[] complex, float[] mags) {
            for (int i = 0; i < n; ++i) {
                mags[i] = complex[i].getMagnitude();
            }
        }

        public static void powers(int n, Complex[] complex, float[] powers) {
            for (int i = 0; i < n; ++i) {
                powers[i] = complex[i].getPower();
            }
        }

        public static void phase(int n, Complex[] complex, float[] phases) {
            for (int i = 0; i < n; ++i) {
                phases[i] = complex[i].getPhase();
            }
        }

        public Object clone() {
            return new Complex(this.real, this.imag);
        }
    }

    public static class MathsPower2 {
        public static int pow2(int power) {
            return 1 << power;
        }

        public static boolean isPow2(int value) {
            return value == (int)MathsPower2.roundPow2(value);
        }

        public static float roundPow2(float value) {
            float power = (float)(Math.log(value) / Math.log(2.0));
            int intPower = Math.round(power);
            return MathsPower2.pow2(intPower);
        }

        public static int integerLog2(float value) {
            int intValue = value < 2.0f ? 0 : (value < 4.0f ? 1 : (value < 8.0f ? 2 : (value < 16.0f ? 3 : (value < 32.0f ? 4 : (value < 64.0f ? 5 : (value < 128.0f ? 6 : (value < 256.0f ? 7 : (value < 512.0f ? 8 : (value < 1024.0f ? 9 : (value < 2048.0f ? 10 : (value < 4098.0f ? 11 : (value < 8192.0f ? 12 : Math.round(MathsPower2.roundPow2(value))))))))))))));
            return intValue;
        }
    }

    public static enum AlgorithmType {
        DFT,
        FFT;

    }
}

