/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.io.FileReader;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class Clipping
extends SimpleBatchFilter {
    boolean useMean = true;
    boolean useRealAttributes = false;

    public void setUseRealAttributes(boolean f) {
        this.useRealAttributes = f;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        FastVector<String> fv = new FastVector<String>();
        if (!this.useRealAttributes) {
            fv.addElement("0");
            fv.addElement("1");
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            Attribute a = i != inputFormat.classIndex() ? (!this.useRealAttributes ? new Attribute("Clipped" + inputFormat.attribute(i).name(), fv) : new Attribute("Clipped" + inputFormat.attribute(i).name())) : inputFormat.attribute(i);
            atts.addElement(a);
        }
        Instances result = new Instances("Clipped" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    private double[] findMedians(Instances instances) {
        return null;
    }

    private double[] findMeans(Instances instances) {
        double[] means = new double[instances.numInstances()];
        int count = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            count = 0;
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (j == instances.classIndex() || instances.instance(i).isMissing(j)) continue;
                ++count;
                int n = i;
                means[n] = means[n] + instances.instance(i).value(j);
            }
            if (count <= 0) continue;
            int n = i;
            means[n] = means[n] / (double)count;
        }
        return means;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        double[] averages = this.useMean ? this.findMeans(instances) : this.findMedians(instances);
        Instances result = this.determineOutputFormat(instances);
        String val = "0";
        if (!this.useRealAttributes) {
            for (int i = 0; i < instances.numInstances(); ++i) {
                DenseInstance newInst = new DenseInstance(result.numAttributes());
                result.add(newInst);
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    if (instances.instance(i).isMissing(j)) {
                        val = "?";
                        continue;
                    }
                    if (j != instances.classIndex()) {
                        val = instances.instance(i).value(j) < averages[i] ? "0" : "1";
                        result.instance(i).setValue(j, val);
                        continue;
                    }
                    result.instance(i).setValue(j, instances.instance(i).stringValue(j));
                }
            }
        } else {
            double x = 0.0;
            for (int i = 0; i < instances.numInstances(); ++i) {
                DenseInstance newInst = new DenseInstance(result.numAttributes());
                result.add(newInst);
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    if (instances.instance(i).isMissing(j)) {
                        x = -1.0;
                        continue;
                    }
                    if (j != instances.classIndex()) {
                        x = instances.instance(i).value(j) < averages[i] ? 0.0 : 1.0;
                        result.instance(i).setValue(j, x);
                        continue;
                    }
                    result.instance(i).setValue(j, instances.instance(i).value(j));
                }
            }
        }
        return result;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
        Clipping cp = new Clipping();
        Instances data = null;
        String fileName = "C:\\Research\\Data\\Time Series Data\\Time Series Classification\\TestData\\TimeSeries_Train.arff";
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
            System.out.println(" Class type numeric =" + data.attribute(data.numAttributes() - 1).isNumeric());
            System.out.println(" Class type nominal =" + data.attribute(data.numAttributes() - 1).isNominal());
            Instances newInst = cp.process(data);
            System.out.println(newInst);
        }
        catch (Exception e) {
            System.out.println(" Error =" + e);
            StackTraceElement[] st = e.getStackTrace();
            for (int i = st.length - 1; i >= 0; --i) {
                System.out.println(st[i]);
            }
        }
    }
}

