/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.examples;

import development.DataSets;
import fileIO.OutFile;
import statistics.simulators.Model;
import statistics.simulators.SimulateDictionaryData;
import statistics.simulators.SimulateIntervalData;
import statistics.simulators.SimulateShapeletData;
import statistics.simulators.SimulateSpectralData;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.FlatCote;
import timeseriesweka.classifiers.HiveCote;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.CAWPE;
import vector_classifiers.TunedRandomForest;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.RotationForest;
import weka.core.Instances;

public class SimulationExperiments {
    static int[] casesPerClass = new int[]{50, 50};
    static int seriesLength = 300;
    static double trainProp = 0.5;
    static String[] allClassifiers = new String[]{"RotF", "DTW", "HESCA", "DD_DTW", "DTD_C", "EE", "HESCA", "TSF", "TSBF", "LPS", "FastShapelets", "ST", "LearnShapelets", "BOP", "BOSS", "RISE", "COTE", "FLATCOTE", "HIVECOTE"};
    static String[] allSimulators = new String[]{"WholeSeries", "Interval", "Shapelet", "Dictionary", "ARMA"};

    public static Classifier createClassifier(String str) throws RuntimeException {
        AbstractClassifier c;
        switch (str) {
            case "HESCA": {
                c = new CAWPE();
                break;
            }
            case "RandF": {
                c = new TunedRandomForest();
                break;
            }
            case "RotF": {
                c = new RotationForest();
                break;
            }
            case "DTW": {
                c = new FastDTW_1NN();
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "EE": {
                c = new ElasticEnsemble();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            case "FastShapelets": {
                c = new FastShapelets();
                break;
            }
            case "ST": {
                c = new ST_HESCA();
                ((ST_HESCA)c).setOneHourLimit();
                break;
            }
            case "LearnShapelets": {
                c = new LearnShapelets();
                ((LearnShapelets)c).setParamSearch(true);
                break;
            }
            case "BOP": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": {
                c = new BOSS();
                break;
            }
            case "FLATCOTE": {
                c = new FlatCote();
                break;
            }
            case "HIVECOTE": {
                c = new HiveCote();
                break;
            }
            case "RISE": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                ((RISE)c).setNosBaseClassifiers(500);
                break;
            }
            case "RISE_HESCA": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                CAWPE base = new CAWPE();
                ((RISE)c).setBaseClassifier(base);
                ((RISE)c).setNosBaseClassifiers(20);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN CLASSIFIER " + str);
            }
        }
        return c;
    }

    public static void setStandardGlobalParameters(String str) {
        switch (str) {
            case "ARMA": 
            case "AR": 
            case "Spectral": {
                casesPerClass = new int[]{200, 200};
                seriesLength = 200;
                trainProp = 0.1;
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Shapelet": {
                casesPerClass = new int[]{250, 250};
                seriesLength = 300;
                trainProp = 0.1;
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Dictionary": {
                casesPerClass = new int[]{200, 200};
                seriesLength = 1500;
                trainProp = 0.1;
                SimulateDictionaryData.setShapeletsPerClass(new int[]{5, 10});
                SimulateDictionaryData.setShapeletLength(29);
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Interval": {
                seriesLength = 1000;
                trainProp = 0.1;
                casesPerClass = new int[]{200, 200};
                Model.setDefaultSigma(1.0);
                SimulateIntervalData.setNosIntervals(3);
                SimulateIntervalData.setNoiseToSignal(10);
                break;
            }
            case "WholeSeriesElastic": {
                seriesLength = 200;
                trainProp = 0.1;
                casesPerClass = new int[]{200, 200};
                Model.setDefaultSigma(1.0);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN SIMULATOR ");
            }
        }
    }

    public static Instances simulateData(String str, int seed) throws RuntimeException {
        Instances data;
        Model.setGlobalRandomSeed(seed);
        switch (str) {
            case "ARMA": 
            case "AR": {
                data = SimulateSpectralData.generateARDataSet(seriesLength, casesPerClass, true);
                break;
            }
            case "Shapelet": {
                data = SimulateShapeletData.generateShapeletData(seriesLength, casesPerClass);
                break;
            }
            case "Dictionary": {
                data = SimulateDictionaryData.generateDictionaryData(seriesLength, casesPerClass);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN SIMULATOR ");
            }
        }
        return data;
    }

    public static double singleSampleExperiment(Instances train, Instances test, Classifier c, int sample, String preds) {
        double acc = 0.0;
        OutFile p = new OutFile(preds + "/testFold" + sample + ".csv");
        if (c instanceof TrainAccuracyEstimate) {
            ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(preds + "/trainFold" + sample + ".csv");
        }
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(preds + "/internalCV_" + sample + ".csv", preds + "/internalTestPreds_" + sample + ".csv");
        }
        try {
            int j;
            c.buildClassifier(train);
            int[][] predictions = new int[test.numInstances()][2];
            for (j = 0; j < test.numInstances(); ++j) {
                predictions[j][0] = (int)test.instance(j).classValue();
                test.instance(j).setMissing(test.classIndex());
            }
            for (j = 0; j < test.numInstances(); ++j) {
                predictions[j][1] = (int)c.classifyInstance(test.instance(j));
                if (predictions[j][0] != predictions[j][1]) continue;
                acc += 1.0;
            }
            acc /= (double)test.numInstances();
            String[] names = preds.split("/");
            p.writeLine(names[names.length - 1] + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else if (c instanceof SaveableEnsemble) {
                p.writeLine(((SaveableEnsemble)((Object)c)).getParameters());
            } else {
                p.writeLine("NoParameterInfo");
            }
            p.writeLine(acc + "");
            for (int j2 = 0; j2 < test.numInstances(); ++j2) {
                double[] dist;
                p.writeString(predictions[j2][0] + "," + predictions[j2][1] + ",");
                for (double d : dist = c.distributionForInstance(test.instance(j2))) {
                    p.writeString("," + d);
                }
                p.writeString("\n");
            }
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes and " + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void runShapeletSimulatorExperiment() {
        Model.setDefaultSigma(1.0);
        seriesLength = 300;
        casesPerClass = new int[]{50, 50};
        String[] classifiers = new String[]{"RotF", "DTW", "FastShapelets", "ST", "BOSS"};
        OutFile of = new OutFile("C:\\Temp\\ShapeletSimExperiment.csv");
        SimulationExperiments.setStandardGlobalParameters("Shapelet");
        of.writeLine("Shapelet Sim, series length= " + seriesLength + " cases class 0 =" + casesPerClass[0] + " class 1" + casesPerClass[0] + " train proportion = " + trainProp);
        of.writeString("Rep");
        for (String s : classifiers) {
            of.writeString("," + s);
        }
        of.writeString("\n");
        for (int i = 0; i < 100; ++i) {
            of.writeString(i + ",");
            Model.setGlobalRandomSeed(i);
            Instances data = SimulateShapeletData.generateShapeletData(seriesLength, casesPerClass);
            Instances[] split = InstanceTools.resampleInstances(data, i, trainProp);
            String[] stringArray = classifiers;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                AbstractClassifier c;
                String str;
                switch (str = stringArray[j]) {
                    case "RotF": {
                        c = new RotationForest();
                        break;
                    }
                    case "DTW": {
                        c = new FastDTW_1NN();
                        break;
                    }
                    case "EE": {
                        c = new ElasticEnsemble();
                        break;
                    }
                    case "TSF": {
                        c = new TSF();
                        break;
                    }
                    case "TSBF": {
                        c = new TSBF();
                        break;
                    }
                    case "FastShapelets": {
                        c = new FastShapelets();
                        break;
                    }
                    case "ST": {
                        c = new ST_HESCA();
                        ((ST_HESCA)c).setOneHourLimit();
                        break;
                    }
                    case "LearnShapelets": {
                        c = new LearnShapelets();
                        break;
                    }
                    case "BOP": {
                        c = new BagOfPatterns();
                        break;
                    }
                    case "BOSS": {
                        c = new BOSS();
                        break;
                    }
                    case "COTE": {
                        c = new FlatCote();
                        break;
                    }
                    case "RISE": {
                        c = new RISE();
                        ((RISE)c).setTransformType("PS_ACF");
                        ((RISE)c).setNosBaseClassifiers(500);
                        break;
                    }
                    default: {
                        throw new RuntimeException(" UNKNOWN CLASSIFIER " + str);
                    }
                }
                double acc = ClassifierTools.singleTrainTestSplitAccuracy(c, split[0], split[1]);
                of.writeString(acc + ",");
                System.out.println(i + " " + str + " acc =" + acc);
            }
            of.writeString("\n");
        }
    }

    public static void main(String[] args) {
        DataSets.resultsPath = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\";
        SimulationExperiments.runShapeletSimulatorExperiment();
    }
}

